// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The action to publish the email content to an Amazon SNS topic. When executed, this action will send the email as a notification to the specified SNS topic.
 */
public class SnsAction private constructor(builder: Builder) {
    /**
     * A policy that states what to do in the case of failure. The action will fail if there are configuration errors. For example, specified SNS topic has been deleted or the role lacks necessary permissions to call the `sns:Publish` API.
     */
    public val actionFailurePolicy: aws.sdk.kotlin.services.mailmanager.model.ActionFailurePolicy? = builder.actionFailurePolicy
    /**
     * The encoding to use for the email within the Amazon SNS notification. The default value is `UTF-8`. Use `BASE64` if you need to preserve all special characters, especially when the original message uses a different encoding format.
     */
    public val encoding: aws.sdk.kotlin.services.mailmanager.model.SnsNotificationEncoding = builder.encoding
    /**
     * The expected payload type within the Amazon SNS notification. `CONTENT` attempts to publish the full email content with 20KB of headers content. `HEADERS` extracts up to 100KB of header content to include in the notification, email content will not be included to the notification. The default value is `CONTENT`.
     */
    public val payloadType: aws.sdk.kotlin.services.mailmanager.model.SnsNotificationPayloadType = builder.payloadType
    /**
     * The Amazon Resource Name (ARN) of the IAM Role to use while writing to Amazon SNS. This role must have access to the `sns:Publish` API for the given topic.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS Topic to which notification for the email received will be published.
     */
    public val topicArn: kotlin.String = requireNotNull(builder.topicArn) { "A non-null value must be provided for topicArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mailmanager.model.SnsAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SnsAction(")
        append("actionFailurePolicy=$actionFailurePolicy,")
        append("encoding=$encoding,")
        append("payloadType=$payloadType,")
        append("roleArn=$roleArn,")
        append("topicArn=$topicArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionFailurePolicy?.hashCode() ?: 0
        result = 31 * result + (encoding.hashCode())
        result = 31 * result + (payloadType.hashCode())
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (topicArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SnsAction

        if (actionFailurePolicy != other.actionFailurePolicy) return false
        if (encoding != other.encoding) return false
        if (payloadType != other.payloadType) return false
        if (roleArn != other.roleArn) return false
        if (topicArn != other.topicArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mailmanager.model.SnsAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A policy that states what to do in the case of failure. The action will fail if there are configuration errors. For example, specified SNS topic has been deleted or the role lacks necessary permissions to call the `sns:Publish` API.
         */
        public var actionFailurePolicy: aws.sdk.kotlin.services.mailmanager.model.ActionFailurePolicy? = null
        /**
         * The encoding to use for the email within the Amazon SNS notification. The default value is `UTF-8`. Use `BASE64` if you need to preserve all special characters, especially when the original message uses a different encoding format.
         */
        public var encoding: aws.sdk.kotlin.services.mailmanager.model.SnsNotificationEncoding = aws.sdk.kotlin.services.mailmanager.model.SnsNotificationEncoding.fromValue("UTF-8")
        /**
         * The expected payload type within the Amazon SNS notification. `CONTENT` attempts to publish the full email content with 20KB of headers content. `HEADERS` extracts up to 100KB of header content to include in the notification, email content will not be included to the notification. The default value is `CONTENT`.
         */
        public var payloadType: aws.sdk.kotlin.services.mailmanager.model.SnsNotificationPayloadType = aws.sdk.kotlin.services.mailmanager.model.SnsNotificationPayloadType.fromValue("CONTENT")
        /**
         * The Amazon Resource Name (ARN) of the IAM Role to use while writing to Amazon SNS. This role must have access to the `sns:Publish` API for the given topic.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS Topic to which notification for the email received will be published.
         */
        public var topicArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mailmanager.model.SnsAction) : this() {
            this.actionFailurePolicy = x.actionFailurePolicy
            this.encoding = x.encoding
            this.payloadType = x.payloadType
            this.roleArn = x.roleArn
            this.topicArn = x.topicArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mailmanager.model.SnsAction = SnsAction(this)

        internal fun correctErrors(): Builder {
            if (roleArn == null) roleArn = ""
            if (topicArn == null) topicArn = ""
            return this
        }
    }
}
