// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Writes the MIME content of the email to an S3 bucket.
 */
public class S3Action private constructor(builder: Builder) {
    /**
     * A policy that states what to do in the case of failure. The action will fail if there are configuration errors. For example, the specified the bucket has been deleted.
     */
    public val actionFailurePolicy: aws.sdk.kotlin.services.mailmanager.model.ActionFailurePolicy? = builder.actionFailurePolicy
    /**
     * The Amazon Resource Name (ARN) of the IAM Role to use while writing to S3. This role must have access to the s3:PutObject, kms:Encrypt, and kms:GenerateDataKey APIs for the given bucket.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The bucket name of the S3 bucket to write to.
     */
    public val s3Bucket: kotlin.String = requireNotNull(builder.s3Bucket) { "A non-null value must be provided for s3Bucket" }
    /**
     * The S3 prefix to use for the write to the s3 bucket.
     */
    public val s3Prefix: kotlin.String? = builder.s3Prefix
    /**
     * The KMS Key ID to use to encrypt the message in S3.
     */
    public val s3SseKmsKeyId: kotlin.String? = builder.s3SseKmsKeyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mailmanager.model.S3Action = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Action(")
        append("actionFailurePolicy=$actionFailurePolicy,")
        append("roleArn=$roleArn,")
        append("s3Bucket=$s3Bucket,")
        append("s3Prefix=$s3Prefix,")
        append("s3SseKmsKeyId=$s3SseKmsKeyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionFailurePolicy?.hashCode() ?: 0
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (s3Bucket.hashCode())
        result = 31 * result + (s3Prefix?.hashCode() ?: 0)
        result = 31 * result + (s3SseKmsKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Action

        if (actionFailurePolicy != other.actionFailurePolicy) return false
        if (roleArn != other.roleArn) return false
        if (s3Bucket != other.s3Bucket) return false
        if (s3Prefix != other.s3Prefix) return false
        if (s3SseKmsKeyId != other.s3SseKmsKeyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mailmanager.model.S3Action = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A policy that states what to do in the case of failure. The action will fail if there are configuration errors. For example, the specified the bucket has been deleted.
         */
        public var actionFailurePolicy: aws.sdk.kotlin.services.mailmanager.model.ActionFailurePolicy? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM Role to use while writing to S3. This role must have access to the s3:PutObject, kms:Encrypt, and kms:GenerateDataKey APIs for the given bucket.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The bucket name of the S3 bucket to write to.
         */
        public var s3Bucket: kotlin.String? = null
        /**
         * The S3 prefix to use for the write to the s3 bucket.
         */
        public var s3Prefix: kotlin.String? = null
        /**
         * The KMS Key ID to use to encrypt the message in S3.
         */
        public var s3SseKmsKeyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mailmanager.model.S3Action) : this() {
            this.actionFailurePolicy = x.actionFailurePolicy
            this.roleArn = x.roleArn
            this.s3Bucket = x.s3Bucket
            this.s3Prefix = x.s3Prefix
            this.s3SseKmsKeyId = x.s3SseKmsKeyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mailmanager.model.S3Action = S3Action(this)

        internal fun correctErrors(): Builder {
            if (roleArn == null) roleArn = ""
            if (s3Bucket == null) s3Bucket = ""
            return this
        }
    }
}
