// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An IP address expression matching certain IP addresses within a given range of IP addresses.
 */
public class RuleIpExpression private constructor(builder: Builder) {
    /**
     * The IP address to evaluate in this condition.
     */
    public val evaluate: aws.sdk.kotlin.services.mailmanager.model.RuleIpToEvaluate? = builder.evaluate
    /**
     * The operator to evaluate the IP address.
     */
    public val operator: aws.sdk.kotlin.services.mailmanager.model.RuleIpOperator = requireNotNull(builder.operator) { "A non-null value must be provided for operator" }
    /**
     * The IP CIDR blocks in format "x.y.z.w/n" (eg 10.0.0.0/8) to match with the email's IP address. For the operator CIDR_MATCHES, if multiple values are given, they are evaluated as an OR. That is, if the IP address is contained within any of the given CIDR ranges, the condition is deemed to match. For NOT_CIDR_MATCHES, if multiple CIDR ranges are given, the condition is deemed to match if the IP address is not contained in any of the given CIDR ranges.
     */
    public val values: List<String> = requireNotNull(builder.values) { "A non-null value must be provided for values" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mailmanager.model.RuleIpExpression = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleIpExpression(")
        append("evaluate=$evaluate,")
        append("operator=$operator,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = evaluate?.hashCode() ?: 0
        result = 31 * result + (operator.hashCode())
        result = 31 * result + (values.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuleIpExpression

        if (evaluate != other.evaluate) return false
        if (operator != other.operator) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mailmanager.model.RuleIpExpression = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The IP address to evaluate in this condition.
         */
        public var evaluate: aws.sdk.kotlin.services.mailmanager.model.RuleIpToEvaluate? = null
        /**
         * The operator to evaluate the IP address.
         */
        public var operator: aws.sdk.kotlin.services.mailmanager.model.RuleIpOperator? = null
        /**
         * The IP CIDR blocks in format "x.y.z.w/n" (eg 10.0.0.0/8) to match with the email's IP address. For the operator CIDR_MATCHES, if multiple values are given, they are evaluated as an OR. That is, if the IP address is contained within any of the given CIDR ranges, the condition is deemed to match. For NOT_CIDR_MATCHES, if multiple CIDR ranges are given, the condition is deemed to match if the IP address is not contained in any of the given CIDR ranges.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mailmanager.model.RuleIpExpression) : this() {
            this.evaluate = x.evaluate
            this.operator = x.operator
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mailmanager.model.RuleIpExpression = RuleIpExpression(this)

        internal fun correctErrors(): Builder {
            if (operator == null) operator = RuleIpOperator.SdkUnknown("no value provided")
            if (values == null) values = emptyList()
            return this
        }
    }
}
