// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A DMARC policy expression. The condition matches if the given DMARC policy matches that of the incoming email.
 */
public class RuleDmarcExpression private constructor(builder: Builder) {
    /**
     * The operator to apply to the DMARC policy of the incoming email.
     */
    public val operator: aws.sdk.kotlin.services.mailmanager.model.RuleDmarcOperator = requireNotNull(builder.operator) { "A non-null value must be provided for operator" }
    /**
     * The values to use for the given DMARC policy operator. For the operator EQUALS, if multiple values are given, they are evaluated as an OR. That is, if any of the given values match, the condition is deemed to match. For the operator NOT_EQUALS, if multiple values are given, they are evaluated as an AND. That is, only if the email's DMARC policy is not equal to any of the given values, then the condition is deemed to match.
     */
    public val values: List<RuleDmarcPolicy> = requireNotNull(builder.values) { "A non-null value must be provided for values" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mailmanager.model.RuleDmarcExpression = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleDmarcExpression(")
        append("operator=$operator,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = operator.hashCode()
        result = 31 * result + (values.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuleDmarcExpression

        if (operator != other.operator) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mailmanager.model.RuleDmarcExpression = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The operator to apply to the DMARC policy of the incoming email.
         */
        public var operator: aws.sdk.kotlin.services.mailmanager.model.RuleDmarcOperator? = null
        /**
         * The values to use for the given DMARC policy operator. For the operator EQUALS, if multiple values are given, they are evaluated as an OR. That is, if any of the given values match, the condition is deemed to match. For the operator NOT_EQUALS, if multiple values are given, they are evaluated as an AND. That is, only if the email's DMARC policy is not equal to any of the given values, then the condition is deemed to match.
         */
        public var values: List<RuleDmarcPolicy>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mailmanager.model.RuleDmarcExpression) : this() {
            this.operator = x.operator
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mailmanager.model.RuleDmarcExpression = RuleDmarcExpression(this)

        internal fun correctErrors(): Builder {
            if (operator == null) operator = RuleDmarcOperator.SdkUnknown("no value provided")
            if (values == null) values = emptyList()
            return this
        }
    }
}
