// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The structure of an ingress endpoint resource.
 */
public class IngressPoint private constructor(builder: Builder) {
    /**
     * The DNS A Record that identifies your ingress endpoint. Configure your DNS Mail Exchange (MX) record with this value to route emails to Mail Manager.
     */
    public val aRecord: kotlin.String? = builder.aRecord
    /**
     * The identifier of the ingress endpoint resource.
     */
    public val ingressPointId: kotlin.String = requireNotNull(builder.ingressPointId) { "A non-null value must be provided for ingressPointId" }
    /**
     * A user friendly name for the ingress endpoint resource.
     */
    public val ingressPointName: kotlin.String = requireNotNull(builder.ingressPointName) { "A non-null value must be provided for ingressPointName" }
    /**
     * The status of the ingress endpoint resource.
     */
    public val status: aws.sdk.kotlin.services.mailmanager.model.IngressPointStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The type of ingress endpoint resource.
     */
    public val type: aws.sdk.kotlin.services.mailmanager.model.IngressPointType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mailmanager.model.IngressPoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IngressPoint(")
        append("aRecord=$aRecord,")
        append("ingressPointId=$ingressPointId,")
        append("ingressPointName=$ingressPointName,")
        append("status=$status,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aRecord?.hashCode() ?: 0
        result = 31 * result + (ingressPointId.hashCode())
        result = 31 * result + (ingressPointName.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IngressPoint

        if (aRecord != other.aRecord) return false
        if (ingressPointId != other.ingressPointId) return false
        if (ingressPointName != other.ingressPointName) return false
        if (status != other.status) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mailmanager.model.IngressPoint = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The DNS A Record that identifies your ingress endpoint. Configure your DNS Mail Exchange (MX) record with this value to route emails to Mail Manager.
         */
        public var aRecord: kotlin.String? = null
        /**
         * The identifier of the ingress endpoint resource.
         */
        public var ingressPointId: kotlin.String? = null
        /**
         * A user friendly name for the ingress endpoint resource.
         */
        public var ingressPointName: kotlin.String? = null
        /**
         * The status of the ingress endpoint resource.
         */
        public var status: aws.sdk.kotlin.services.mailmanager.model.IngressPointStatus? = null
        /**
         * The type of ingress endpoint resource.
         */
        public var type: aws.sdk.kotlin.services.mailmanager.model.IngressPointType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mailmanager.model.IngressPoint) : this() {
            this.aRecord = x.aRecord
            this.ingressPointId = x.ingressPointId
            this.ingressPointName = x.ingressPointName
            this.status = x.status
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mailmanager.model.IngressPoint = IngressPoint(this)

        internal fun correctErrors(): Builder {
            if (ingressPointId == null) ingressPointId = ""
            if (ingressPointName == null) ingressPointName = ""
            if (status == null) status = IngressPointStatus.SdkUnknown("no value provided")
            if (type == null) type = IngressPointType.SdkUnknown("no value provided")
            return this
        }
    }
}
