// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetAddressListResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the address list resource.
     */
    public val addressListArn: kotlin.String = requireNotNull(builder.addressListArn) { "A non-null value must be provided for addressListArn" }
    /**
     * The identifier of the address list resource.
     */
    public val addressListId: kotlin.String = requireNotNull(builder.addressListId) { "A non-null value must be provided for addressListId" }
    /**
     * A user-friendly name for the address list resource.
     */
    public val addressListName: kotlin.String = requireNotNull(builder.addressListName) { "A non-null value must be provided for addressListName" }
    /**
     * The date of when then address list was created.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdTimestamp) { "A non-null value must be provided for createdTimestamp" }
    /**
     * The date of when the address list was last updated.
     */
    public val lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedTimestamp) { "A non-null value must be provided for lastUpdatedTimestamp" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mailmanager.model.GetAddressListResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetAddressListResponse(")
        append("addressListArn=$addressListArn,")
        append("addressListId=$addressListId,")
        append("addressListName=$addressListName,")
        append("createdTimestamp=$createdTimestamp,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressListArn.hashCode()
        result = 31 * result + (addressListId.hashCode())
        result = 31 * result + (addressListName.hashCode())
        result = 31 * result + (createdTimestamp.hashCode())
        result = 31 * result + (lastUpdatedTimestamp.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetAddressListResponse

        if (addressListArn != other.addressListArn) return false
        if (addressListId != other.addressListId) return false
        if (addressListName != other.addressListName) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mailmanager.model.GetAddressListResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the address list resource.
         */
        public var addressListArn: kotlin.String? = null
        /**
         * The identifier of the address list resource.
         */
        public var addressListId: kotlin.String? = null
        /**
         * A user-friendly name for the address list resource.
         */
        public var addressListName: kotlin.String? = null
        /**
         * The date of when then address list was created.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date of when the address list was last updated.
         */
        public var lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mailmanager.model.GetAddressListResponse) : this() {
            this.addressListArn = x.addressListArn
            this.addressListId = x.addressListId
            this.addressListName = x.addressListName
            this.createdTimestamp = x.createdTimestamp
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mailmanager.model.GetAddressListResponse = GetAddressListResponse(this)

        internal fun correctErrors(): Builder {
            if (addressListArn == null) addressListArn = ""
            if (addressListId == null) addressListId = ""
            if (addressListName == null) addressListName = ""
            if (createdTimestamp == null) createdTimestamp = Instant.fromEpochSeconds(0)
            if (lastUpdatedTimestamp == null) lastUpdatedTimestamp = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
