// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetAddressListImportJobResponse private constructor(builder: Builder) {
    /**
     * The unique identifier of the address list the import job was created for.
     */
    public val addressListId: kotlin.String = requireNotNull(builder.addressListId) { "A non-null value must be provided for addressListId" }
    /**
     * The timestamp of when the import job was completed.
     */
    public val completedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.completedTimestamp
    /**
     * The timestamp of when the import job was created.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdTimestamp) { "A non-null value must be provided for createdTimestamp" }
    /**
     * The reason for failure of an import job.
     */
    public val error: kotlin.String? = builder.error
    /**
     * The number of input addresses that failed to be imported into the address list.
     */
    public val failedItemsCount: kotlin.Int? = builder.failedItemsCount
    /**
     * The format of the input for an import job.
     */
    public val importDataFormat: aws.sdk.kotlin.services.mailmanager.model.ImportDataFormat? = builder.importDataFormat
    /**
     * The number of input addresses successfully imported into the address list.
     */
    public val importedItemsCount: kotlin.Int? = builder.importedItemsCount
    /**
     * The identifier of the import job.
     */
    public val jobId: kotlin.String = requireNotNull(builder.jobId) { "A non-null value must be provided for jobId" }
    /**
     * A user-friendly name for the import job.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The pre-signed URL target for uploading the input file.
     */
    public val preSignedUrl: kotlin.String = requireNotNull(builder.preSignedUrl) { "A non-null value must be provided for preSignedUrl" }
    /**
     * The timestamp of when the import job was started.
     */
    public val startTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.startTimestamp
    /**
     * The status of the import job.
     */
    public val status: aws.sdk.kotlin.services.mailmanager.model.ImportJobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mailmanager.model.GetAddressListImportJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetAddressListImportJobResponse(")
        append("addressListId=$addressListId,")
        append("completedTimestamp=$completedTimestamp,")
        append("createdTimestamp=$createdTimestamp,")
        append("error=$error,")
        append("failedItemsCount=$failedItemsCount,")
        append("importDataFormat=$importDataFormat,")
        append("importedItemsCount=$importedItemsCount,")
        append("jobId=$jobId,")
        append("name=$name,")
        append("preSignedUrl=*** Sensitive Data Redacted ***,")
        append("startTimestamp=$startTimestamp,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressListId.hashCode()
        result = 31 * result + (completedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp.hashCode())
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (failedItemsCount ?: 0)
        result = 31 * result + (importDataFormat?.hashCode() ?: 0)
        result = 31 * result + (importedItemsCount ?: 0)
        result = 31 * result + (jobId.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (preSignedUrl.hashCode())
        result = 31 * result + (startTimestamp?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetAddressListImportJobResponse

        if (addressListId != other.addressListId) return false
        if (completedTimestamp != other.completedTimestamp) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (error != other.error) return false
        if (failedItemsCount != other.failedItemsCount) return false
        if (importDataFormat != other.importDataFormat) return false
        if (importedItemsCount != other.importedItemsCount) return false
        if (jobId != other.jobId) return false
        if (name != other.name) return false
        if (preSignedUrl != other.preSignedUrl) return false
        if (startTimestamp != other.startTimestamp) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mailmanager.model.GetAddressListImportJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier of the address list the import job was created for.
         */
        public var addressListId: kotlin.String? = null
        /**
         * The timestamp of when the import job was completed.
         */
        public var completedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp of when the import job was created.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The reason for failure of an import job.
         */
        public var error: kotlin.String? = null
        /**
         * The number of input addresses that failed to be imported into the address list.
         */
        public var failedItemsCount: kotlin.Int? = null
        /**
         * The format of the input for an import job.
         */
        public var importDataFormat: aws.sdk.kotlin.services.mailmanager.model.ImportDataFormat? = null
        /**
         * The number of input addresses successfully imported into the address list.
         */
        public var importedItemsCount: kotlin.Int? = null
        /**
         * The identifier of the import job.
         */
        public var jobId: kotlin.String? = null
        /**
         * A user-friendly name for the import job.
         */
        public var name: kotlin.String? = null
        /**
         * The pre-signed URL target for uploading the input file.
         */
        public var preSignedUrl: kotlin.String? = null
        /**
         * The timestamp of when the import job was started.
         */
        public var startTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the import job.
         */
        public var status: aws.sdk.kotlin.services.mailmanager.model.ImportJobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mailmanager.model.GetAddressListImportJobResponse) : this() {
            this.addressListId = x.addressListId
            this.completedTimestamp = x.completedTimestamp
            this.createdTimestamp = x.createdTimestamp
            this.error = x.error
            this.failedItemsCount = x.failedItemsCount
            this.importDataFormat = x.importDataFormat
            this.importedItemsCount = x.importedItemsCount
            this.jobId = x.jobId
            this.name = x.name
            this.preSignedUrl = x.preSignedUrl
            this.startTimestamp = x.startTimestamp
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mailmanager.model.GetAddressListImportJobResponse = GetAddressListImportJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.mailmanager.model.ImportDataFormat] inside the given [block]
         */
        public fun importDataFormat(block: aws.sdk.kotlin.services.mailmanager.model.ImportDataFormat.Builder.() -> kotlin.Unit) {
            this.importDataFormat = aws.sdk.kotlin.services.mailmanager.model.ImportDataFormat.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (addressListId == null) addressListId = ""
            if (createdTimestamp == null) createdTimestamp = Instant.fromEpochSeconds(0)
            if (jobId == null) jobId = ""
            if (name == null) name = ""
            if (preSignedUrl == null) preSignedUrl = ""
            if (status == null) status = ImportJobStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
