// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The request to create a new email archive.
 */
public class CreateArchiveRequest private constructor(builder: Builder) {
    /**
     * A unique name for the new archive.
     */
    public val archiveName: kotlin.String? = builder.archiveName
    /**
     * A unique token Amazon SES uses to recognize retries of this request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The Amazon Resource Name (ARN) of the KMS key for encrypting emails in the archive.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The period for retaining emails in the archive before automatic deletion.
     */
    public val retention: aws.sdk.kotlin.services.mailmanager.model.ArchiveRetention? = builder.retention
    /**
     * The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mailmanager.model.CreateArchiveRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateArchiveRequest(")
        append("archiveName=$archiveName,")
        append("clientToken=$clientToken,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("retention=$retention,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = archiveName?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (retention?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateArchiveRequest

        if (archiveName != other.archiveName) return false
        if (clientToken != other.clientToken) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (retention != other.retention) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mailmanager.model.CreateArchiveRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique name for the new archive.
         */
        public var archiveName: kotlin.String? = null
        /**
         * A unique token Amazon SES uses to recognize retries of this request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the KMS key for encrypting emails in the archive.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The period for retaining emails in the archive before automatic deletion.
         */
        public var retention: aws.sdk.kotlin.services.mailmanager.model.ArchiveRetention? = null
        /**
         * The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mailmanager.model.CreateArchiveRequest) : this() {
            this.archiveName = x.archiveName
            this.clientToken = x.clientToken
            this.kmsKeyArn = x.kmsKeyArn
            this.retention = x.retention
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mailmanager.model.CreateArchiveRequest = CreateArchiveRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
