// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An archive resource for storing and retaining emails.
 */
public class Archive private constructor(builder: Builder) {
    /**
     * The unique identifier of the archive.
     */
    public val archiveId: kotlin.String = requireNotNull(builder.archiveId) { "A non-null value must be provided for archiveId" }
    /**
     * The unique name assigned to the archive.
     */
    public val archiveName: kotlin.String? = builder.archiveName
    /**
     * The current state of the archive:
     * + `ACTIVE` – The archive is ready and available for use.
     * + `PENDING_DELETION` – The archive has been marked for deletion and will be permanently deleted in 30 days. No further modifications can be made in this state.
     */
    public val archiveState: aws.sdk.kotlin.services.mailmanager.model.ArchiveState? = builder.archiveState
    /**
     * The timestamp of when the archive was last updated.
     */
    public val lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTimestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mailmanager.model.Archive = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Archive(")
        append("archiveId=$archiveId,")
        append("archiveName=$archiveName,")
        append("archiveState=$archiveState,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = archiveId.hashCode()
        result = 31 * result + (archiveName?.hashCode() ?: 0)
        result = 31 * result + (archiveState?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Archive

        if (archiveId != other.archiveId) return false
        if (archiveName != other.archiveName) return false
        if (archiveState != other.archiveState) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mailmanager.model.Archive = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier of the archive.
         */
        public var archiveId: kotlin.String? = null
        /**
         * The unique name assigned to the archive.
         */
        public var archiveName: kotlin.String? = null
        /**
         * The current state of the archive:
         * + `ACTIVE` – The archive is ready and available for use.
         * + `PENDING_DELETION` – The archive has been marked for deletion and will be permanently deleted in 30 days. No further modifications can be made in this state.
         */
        public var archiveState: aws.sdk.kotlin.services.mailmanager.model.ArchiveState? = null
        /**
         * The timestamp of when the archive was last updated.
         */
        public var lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mailmanager.model.Archive) : this() {
            this.archiveId = x.archiveId
            this.archiveName = x.archiveName
            this.archiveState = x.archiveState
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mailmanager.model.Archive = Archive(this)

        internal fun correctErrors(): Builder {
            if (archiveId == null) archiveId = ""
            return this
        }
    }
}
