// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.serde

import aws.sdk.kotlin.services.mailmanager.model.GetRuleSetResponse
import aws.sdk.kotlin.services.mailmanager.model.MailManagerException
import aws.sdk.kotlin.services.mailmanager.model.Rule
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class GetRuleSetOperationDeserializer: HttpDeserializer.NonStreaming<GetRuleSetResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetRuleSetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetRuleSetError(context, call, payload)
        }
        val builder = GetRuleSetResponse.Builder()

        if (payload != null) {
            deserializeGetRuleSetOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetRuleSetError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MailManagerException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MailManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRuleSetOperationBody(builder: GetRuleSetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedDate"))
    val LASTMODIFICATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModificationDate"))
    val RULESETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RuleSetArn"))
    val RULESETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RuleSetId"))
    val RULESETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RuleSetName"))
    val RULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Rules"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDDATE_DESCRIPTOR)
        field(LASTMODIFICATIONDATE_DESCRIPTOR)
        field(RULESETARN_DESCRIPTOR)
        field(RULESETID_DESCRIPTOR)
        field(RULESETNAME_DESCRIPTOR)
        field(RULES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LASTMODIFICATIONDATE_DESCRIPTOR.index -> builder.lastModificationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                RULESETARN_DESCRIPTOR.index -> builder.ruleSetArn = deserializeString()
                RULESETID_DESCRIPTOR.index -> builder.ruleSetId = deserializeString()
                RULESETNAME_DESCRIPTOR.index -> builder.ruleSetName = deserializeString()
                RULES_DESCRIPTOR.index -> builder.rules =
                    deserializer.deserializeList(RULES_DESCRIPTOR) {
                        val col0 = mutableListOf<Rule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRuleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
