// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.serde

import aws.sdk.kotlin.services.mailmanager.model.GetIngressPointResponse
import aws.sdk.kotlin.services.mailmanager.model.IngressPointAuthConfiguration
import aws.sdk.kotlin.services.mailmanager.model.IngressPointStatus
import aws.sdk.kotlin.services.mailmanager.model.IngressPointType
import aws.sdk.kotlin.services.mailmanager.model.MailManagerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetIngressPointOperationDeserializer: HttpDeserializer.NonStreaming<GetIngressPointResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetIngressPointResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetIngressPointError(context, call, payload)
        }
        val builder = GetIngressPointResponse.Builder()

        if (payload != null) {
            deserializeGetIngressPointOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetIngressPointError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MailManagerException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MailManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetIngressPointOperationBody(builder: GetIngressPointResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARECORD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ARecord"))
    val CREATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTimestamp"))
    val INGRESSPOINTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IngressPointArn"))
    val INGRESSPOINTAUTHCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("IngressPointAuthConfiguration"))
    val INGRESSPOINTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IngressPointId"))
    val INGRESSPOINTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IngressPointName"))
    val LASTUPDATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdatedTimestamp"))
    val RULESETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RuleSetId"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val TRAFFICPOLICYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrafficPolicyId"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARECORD_DESCRIPTOR)
        field(CREATEDTIMESTAMP_DESCRIPTOR)
        field(INGRESSPOINTARN_DESCRIPTOR)
        field(INGRESSPOINTAUTHCONFIGURATION_DESCRIPTOR)
        field(INGRESSPOINTID_DESCRIPTOR)
        field(INGRESSPOINTNAME_DESCRIPTOR)
        field(LASTUPDATEDTIMESTAMP_DESCRIPTOR)
        field(RULESETID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TRAFFICPOLICYID_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARECORD_DESCRIPTOR.index -> builder.aRecord = deserializeString()
                CREATEDTIMESTAMP_DESCRIPTOR.index -> builder.createdTimestamp = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                INGRESSPOINTARN_DESCRIPTOR.index -> builder.ingressPointArn = deserializeString()
                INGRESSPOINTAUTHCONFIGURATION_DESCRIPTOR.index -> builder.ingressPointAuthConfiguration = deserializeIngressPointAuthConfigurationDocument(deserializer)
                INGRESSPOINTID_DESCRIPTOR.index -> builder.ingressPointId = deserializeString()
                INGRESSPOINTNAME_DESCRIPTOR.index -> builder.ingressPointName = deserializeString()
                LASTUPDATEDTIMESTAMP_DESCRIPTOR.index -> builder.lastUpdatedTimestamp = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                RULESETID_DESCRIPTOR.index -> builder.ruleSetId = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { IngressPointStatus.fromValue(it) }
                TRAFFICPOLICYID_DESCRIPTOR.index -> builder.trafficPolicyId = deserializeString()
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { IngressPointType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
