// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A rule contains conditions, "unless conditions" and actions. For each envelope recipient of an email, if all conditions match and none of the "unless conditions" match, then all of the actions are executed sequentially. If no conditions are provided, the rule always applies and the actions are implicitly executed. If only "unless conditions" are provided, the rule applies if the email does not match the evaluation of the "unless conditions".
 */
public class Rule private constructor(builder: Builder) {
    /**
     * The list of actions to execute when the conditions match the incoming email, and none of the "unless conditions" match.
     */
    public val actions: List<RuleAction> = requireNotNull(builder.actions) { "A non-null value must be provided for actions" }
    /**
     * The conditions of this rule. All conditions must match the email for the actions to be executed. An empty list of conditions means that all emails match, but are still subject to any "unless conditions"
     */
    public val conditions: List<RuleCondition>? = builder.conditions
    /**
     * The user-friendly name of the rule.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The "unless conditions" of this rule. None of the conditions can match the email for the actions to be executed. If any of these conditions do match the email, then the actions are not executed.
     */
    public val unless: List<RuleCondition>? = builder.unless

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mailmanager.model.Rule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Rule(")
        append("actions=$actions,")
        append("conditions=$conditions,")
        append("name=$name,")
        append("unless=$unless")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions.hashCode()
        result = 31 * result + (conditions?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (unless?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Rule

        if (actions != other.actions) return false
        if (conditions != other.conditions) return false
        if (name != other.name) return false
        if (unless != other.unless) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mailmanager.model.Rule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of actions to execute when the conditions match the incoming email, and none of the "unless conditions" match.
         */
        public var actions: List<RuleAction>? = null
        /**
         * The conditions of this rule. All conditions must match the email for the actions to be executed. An empty list of conditions means that all emails match, but are still subject to any "unless conditions"
         */
        public var conditions: List<RuleCondition>? = null
        /**
         * The user-friendly name of the rule.
         */
        public var name: kotlin.String? = null
        /**
         * The "unless conditions" of this rule. None of the conditions can match the email for the actions to be executed. If any of these conditions do match the email, then the actions are not executed.
         */
        public var unless: List<RuleCondition>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mailmanager.model.Rule) : this() {
            this.actions = x.actions
            this.conditions = x.conditions
            this.name = x.name
            this.unless = x.unless
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mailmanager.model.Rule = Rule(this)

        internal fun correctErrors(): Builder {
            if (actions == null) actions = emptyList()
            return this
        }
    }
}
