// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The metadata about the email.
 */
public class Metadata private constructor(builder: Builder) {
    /**
     * The name of the configuration set used when sent through a configuration set with archiving enabled.
     */
    public val configurationSet: kotlin.String? = builder.configurationSet
    /**
     * The ID of the ingress endpoint through which the email was received.
     */
    public val ingressPointId: kotlin.String? = builder.ingressPointId
    /**
     * The ID of the rule set that processed the email.
     */
    public val ruleSetId: kotlin.String? = builder.ruleSetId
    /**
     * The name of the host from which the email was received.
     */
    public val senderHostname: kotlin.String? = builder.senderHostname
    /**
     * The IP address of the host from which the email was received.
     */
    public val senderIpAddress: kotlin.String? = builder.senderIpAddress
    /**
     * The name of the API call used when sent through a configuration set with archiving enabled.
     */
    public val sendingMethod: kotlin.String? = builder.sendingMethod
    /**
     * The name of the dedicated IP pool used when sent through a configuration set with archiving enabled.
     */
    public val sendingPool: kotlin.String? = builder.sendingPool
    /**
     * Specifies the archived email source, identified by either a Rule Set's ARN with an Archive action, or a Configuration Set's Archive ARN.
     */
    public val sourceArn: kotlin.String? = builder.sourceArn
    /**
     * The identity name used to authorize the sending action when sent through a configuration set with archiving enabled.
     */
    public val sourceIdentity: kotlin.String? = builder.sourceIdentity
    /**
     * The timestamp of when the email was received.
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp
    /**
     * The TLS cipher suite used to communicate with the host from which the email was received.
     */
    public val tlsCipherSuite: kotlin.String? = builder.tlsCipherSuite
    /**
     * The TLS protocol used to communicate with the host from which the email was received.
     */
    public val tlsProtocol: kotlin.String? = builder.tlsProtocol
    /**
     * The ID of the traffic policy that was in effect when the email was received.
     */
    public val trafficPolicyId: kotlin.String? = builder.trafficPolicyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mailmanager.model.Metadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Metadata(")
        append("configurationSet=$configurationSet,")
        append("ingressPointId=$ingressPointId,")
        append("ruleSetId=$ruleSetId,")
        append("senderHostname=$senderHostname,")
        append("senderIpAddress=*** Sensitive Data Redacted ***,")
        append("sendingMethod=$sendingMethod,")
        append("sendingPool=$sendingPool,")
        append("sourceArn=$sourceArn,")
        append("sourceIdentity=$sourceIdentity,")
        append("timestamp=$timestamp,")
        append("tlsCipherSuite=$tlsCipherSuite,")
        append("tlsProtocol=$tlsProtocol,")
        append("trafficPolicyId=$trafficPolicyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationSet?.hashCode() ?: 0
        result = 31 * result + (ingressPointId?.hashCode() ?: 0)
        result = 31 * result + (ruleSetId?.hashCode() ?: 0)
        result = 31 * result + (senderHostname?.hashCode() ?: 0)
        result = 31 * result + (senderIpAddress?.hashCode() ?: 0)
        result = 31 * result + (sendingMethod?.hashCode() ?: 0)
        result = 31 * result + (sendingPool?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (sourceIdentity?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (tlsCipherSuite?.hashCode() ?: 0)
        result = 31 * result + (tlsProtocol?.hashCode() ?: 0)
        result = 31 * result + (trafficPolicyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Metadata

        if (configurationSet != other.configurationSet) return false
        if (ingressPointId != other.ingressPointId) return false
        if (ruleSetId != other.ruleSetId) return false
        if (senderHostname != other.senderHostname) return false
        if (senderIpAddress != other.senderIpAddress) return false
        if (sendingMethod != other.sendingMethod) return false
        if (sendingPool != other.sendingPool) return false
        if (sourceArn != other.sourceArn) return false
        if (sourceIdentity != other.sourceIdentity) return false
        if (timestamp != other.timestamp) return false
        if (tlsCipherSuite != other.tlsCipherSuite) return false
        if (tlsProtocol != other.tlsProtocol) return false
        if (trafficPolicyId != other.trafficPolicyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mailmanager.model.Metadata = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the configuration set used when sent through a configuration set with archiving enabled.
         */
        public var configurationSet: kotlin.String? = null
        /**
         * The ID of the ingress endpoint through which the email was received.
         */
        public var ingressPointId: kotlin.String? = null
        /**
         * The ID of the rule set that processed the email.
         */
        public var ruleSetId: kotlin.String? = null
        /**
         * The name of the host from which the email was received.
         */
        public var senderHostname: kotlin.String? = null
        /**
         * The IP address of the host from which the email was received.
         */
        public var senderIpAddress: kotlin.String? = null
        /**
         * The name of the API call used when sent through a configuration set with archiving enabled.
         */
        public var sendingMethod: kotlin.String? = null
        /**
         * The name of the dedicated IP pool used when sent through a configuration set with archiving enabled.
         */
        public var sendingPool: kotlin.String? = null
        /**
         * Specifies the archived email source, identified by either a Rule Set's ARN with an Archive action, or a Configuration Set's Archive ARN.
         */
        public var sourceArn: kotlin.String? = null
        /**
         * The identity name used to authorize the sending action when sent through a configuration set with archiving enabled.
         */
        public var sourceIdentity: kotlin.String? = null
        /**
         * The timestamp of when the email was received.
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The TLS cipher suite used to communicate with the host from which the email was received.
         */
        public var tlsCipherSuite: kotlin.String? = null
        /**
         * The TLS protocol used to communicate with the host from which the email was received.
         */
        public var tlsProtocol: kotlin.String? = null
        /**
         * The ID of the traffic policy that was in effect when the email was received.
         */
        public var trafficPolicyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mailmanager.model.Metadata) : this() {
            this.configurationSet = x.configurationSet
            this.ingressPointId = x.ingressPointId
            this.ruleSetId = x.ruleSetId
            this.senderHostname = x.senderHostname
            this.senderIpAddress = x.senderIpAddress
            this.sendingMethod = x.sendingMethod
            this.sendingPool = x.sendingPool
            this.sourceArn = x.sourceArn
            this.sourceIdentity = x.sourceIdentity
            this.timestamp = x.timestamp
            this.tlsCipherSuite = x.tlsCipherSuite
            this.tlsProtocol = x.tlsProtocol
            this.trafficPolicyId = x.trafficPolicyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mailmanager.model.Metadata = Metadata(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
