// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetIngressPointResponse private constructor(builder: Builder) {
    /**
     * The DNS A Record that identifies your ingress endpoint. Configure your DNS Mail Exchange (MX) record with this value to route emails to Mail Manager.
     */
    public val aRecord: kotlin.String? = builder.aRecord
    /**
     * The timestamp of when the ingress endpoint was created.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The Amazon Resource Name (ARN) of the ingress endpoint resource.
     */
    public val ingressPointArn: kotlin.String? = builder.ingressPointArn
    /**
     * The authentication configuration of the ingress endpoint resource.
     */
    public val ingressPointAuthConfiguration: aws.sdk.kotlin.services.mailmanager.model.IngressPointAuthConfiguration? = builder.ingressPointAuthConfiguration
    /**
     * The identifier of an ingress endpoint resource.
     */
    public val ingressPointId: kotlin.String = requireNotNull(builder.ingressPointId) { "A non-null value must be provided for ingressPointId" }
    /**
     * A user friendly name for the ingress endpoint.
     */
    public val ingressPointName: kotlin.String = requireNotNull(builder.ingressPointName) { "A non-null value must be provided for ingressPointName" }
    /**
     * The timestamp of when the ingress endpoint was last updated.
     */
    public val lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTimestamp
    /**
     * The identifier of a rule set resource associated with the ingress endpoint.
     */
    public val ruleSetId: kotlin.String? = builder.ruleSetId
    /**
     * The status of the ingress endpoint resource.
     */
    public val status: aws.sdk.kotlin.services.mailmanager.model.IngressPointStatus? = builder.status
    /**
     * The identifier of the traffic policy resource associated with the ingress endpoint.
     */
    public val trafficPolicyId: kotlin.String? = builder.trafficPolicyId
    /**
     * The type of ingress endpoint.
     */
    public val type: aws.sdk.kotlin.services.mailmanager.model.IngressPointType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mailmanager.model.GetIngressPointResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetIngressPointResponse(")
        append("aRecord=$aRecord,")
        append("createdTimestamp=$createdTimestamp,")
        append("ingressPointArn=$ingressPointArn,")
        append("ingressPointAuthConfiguration=$ingressPointAuthConfiguration,")
        append("ingressPointId=$ingressPointId,")
        append("ingressPointName=$ingressPointName,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp,")
        append("ruleSetId=$ruleSetId,")
        append("status=$status,")
        append("trafficPolicyId=$trafficPolicyId,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aRecord?.hashCode() ?: 0
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (ingressPointArn?.hashCode() ?: 0)
        result = 31 * result + (ingressPointAuthConfiguration?.hashCode() ?: 0)
        result = 31 * result + (ingressPointId.hashCode())
        result = 31 * result + (ingressPointName.hashCode())
        result = 31 * result + (lastUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (ruleSetId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (trafficPolicyId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetIngressPointResponse

        if (aRecord != other.aRecord) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (ingressPointArn != other.ingressPointArn) return false
        if (ingressPointAuthConfiguration != other.ingressPointAuthConfiguration) return false
        if (ingressPointId != other.ingressPointId) return false
        if (ingressPointName != other.ingressPointName) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false
        if (ruleSetId != other.ruleSetId) return false
        if (status != other.status) return false
        if (trafficPolicyId != other.trafficPolicyId) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mailmanager.model.GetIngressPointResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The DNS A Record that identifies your ingress endpoint. Configure your DNS Mail Exchange (MX) record with this value to route emails to Mail Manager.
         */
        public var aRecord: kotlin.String? = null
        /**
         * The timestamp of when the ingress endpoint was created.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the ingress endpoint resource.
         */
        public var ingressPointArn: kotlin.String? = null
        /**
         * The authentication configuration of the ingress endpoint resource.
         */
        public var ingressPointAuthConfiguration: aws.sdk.kotlin.services.mailmanager.model.IngressPointAuthConfiguration? = null
        /**
         * The identifier of an ingress endpoint resource.
         */
        public var ingressPointId: kotlin.String? = null
        /**
         * A user friendly name for the ingress endpoint.
         */
        public var ingressPointName: kotlin.String? = null
        /**
         * The timestamp of when the ingress endpoint was last updated.
         */
        public var lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of a rule set resource associated with the ingress endpoint.
         */
        public var ruleSetId: kotlin.String? = null
        /**
         * The status of the ingress endpoint resource.
         */
        public var status: aws.sdk.kotlin.services.mailmanager.model.IngressPointStatus? = null
        /**
         * The identifier of the traffic policy resource associated with the ingress endpoint.
         */
        public var trafficPolicyId: kotlin.String? = null
        /**
         * The type of ingress endpoint.
         */
        public var type: aws.sdk.kotlin.services.mailmanager.model.IngressPointType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mailmanager.model.GetIngressPointResponse) : this() {
            this.aRecord = x.aRecord
            this.createdTimestamp = x.createdTimestamp
            this.ingressPointArn = x.ingressPointArn
            this.ingressPointAuthConfiguration = x.ingressPointAuthConfiguration
            this.ingressPointId = x.ingressPointId
            this.ingressPointName = x.ingressPointName
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
            this.ruleSetId = x.ruleSetId
            this.status = x.status
            this.trafficPolicyId = x.trafficPolicyId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mailmanager.model.GetIngressPointResponse = GetIngressPointResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.mailmanager.model.IngressPointAuthConfiguration] inside the given [block]
         */
        public fun ingressPointAuthConfiguration(block: aws.sdk.kotlin.services.mailmanager.model.IngressPointAuthConfiguration.Builder.() -> kotlin.Unit) {
            this.ingressPointAuthConfiguration = aws.sdk.kotlin.services.mailmanager.model.IngressPointAuthConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (ingressPointId == null) ingressPointId = ""
            if (ingressPointName == null) ingressPointName = ""
            return this
        }
    }
}
