// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The response containing details of the requested archive.
 */
public class GetArchiveResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the archive.
     */
    public val archiveArn: kotlin.String = requireNotNull(builder.archiveArn) { "A non-null value must be provided for archiveArn" }
    /**
     * The unique identifier of the archive.
     */
    public val archiveId: kotlin.String = requireNotNull(builder.archiveId) { "A non-null value must be provided for archiveId" }
    /**
     * The unique name assigned to the archive.
     */
    public val archiveName: kotlin.String = requireNotNull(builder.archiveName) { "A non-null value must be provided for archiveName" }
    /**
     * The current state of the archive:
     * + `ACTIVE` – The archive is ready and available for use.
     * + `PENDING_DELETION` – The archive has been marked for deletion and will be permanently deleted in 30 days. No further modifications can be made in this state.
     */
    public val archiveState: aws.sdk.kotlin.services.mailmanager.model.ArchiveState = requireNotNull(builder.archiveState) { "A non-null value must be provided for archiveState" }
    /**
     * The timestamp of when the archive was created.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The Amazon Resource Name (ARN) of the KMS key used to encrypt the archive.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The timestamp of when the archive was modified.
     */
    public val lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTimestamp
    /**
     * The retention period for emails in this archive.
     */
    public val retention: aws.sdk.kotlin.services.mailmanager.model.ArchiveRetention? = builder.retention

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mailmanager.model.GetArchiveResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetArchiveResponse(")
        append("archiveArn=$archiveArn,")
        append("archiveId=$archiveId,")
        append("archiveName=$archiveName,")
        append("archiveState=$archiveState,")
        append("createdTimestamp=$createdTimestamp,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp,")
        append("retention=$retention")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = archiveArn.hashCode()
        result = 31 * result + (archiveId.hashCode())
        result = 31 * result + (archiveName.hashCode())
        result = 31 * result + (archiveState.hashCode())
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (retention?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetArchiveResponse

        if (archiveArn != other.archiveArn) return false
        if (archiveId != other.archiveId) return false
        if (archiveName != other.archiveName) return false
        if (archiveState != other.archiveState) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false
        if (retention != other.retention) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mailmanager.model.GetArchiveResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the archive.
         */
        public var archiveArn: kotlin.String? = null
        /**
         * The unique identifier of the archive.
         */
        public var archiveId: kotlin.String? = null
        /**
         * The unique name assigned to the archive.
         */
        public var archiveName: kotlin.String? = null
        /**
         * The current state of the archive:
         * + `ACTIVE` – The archive is ready and available for use.
         * + `PENDING_DELETION` – The archive has been marked for deletion and will be permanently deleted in 30 days. No further modifications can be made in this state.
         */
        public var archiveState: aws.sdk.kotlin.services.mailmanager.model.ArchiveState? = null
        /**
         * The timestamp of when the archive was created.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the KMS key used to encrypt the archive.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The timestamp of when the archive was modified.
         */
        public var lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The retention period for emails in this archive.
         */
        public var retention: aws.sdk.kotlin.services.mailmanager.model.ArchiveRetention? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mailmanager.model.GetArchiveResponse) : this() {
            this.archiveArn = x.archiveArn
            this.archiveId = x.archiveId
            this.archiveName = x.archiveName
            this.archiveState = x.archiveState
            this.createdTimestamp = x.createdTimestamp
            this.kmsKeyArn = x.kmsKeyArn
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
            this.retention = x.retention
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mailmanager.model.GetArchiveResponse = GetArchiveResponse(this)

        internal fun correctErrors(): Builder {
            if (archiveArn == null) archiveArn = ""
            if (archiveId == null) archiveId = ""
            if (archiveName == null) archiveName = ""
            if (archiveState == null) archiveState = ArchiveState.SdkUnknown("no value provided")
            return this
        }
    }
}
