// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This action to delivers an email to a mailbox.
 */
public class DeliverToMailboxAction private constructor(builder: Builder) {
    /**
     * A policy that states what to do in the case of failure. The action will fail if there are configuration errors. For example, the mailbox ARN is no longer valid.
     */
    public val actionFailurePolicy: aws.sdk.kotlin.services.mailmanager.model.ActionFailurePolicy? = builder.actionFailurePolicy
    /**
     * The Amazon Resource Name (ARN) of a WorkMail organization to deliver the email to.
     */
    public val mailboxArn: kotlin.String = requireNotNull(builder.mailboxArn) { "A non-null value must be provided for mailboxArn" }
    /**
     * The Amazon Resource Name (ARN) of an IAM role to use to execute this action. The role must have access to the workmail:DeliverToMailbox API.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mailmanager.model.DeliverToMailboxAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeliverToMailboxAction(")
        append("actionFailurePolicy=$actionFailurePolicy,")
        append("mailboxArn=$mailboxArn,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionFailurePolicy?.hashCode() ?: 0
        result = 31 * result + (mailboxArn.hashCode())
        result = 31 * result + (roleArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeliverToMailboxAction

        if (actionFailurePolicy != other.actionFailurePolicy) return false
        if (mailboxArn != other.mailboxArn) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mailmanager.model.DeliverToMailboxAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A policy that states what to do in the case of failure. The action will fail if there are configuration errors. For example, the mailbox ARN is no longer valid.
         */
        public var actionFailurePolicy: aws.sdk.kotlin.services.mailmanager.model.ActionFailurePolicy? = null
        /**
         * The Amazon Resource Name (ARN) of a WorkMail organization to deliver the email to.
         */
        public var mailboxArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role to use to execute this action. The role must have access to the workmail:DeliverToMailbox API.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mailmanager.model.DeliverToMailboxAction) : this() {
            this.actionFailurePolicy = x.actionFailurePolicy
            this.mailboxArn = x.mailboxArn
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mailmanager.model.DeliverToMailboxAction = DeliverToMailboxAction(this)

        internal fun correctErrors(): Builder {
            if (mailboxArn == null) mailboxArn = ""
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
