// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.mailmanager.auth.DefaultMailManagerAuthSchemeProvider
import aws.sdk.kotlin.services.mailmanager.auth.MailManagerAuthSchemeProvider
import aws.sdk.kotlin.services.mailmanager.endpoints.DefaultMailManagerEndpointProvider
import aws.sdk.kotlin.services.mailmanager.endpoints.MailManagerEndpointParameters
import aws.sdk.kotlin.services.mailmanager.endpoints.MailManagerEndpointProvider
import aws.sdk.kotlin.services.mailmanager.model.CreateAddonInstanceRequest
import aws.sdk.kotlin.services.mailmanager.model.CreateAddonInstanceResponse
import aws.sdk.kotlin.services.mailmanager.model.CreateAddonSubscriptionRequest
import aws.sdk.kotlin.services.mailmanager.model.CreateAddonSubscriptionResponse
import aws.sdk.kotlin.services.mailmanager.model.CreateAddressListImportJobRequest
import aws.sdk.kotlin.services.mailmanager.model.CreateAddressListImportJobResponse
import aws.sdk.kotlin.services.mailmanager.model.CreateAddressListRequest
import aws.sdk.kotlin.services.mailmanager.model.CreateAddressListResponse
import aws.sdk.kotlin.services.mailmanager.model.CreateArchiveRequest
import aws.sdk.kotlin.services.mailmanager.model.CreateArchiveResponse
import aws.sdk.kotlin.services.mailmanager.model.CreateIngressPointRequest
import aws.sdk.kotlin.services.mailmanager.model.CreateIngressPointResponse
import aws.sdk.kotlin.services.mailmanager.model.CreateRelayRequest
import aws.sdk.kotlin.services.mailmanager.model.CreateRelayResponse
import aws.sdk.kotlin.services.mailmanager.model.CreateRuleSetRequest
import aws.sdk.kotlin.services.mailmanager.model.CreateRuleSetResponse
import aws.sdk.kotlin.services.mailmanager.model.CreateTrafficPolicyRequest
import aws.sdk.kotlin.services.mailmanager.model.CreateTrafficPolicyResponse
import aws.sdk.kotlin.services.mailmanager.model.DeleteAddonInstanceRequest
import aws.sdk.kotlin.services.mailmanager.model.DeleteAddonInstanceResponse
import aws.sdk.kotlin.services.mailmanager.model.DeleteAddonSubscriptionRequest
import aws.sdk.kotlin.services.mailmanager.model.DeleteAddonSubscriptionResponse
import aws.sdk.kotlin.services.mailmanager.model.DeleteAddressListRequest
import aws.sdk.kotlin.services.mailmanager.model.DeleteAddressListResponse
import aws.sdk.kotlin.services.mailmanager.model.DeleteArchiveRequest
import aws.sdk.kotlin.services.mailmanager.model.DeleteArchiveResponse
import aws.sdk.kotlin.services.mailmanager.model.DeleteIngressPointRequest
import aws.sdk.kotlin.services.mailmanager.model.DeleteIngressPointResponse
import aws.sdk.kotlin.services.mailmanager.model.DeleteRelayRequest
import aws.sdk.kotlin.services.mailmanager.model.DeleteRelayResponse
import aws.sdk.kotlin.services.mailmanager.model.DeleteRuleSetRequest
import aws.sdk.kotlin.services.mailmanager.model.DeleteRuleSetResponse
import aws.sdk.kotlin.services.mailmanager.model.DeleteTrafficPolicyRequest
import aws.sdk.kotlin.services.mailmanager.model.DeleteTrafficPolicyResponse
import aws.sdk.kotlin.services.mailmanager.model.DeregisterMemberFromAddressListRequest
import aws.sdk.kotlin.services.mailmanager.model.DeregisterMemberFromAddressListResponse
import aws.sdk.kotlin.services.mailmanager.model.GetAddonInstanceRequest
import aws.sdk.kotlin.services.mailmanager.model.GetAddonInstanceResponse
import aws.sdk.kotlin.services.mailmanager.model.GetAddonSubscriptionRequest
import aws.sdk.kotlin.services.mailmanager.model.GetAddonSubscriptionResponse
import aws.sdk.kotlin.services.mailmanager.model.GetAddressListImportJobRequest
import aws.sdk.kotlin.services.mailmanager.model.GetAddressListImportJobResponse
import aws.sdk.kotlin.services.mailmanager.model.GetAddressListRequest
import aws.sdk.kotlin.services.mailmanager.model.GetAddressListResponse
import aws.sdk.kotlin.services.mailmanager.model.GetArchiveExportRequest
import aws.sdk.kotlin.services.mailmanager.model.GetArchiveExportResponse
import aws.sdk.kotlin.services.mailmanager.model.GetArchiveMessageContentRequest
import aws.sdk.kotlin.services.mailmanager.model.GetArchiveMessageContentResponse
import aws.sdk.kotlin.services.mailmanager.model.GetArchiveMessageRequest
import aws.sdk.kotlin.services.mailmanager.model.GetArchiveMessageResponse
import aws.sdk.kotlin.services.mailmanager.model.GetArchiveRequest
import aws.sdk.kotlin.services.mailmanager.model.GetArchiveResponse
import aws.sdk.kotlin.services.mailmanager.model.GetArchiveSearchRequest
import aws.sdk.kotlin.services.mailmanager.model.GetArchiveSearchResponse
import aws.sdk.kotlin.services.mailmanager.model.GetArchiveSearchResultsRequest
import aws.sdk.kotlin.services.mailmanager.model.GetArchiveSearchResultsResponse
import aws.sdk.kotlin.services.mailmanager.model.GetIngressPointRequest
import aws.sdk.kotlin.services.mailmanager.model.GetIngressPointResponse
import aws.sdk.kotlin.services.mailmanager.model.GetMemberOfAddressListRequest
import aws.sdk.kotlin.services.mailmanager.model.GetMemberOfAddressListResponse
import aws.sdk.kotlin.services.mailmanager.model.GetRelayRequest
import aws.sdk.kotlin.services.mailmanager.model.GetRelayResponse
import aws.sdk.kotlin.services.mailmanager.model.GetRuleSetRequest
import aws.sdk.kotlin.services.mailmanager.model.GetRuleSetResponse
import aws.sdk.kotlin.services.mailmanager.model.GetTrafficPolicyRequest
import aws.sdk.kotlin.services.mailmanager.model.GetTrafficPolicyResponse
import aws.sdk.kotlin.services.mailmanager.model.ListAddonInstancesRequest
import aws.sdk.kotlin.services.mailmanager.model.ListAddonInstancesResponse
import aws.sdk.kotlin.services.mailmanager.model.ListAddonSubscriptionsRequest
import aws.sdk.kotlin.services.mailmanager.model.ListAddonSubscriptionsResponse
import aws.sdk.kotlin.services.mailmanager.model.ListAddressListImportJobsRequest
import aws.sdk.kotlin.services.mailmanager.model.ListAddressListImportJobsResponse
import aws.sdk.kotlin.services.mailmanager.model.ListAddressListsRequest
import aws.sdk.kotlin.services.mailmanager.model.ListAddressListsResponse
import aws.sdk.kotlin.services.mailmanager.model.ListArchiveExportsRequest
import aws.sdk.kotlin.services.mailmanager.model.ListArchiveExportsResponse
import aws.sdk.kotlin.services.mailmanager.model.ListArchiveSearchesRequest
import aws.sdk.kotlin.services.mailmanager.model.ListArchiveSearchesResponse
import aws.sdk.kotlin.services.mailmanager.model.ListArchivesRequest
import aws.sdk.kotlin.services.mailmanager.model.ListArchivesResponse
import aws.sdk.kotlin.services.mailmanager.model.ListIngressPointsRequest
import aws.sdk.kotlin.services.mailmanager.model.ListIngressPointsResponse
import aws.sdk.kotlin.services.mailmanager.model.ListMembersOfAddressListRequest
import aws.sdk.kotlin.services.mailmanager.model.ListMembersOfAddressListResponse
import aws.sdk.kotlin.services.mailmanager.model.ListRelaysRequest
import aws.sdk.kotlin.services.mailmanager.model.ListRelaysResponse
import aws.sdk.kotlin.services.mailmanager.model.ListRuleSetsRequest
import aws.sdk.kotlin.services.mailmanager.model.ListRuleSetsResponse
import aws.sdk.kotlin.services.mailmanager.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.mailmanager.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.mailmanager.model.ListTrafficPoliciesRequest
import aws.sdk.kotlin.services.mailmanager.model.ListTrafficPoliciesResponse
import aws.sdk.kotlin.services.mailmanager.model.RegisterMemberToAddressListRequest
import aws.sdk.kotlin.services.mailmanager.model.RegisterMemberToAddressListResponse
import aws.sdk.kotlin.services.mailmanager.model.StartAddressListImportJobRequest
import aws.sdk.kotlin.services.mailmanager.model.StartAddressListImportJobResponse
import aws.sdk.kotlin.services.mailmanager.model.StartArchiveExportRequest
import aws.sdk.kotlin.services.mailmanager.model.StartArchiveExportResponse
import aws.sdk.kotlin.services.mailmanager.model.StartArchiveSearchRequest
import aws.sdk.kotlin.services.mailmanager.model.StartArchiveSearchResponse
import aws.sdk.kotlin.services.mailmanager.model.StopAddressListImportJobRequest
import aws.sdk.kotlin.services.mailmanager.model.StopAddressListImportJobResponse
import aws.sdk.kotlin.services.mailmanager.model.StopArchiveExportRequest
import aws.sdk.kotlin.services.mailmanager.model.StopArchiveExportResponse
import aws.sdk.kotlin.services.mailmanager.model.StopArchiveSearchRequest
import aws.sdk.kotlin.services.mailmanager.model.StopArchiveSearchResponse
import aws.sdk.kotlin.services.mailmanager.model.TagResourceRequest
import aws.sdk.kotlin.services.mailmanager.model.TagResourceResponse
import aws.sdk.kotlin.services.mailmanager.model.UntagResourceRequest
import aws.sdk.kotlin.services.mailmanager.model.UntagResourceResponse
import aws.sdk.kotlin.services.mailmanager.model.UpdateArchiveRequest
import aws.sdk.kotlin.services.mailmanager.model.UpdateArchiveResponse
import aws.sdk.kotlin.services.mailmanager.model.UpdateIngressPointRequest
import aws.sdk.kotlin.services.mailmanager.model.UpdateIngressPointResponse
import aws.sdk.kotlin.services.mailmanager.model.UpdateRelayRequest
import aws.sdk.kotlin.services.mailmanager.model.UpdateRelayResponse
import aws.sdk.kotlin.services.mailmanager.model.UpdateRuleSetRequest
import aws.sdk.kotlin.services.mailmanager.model.UpdateRuleSetResponse
import aws.sdk.kotlin.services.mailmanager.model.UpdateTrafficPolicyRequest
import aws.sdk.kotlin.services.mailmanager.model.UpdateTrafficPolicyResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "MailManager"
public const val SdkVersion: String = "1.4.27"
public const val ServiceApiVersion: String = "2023-10-17"

/**
 * # Amazon SES Mail Manager API
 * The Amazon SES Mail Manager API contains operations and data types that comprise the Mail Manager feature of [Amazon Simple Email Service (SES)](http://aws.amazon.com/ses).
 *
 * Mail Manager is a set of Amazon SES email gateway features designed to help you strengthen your organization's email infrastructure, simplify email workflow management, and streamline email compliance control. To learn more, see the [Mail Manager chapter](https://docs.aws.amazon.com/ses/latest/dg/eb.html) in the *Amazon SES Developer Guide*.
 */
public interface MailManagerClient : SdkClient {
    /**
     * MailManagerClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, MailManagerClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "MailManager",
                "MAILMANAGER",
                "mailmanager",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, MailManagerClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): MailManagerClient = DefaultMailManagerClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: MailManagerEndpointProvider = builder.endpointProvider ?: DefaultMailManagerEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: MailManagerAuthSchemeProvider = builder.authSchemeProvider ?: DefaultMailManagerAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "MailManager"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: MailManagerEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: MailManagerAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an Add On instance for the subscription indicated in the request. The resulting Amazon Resource Name (ARN) can be used in a conditional statement for a rule set or traffic policy.
     */
    public suspend fun createAddonInstance(input: CreateAddonInstanceRequest): CreateAddonInstanceResponse

    /**
     * Creates a subscription for an Add On representing the acceptance of its terms of use and additional pricing. The subscription can then be used to create an instance for use in rule sets or traffic policies.
     */
    public suspend fun createAddonSubscription(input: CreateAddonSubscriptionRequest): CreateAddonSubscriptionResponse

    /**
     * Creates a new address list.
     */
    public suspend fun createAddressList(input: CreateAddressListRequest): CreateAddressListResponse

    /**
     * Creates an import job for an address list.
     */
    public suspend fun createAddressListImportJob(input: CreateAddressListImportJobRequest): CreateAddressListImportJobResponse

    /**
     * Creates a new email archive resource for storing and retaining emails.
     */
    public suspend fun createArchive(input: CreateArchiveRequest): CreateArchiveResponse

    /**
     * Provision a new ingress endpoint resource.
     *
     * @sample aws.sdk.kotlin.services.mailmanager.samples.CreateIngressPoint.sample
     * @sample aws.sdk.kotlin.services.mailmanager.samples.CreateIngressPoint.sample2
     * @sample aws.sdk.kotlin.services.mailmanager.samples.CreateIngressPoint.sample3
     */
    public suspend fun createIngressPoint(input: CreateIngressPointRequest): CreateIngressPointResponse

    /**
     * Creates a relay resource which can be used in rules to relay incoming emails to defined relay destinations.
     */
    public suspend fun createRelay(input: CreateRelayRequest): CreateRelayResponse

    /**
     * Provision a new rule set.
     */
    public suspend fun createRuleSet(input: CreateRuleSetRequest): CreateRuleSetResponse

    /**
     * Provision a new traffic policy resource.
     *
     * @sample aws.sdk.kotlin.services.mailmanager.samples.CreateTrafficPolicy.sample
     */
    public suspend fun createTrafficPolicy(input: CreateTrafficPolicyRequest): CreateTrafficPolicyResponse

    /**
     * Deletes an Add On instance.
     */
    public suspend fun deleteAddonInstance(input: DeleteAddonInstanceRequest): DeleteAddonInstanceResponse

    /**
     * Deletes an Add On subscription.
     */
    public suspend fun deleteAddonSubscription(input: DeleteAddonSubscriptionRequest): DeleteAddonSubscriptionResponse

    /**
     * Deletes an address list.
     */
    public suspend fun deleteAddressList(input: DeleteAddressListRequest): DeleteAddressListResponse

    /**
     * Initiates deletion of an email archive. This changes the archive state to pending deletion. In this state, no new emails can be added, and existing archived emails become inaccessible (search, export, download). The archive and all of its contents will be permanently deleted 30 days after entering the pending deletion state, regardless of the configured retention period.
     */
    public suspend fun deleteArchive(input: DeleteArchiveRequest): DeleteArchiveResponse

    /**
     * Delete an ingress endpoint resource.
     *
     * @sample aws.sdk.kotlin.services.mailmanager.samples.DeleteIngressPoint.sample
     */
    public suspend fun deleteIngressPoint(input: DeleteIngressPointRequest): DeleteIngressPointResponse

    /**
     * Deletes an existing relay resource.
     */
    public suspend fun deleteRelay(input: DeleteRelayRequest): DeleteRelayResponse

    /**
     * Delete a rule set.
     */
    public suspend fun deleteRuleSet(input: DeleteRuleSetRequest): DeleteRuleSetResponse

    /**
     * Delete a traffic policy resource.
     *
     * @sample aws.sdk.kotlin.services.mailmanager.samples.DeleteTrafficPolicy.sample
     */
    public suspend fun deleteTrafficPolicy(input: DeleteTrafficPolicyRequest): DeleteTrafficPolicyResponse

    /**
     * Removes a member from an address list.
     */
    public suspend fun deregisterMemberFromAddressList(input: DeregisterMemberFromAddressListRequest): DeregisterMemberFromAddressListResponse

    /**
     * Gets detailed information about an Add On instance.
     */
    public suspend fun getAddonInstance(input: GetAddonInstanceRequest): GetAddonInstanceResponse

    /**
     * Gets detailed information about an Add On subscription.
     */
    public suspend fun getAddonSubscription(input: GetAddonSubscriptionRequest): GetAddonSubscriptionResponse

    /**
     * Fetch attributes of an address list.
     */
    public suspend fun getAddressList(input: GetAddressListRequest): GetAddressListResponse

    /**
     * Fetch attributes of an import job.
     */
    public suspend fun getAddressListImportJob(input: GetAddressListImportJobRequest): GetAddressListImportJobResponse

    /**
     * Retrieves the full details and current state of a specified email archive.
     */
    public suspend fun getArchive(input: GetArchiveRequest): GetArchiveResponse

    /**
     * Retrieves the details and current status of a specific email archive export job.
     */
    public suspend fun getArchiveExport(input: GetArchiveExportRequest): GetArchiveExportResponse

    /**
     * Returns a pre-signed URL that provides temporary download access to the specific email message stored in the archive.
     */
    public suspend fun getArchiveMessage(input: GetArchiveMessageRequest): GetArchiveMessageResponse

    /**
     * Returns the textual content of a specific email message stored in the archive. Attachments are not included.
     */
    public suspend fun getArchiveMessageContent(input: GetArchiveMessageContentRequest): GetArchiveMessageContentResponse

    /**
     * Retrieves the details and current status of a specific email archive search job.
     */
    public suspend fun getArchiveSearch(input: GetArchiveSearchRequest): GetArchiveSearchResponse

    /**
     * Returns the results of a completed email archive search job.
     */
    public suspend fun getArchiveSearchResults(input: GetArchiveSearchResultsRequest): GetArchiveSearchResultsResponse

    /**
     * Fetch ingress endpoint resource attributes.
     *
     * @sample aws.sdk.kotlin.services.mailmanager.samples.GetIngressPoint.sample
     * @sample aws.sdk.kotlin.services.mailmanager.samples.GetIngressPoint.sample2
     */
    public suspend fun getIngressPoint(input: GetIngressPointRequest): GetIngressPointResponse

    /**
     * Fetch attributes of a member in an address list.
     */
    public suspend fun getMemberOfAddressList(input: GetMemberOfAddressListRequest): GetMemberOfAddressListResponse

    /**
     * Fetch the relay resource and it's attributes.
     */
    public suspend fun getRelay(input: GetRelayRequest): GetRelayResponse

    /**
     * Fetch attributes of a rule set.
     */
    public suspend fun getRuleSet(input: GetRuleSetRequest): GetRuleSetResponse

    /**
     * Fetch attributes of a traffic policy resource.
     *
     * @sample aws.sdk.kotlin.services.mailmanager.samples.GetTrafficPolicy.sample
     */
    public suspend fun getTrafficPolicy(input: GetTrafficPolicyRequest): GetTrafficPolicyResponse

    /**
     * Lists all Add On instances in your account.
     */
    public suspend fun listAddonInstances(input: ListAddonInstancesRequest = ListAddonInstancesRequest { }): ListAddonInstancesResponse

    /**
     * Lists all Add On subscriptions in your account.
     */
    public suspend fun listAddonSubscriptions(input: ListAddonSubscriptionsRequest = ListAddonSubscriptionsRequest { }): ListAddonSubscriptionsResponse

    /**
     * Lists jobs for an address list.
     */
    public suspend fun listAddressListImportJobs(input: ListAddressListImportJobsRequest): ListAddressListImportJobsResponse

    /**
     * Lists address lists for this account.
     */
    public suspend fun listAddressLists(input: ListAddressListsRequest = ListAddressListsRequest { }): ListAddressListsResponse

    /**
     * Returns a list of email archive export jobs.
     */
    public suspend fun listArchiveExports(input: ListArchiveExportsRequest): ListArchiveExportsResponse

    /**
     * Returns a list of email archive search jobs.
     */
    public suspend fun listArchiveSearches(input: ListArchiveSearchesRequest): ListArchiveSearchesResponse

    /**
     * Returns a list of all email archives in your account.
     */
    public suspend fun listArchives(input: ListArchivesRequest = ListArchivesRequest { }): ListArchivesResponse

    /**
     * List all ingress endpoint resources.
     *
     * @sample aws.sdk.kotlin.services.mailmanager.samples.ListIngressPoints.sample
     * @sample aws.sdk.kotlin.services.mailmanager.samples.ListIngressPoints.sample2
     * @sample aws.sdk.kotlin.services.mailmanager.samples.ListIngressPoints.sample3
     */
    public suspend fun listIngressPoints(input: ListIngressPointsRequest = ListIngressPointsRequest { }): ListIngressPointsResponse

    /**
     * Lists members of an address list.
     */
    public suspend fun listMembersOfAddressList(input: ListMembersOfAddressListRequest): ListMembersOfAddressListResponse

    /**
     * Lists all the existing relay resources.
     */
    public suspend fun listRelays(input: ListRelaysRequest = ListRelaysRequest { }): ListRelaysResponse

    /**
     * List rule sets for this account.
     */
    public suspend fun listRuleSets(input: ListRuleSetsRequest = ListRuleSetsRequest { }): ListRuleSetsResponse

    /**
     * Retrieves the list of tags (keys and values) assigned to the resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * List traffic policy resources.
     *
     * @sample aws.sdk.kotlin.services.mailmanager.samples.ListTrafficPolicies.sample
     * @sample aws.sdk.kotlin.services.mailmanager.samples.ListTrafficPolicies.sample2
     * @sample aws.sdk.kotlin.services.mailmanager.samples.ListTrafficPolicies.sample3
     */
    public suspend fun listTrafficPolicies(input: ListTrafficPoliciesRequest = ListTrafficPoliciesRequest { }): ListTrafficPoliciesResponse

    /**
     * Adds a member to an address list.
     */
    public suspend fun registerMemberToAddressList(input: RegisterMemberToAddressListRequest): RegisterMemberToAddressListResponse

    /**
     * Starts an import job for an address list.
     */
    public suspend fun startAddressListImportJob(input: StartAddressListImportJobRequest): StartAddressListImportJobResponse

    /**
     * Initiates an export of emails from the specified archive.
     */
    public suspend fun startArchiveExport(input: StartArchiveExportRequest): StartArchiveExportResponse

    /**
     * Initiates a search across emails in the specified archive.
     */
    public suspend fun startArchiveSearch(input: StartArchiveSearchRequest): StartArchiveSearchResponse

    /**
     * Stops an ongoing import job for an address list.
     */
    public suspend fun stopAddressListImportJob(input: StopAddressListImportJobRequest): StopAddressListImportJobResponse

    /**
     * Stops an in-progress export of emails from an archive.
     */
    public suspend fun stopArchiveExport(input: StopArchiveExportRequest): StopArchiveExportResponse

    /**
     * Stops an in-progress archive search job.
     */
    public suspend fun stopArchiveSearch(input: StopArchiveSearchRequest): StopArchiveSearchResponse

    /**
     * Adds one or more tags (keys and values) to a specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Remove one or more tags (keys and values) from a specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the attributes of an existing email archive.
     */
    public suspend fun updateArchive(input: UpdateArchiveRequest): UpdateArchiveResponse

    /**
     * Update attributes of a provisioned ingress endpoint resource.
     *
     * @sample aws.sdk.kotlin.services.mailmanager.samples.UpdateIngressPoint.sample
     * @sample aws.sdk.kotlin.services.mailmanager.samples.UpdateIngressPoint.sample2
     * @sample aws.sdk.kotlin.services.mailmanager.samples.UpdateIngressPoint.sample3
     * @sample aws.sdk.kotlin.services.mailmanager.samples.UpdateIngressPoint.sample4
     */
    public suspend fun updateIngressPoint(input: UpdateIngressPointRequest): UpdateIngressPointResponse

    /**
     * Updates the attributes of an existing relay resource.
     */
    public suspend fun updateRelay(input: UpdateRelayRequest): UpdateRelayResponse

    /**
     * Update attributes of an already provisioned rule set.
     */
    public suspend fun updateRuleSet(input: UpdateRuleSetRequest): UpdateRuleSetResponse

    /**
     * Update attributes of an already provisioned traffic policy resource.
     *
     * @sample aws.sdk.kotlin.services.mailmanager.samples.UpdateTrafficPolicy.sample
     * @sample aws.sdk.kotlin.services.mailmanager.samples.UpdateTrafficPolicy.sample2
     * @sample aws.sdk.kotlin.services.mailmanager.samples.UpdateTrafficPolicy.sample3
     */
    public suspend fun updateTrafficPolicy(input: UpdateTrafficPolicyRequest): UpdateTrafficPolicyResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun MailManagerClient.withConfig(block: MailManagerClient.Config.Builder.() -> Unit): MailManagerClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultMailManagerClient(newConfig)
}

/**
 * Creates an Add On instance for the subscription indicated in the request. The resulting Amazon Resource Name (ARN) can be used in a conditional statement for a rule set or traffic policy.
 */
public suspend inline fun MailManagerClient.createAddonInstance(crossinline block: CreateAddonInstanceRequest.Builder.() -> Unit): CreateAddonInstanceResponse = createAddonInstance(CreateAddonInstanceRequest.Builder().apply(block).build())

/**
 * Creates a subscription for an Add On representing the acceptance of its terms of use and additional pricing. The subscription can then be used to create an instance for use in rule sets or traffic policies.
 */
public suspend inline fun MailManagerClient.createAddonSubscription(crossinline block: CreateAddonSubscriptionRequest.Builder.() -> Unit): CreateAddonSubscriptionResponse = createAddonSubscription(CreateAddonSubscriptionRequest.Builder().apply(block).build())

/**
 * Creates a new address list.
 */
public suspend inline fun MailManagerClient.createAddressList(crossinline block: CreateAddressListRequest.Builder.() -> Unit): CreateAddressListResponse = createAddressList(CreateAddressListRequest.Builder().apply(block).build())

/**
 * Creates an import job for an address list.
 */
public suspend inline fun MailManagerClient.createAddressListImportJob(crossinline block: CreateAddressListImportJobRequest.Builder.() -> Unit): CreateAddressListImportJobResponse = createAddressListImportJob(CreateAddressListImportJobRequest.Builder().apply(block).build())

/**
 * Creates a new email archive resource for storing and retaining emails.
 */
public suspend inline fun MailManagerClient.createArchive(crossinline block: CreateArchiveRequest.Builder.() -> Unit): CreateArchiveResponse = createArchive(CreateArchiveRequest.Builder().apply(block).build())

/**
 * Provision a new ingress endpoint resource.
 *
 * @sample aws.sdk.kotlin.services.mailmanager.samples.CreateIngressPoint.sample
 * @sample aws.sdk.kotlin.services.mailmanager.samples.CreateIngressPoint.sample2
 * @sample aws.sdk.kotlin.services.mailmanager.samples.CreateIngressPoint.sample3
 */
public suspend inline fun MailManagerClient.createIngressPoint(crossinline block: CreateIngressPointRequest.Builder.() -> Unit): CreateIngressPointResponse = createIngressPoint(CreateIngressPointRequest.Builder().apply(block).build())

/**
 * Creates a relay resource which can be used in rules to relay incoming emails to defined relay destinations.
 */
public suspend inline fun MailManagerClient.createRelay(crossinline block: CreateRelayRequest.Builder.() -> Unit): CreateRelayResponse = createRelay(CreateRelayRequest.Builder().apply(block).build())

/**
 * Provision a new rule set.
 */
public suspend inline fun MailManagerClient.createRuleSet(crossinline block: CreateRuleSetRequest.Builder.() -> Unit): CreateRuleSetResponse = createRuleSet(CreateRuleSetRequest.Builder().apply(block).build())

/**
 * Provision a new traffic policy resource.
 *
 * @sample aws.sdk.kotlin.services.mailmanager.samples.CreateTrafficPolicy.sample
 */
public suspend inline fun MailManagerClient.createTrafficPolicy(crossinline block: CreateTrafficPolicyRequest.Builder.() -> Unit): CreateTrafficPolicyResponse = createTrafficPolicy(CreateTrafficPolicyRequest.Builder().apply(block).build())

/**
 * Deletes an Add On instance.
 */
public suspend inline fun MailManagerClient.deleteAddonInstance(crossinline block: DeleteAddonInstanceRequest.Builder.() -> Unit): DeleteAddonInstanceResponse = deleteAddonInstance(DeleteAddonInstanceRequest.Builder().apply(block).build())

/**
 * Deletes an Add On subscription.
 */
public suspend inline fun MailManagerClient.deleteAddonSubscription(crossinline block: DeleteAddonSubscriptionRequest.Builder.() -> Unit): DeleteAddonSubscriptionResponse = deleteAddonSubscription(DeleteAddonSubscriptionRequest.Builder().apply(block).build())

/**
 * Deletes an address list.
 */
public suspend inline fun MailManagerClient.deleteAddressList(crossinline block: DeleteAddressListRequest.Builder.() -> Unit): DeleteAddressListResponse = deleteAddressList(DeleteAddressListRequest.Builder().apply(block).build())

/**
 * Initiates deletion of an email archive. This changes the archive state to pending deletion. In this state, no new emails can be added, and existing archived emails become inaccessible (search, export, download). The archive and all of its contents will be permanently deleted 30 days after entering the pending deletion state, regardless of the configured retention period.
 */
public suspend inline fun MailManagerClient.deleteArchive(crossinline block: DeleteArchiveRequest.Builder.() -> Unit): DeleteArchiveResponse = deleteArchive(DeleteArchiveRequest.Builder().apply(block).build())

/**
 * Delete an ingress endpoint resource.
 *
 * @sample aws.sdk.kotlin.services.mailmanager.samples.DeleteIngressPoint.sample
 */
public suspend inline fun MailManagerClient.deleteIngressPoint(crossinline block: DeleteIngressPointRequest.Builder.() -> Unit): DeleteIngressPointResponse = deleteIngressPoint(DeleteIngressPointRequest.Builder().apply(block).build())

/**
 * Deletes an existing relay resource.
 */
public suspend inline fun MailManagerClient.deleteRelay(crossinline block: DeleteRelayRequest.Builder.() -> Unit): DeleteRelayResponse = deleteRelay(DeleteRelayRequest.Builder().apply(block).build())

/**
 * Delete a rule set.
 */
public suspend inline fun MailManagerClient.deleteRuleSet(crossinline block: DeleteRuleSetRequest.Builder.() -> Unit): DeleteRuleSetResponse = deleteRuleSet(DeleteRuleSetRequest.Builder().apply(block).build())

/**
 * Delete a traffic policy resource.
 *
 * @sample aws.sdk.kotlin.services.mailmanager.samples.DeleteTrafficPolicy.sample
 */
public suspend inline fun MailManagerClient.deleteTrafficPolicy(crossinline block: DeleteTrafficPolicyRequest.Builder.() -> Unit): DeleteTrafficPolicyResponse = deleteTrafficPolicy(DeleteTrafficPolicyRequest.Builder().apply(block).build())

/**
 * Removes a member from an address list.
 */
public suspend inline fun MailManagerClient.deregisterMemberFromAddressList(crossinline block: DeregisterMemberFromAddressListRequest.Builder.() -> Unit): DeregisterMemberFromAddressListResponse = deregisterMemberFromAddressList(DeregisterMemberFromAddressListRequest.Builder().apply(block).build())

/**
 * Gets detailed information about an Add On instance.
 */
public suspend inline fun MailManagerClient.getAddonInstance(crossinline block: GetAddonInstanceRequest.Builder.() -> Unit): GetAddonInstanceResponse = getAddonInstance(GetAddonInstanceRequest.Builder().apply(block).build())

/**
 * Gets detailed information about an Add On subscription.
 */
public suspend inline fun MailManagerClient.getAddonSubscription(crossinline block: GetAddonSubscriptionRequest.Builder.() -> Unit): GetAddonSubscriptionResponse = getAddonSubscription(GetAddonSubscriptionRequest.Builder().apply(block).build())

/**
 * Fetch attributes of an address list.
 */
public suspend inline fun MailManagerClient.getAddressList(crossinline block: GetAddressListRequest.Builder.() -> Unit): GetAddressListResponse = getAddressList(GetAddressListRequest.Builder().apply(block).build())

/**
 * Fetch attributes of an import job.
 */
public suspend inline fun MailManagerClient.getAddressListImportJob(crossinline block: GetAddressListImportJobRequest.Builder.() -> Unit): GetAddressListImportJobResponse = getAddressListImportJob(GetAddressListImportJobRequest.Builder().apply(block).build())

/**
 * Retrieves the full details and current state of a specified email archive.
 */
public suspend inline fun MailManagerClient.getArchive(crossinline block: GetArchiveRequest.Builder.() -> Unit): GetArchiveResponse = getArchive(GetArchiveRequest.Builder().apply(block).build())

/**
 * Retrieves the details and current status of a specific email archive export job.
 */
public suspend inline fun MailManagerClient.getArchiveExport(crossinline block: GetArchiveExportRequest.Builder.() -> Unit): GetArchiveExportResponse = getArchiveExport(GetArchiveExportRequest.Builder().apply(block).build())

/**
 * Returns a pre-signed URL that provides temporary download access to the specific email message stored in the archive.
 */
public suspend inline fun MailManagerClient.getArchiveMessage(crossinline block: GetArchiveMessageRequest.Builder.() -> Unit): GetArchiveMessageResponse = getArchiveMessage(GetArchiveMessageRequest.Builder().apply(block).build())

/**
 * Returns the textual content of a specific email message stored in the archive. Attachments are not included.
 */
public suspend inline fun MailManagerClient.getArchiveMessageContent(crossinline block: GetArchiveMessageContentRequest.Builder.() -> Unit): GetArchiveMessageContentResponse = getArchiveMessageContent(GetArchiveMessageContentRequest.Builder().apply(block).build())

/**
 * Retrieves the details and current status of a specific email archive search job.
 */
public suspend inline fun MailManagerClient.getArchiveSearch(crossinline block: GetArchiveSearchRequest.Builder.() -> Unit): GetArchiveSearchResponse = getArchiveSearch(GetArchiveSearchRequest.Builder().apply(block).build())

/**
 * Returns the results of a completed email archive search job.
 */
public suspend inline fun MailManagerClient.getArchiveSearchResults(crossinline block: GetArchiveSearchResultsRequest.Builder.() -> Unit): GetArchiveSearchResultsResponse = getArchiveSearchResults(GetArchiveSearchResultsRequest.Builder().apply(block).build())

/**
 * Fetch ingress endpoint resource attributes.
 *
 * @sample aws.sdk.kotlin.services.mailmanager.samples.GetIngressPoint.sample
 * @sample aws.sdk.kotlin.services.mailmanager.samples.GetIngressPoint.sample2
 */
public suspend inline fun MailManagerClient.getIngressPoint(crossinline block: GetIngressPointRequest.Builder.() -> Unit): GetIngressPointResponse = getIngressPoint(GetIngressPointRequest.Builder().apply(block).build())

/**
 * Fetch attributes of a member in an address list.
 */
public suspend inline fun MailManagerClient.getMemberOfAddressList(crossinline block: GetMemberOfAddressListRequest.Builder.() -> Unit): GetMemberOfAddressListResponse = getMemberOfAddressList(GetMemberOfAddressListRequest.Builder().apply(block).build())

/**
 * Fetch the relay resource and it's attributes.
 */
public suspend inline fun MailManagerClient.getRelay(crossinline block: GetRelayRequest.Builder.() -> Unit): GetRelayResponse = getRelay(GetRelayRequest.Builder().apply(block).build())

/**
 * Fetch attributes of a rule set.
 */
public suspend inline fun MailManagerClient.getRuleSet(crossinline block: GetRuleSetRequest.Builder.() -> Unit): GetRuleSetResponse = getRuleSet(GetRuleSetRequest.Builder().apply(block).build())

/**
 * Fetch attributes of a traffic policy resource.
 *
 * @sample aws.sdk.kotlin.services.mailmanager.samples.GetTrafficPolicy.sample
 */
public suspend inline fun MailManagerClient.getTrafficPolicy(crossinline block: GetTrafficPolicyRequest.Builder.() -> Unit): GetTrafficPolicyResponse = getTrafficPolicy(GetTrafficPolicyRequest.Builder().apply(block).build())

/**
 * Lists all Add On instances in your account.
 */
public suspend inline fun MailManagerClient.listAddonInstances(crossinline block: ListAddonInstancesRequest.Builder.() -> Unit): ListAddonInstancesResponse = listAddonInstances(ListAddonInstancesRequest.Builder().apply(block).build())

/**
 * Lists all Add On subscriptions in your account.
 */
public suspend inline fun MailManagerClient.listAddonSubscriptions(crossinline block: ListAddonSubscriptionsRequest.Builder.() -> Unit): ListAddonSubscriptionsResponse = listAddonSubscriptions(ListAddonSubscriptionsRequest.Builder().apply(block).build())

/**
 * Lists jobs for an address list.
 */
public suspend inline fun MailManagerClient.listAddressListImportJobs(crossinline block: ListAddressListImportJobsRequest.Builder.() -> Unit): ListAddressListImportJobsResponse = listAddressListImportJobs(ListAddressListImportJobsRequest.Builder().apply(block).build())

/**
 * Lists address lists for this account.
 */
public suspend inline fun MailManagerClient.listAddressLists(crossinline block: ListAddressListsRequest.Builder.() -> Unit): ListAddressListsResponse = listAddressLists(ListAddressListsRequest.Builder().apply(block).build())

/**
 * Returns a list of email archive export jobs.
 */
public suspend inline fun MailManagerClient.listArchiveExports(crossinline block: ListArchiveExportsRequest.Builder.() -> Unit): ListArchiveExportsResponse = listArchiveExports(ListArchiveExportsRequest.Builder().apply(block).build())

/**
 * Returns a list of email archive search jobs.
 */
public suspend inline fun MailManagerClient.listArchiveSearches(crossinline block: ListArchiveSearchesRequest.Builder.() -> Unit): ListArchiveSearchesResponse = listArchiveSearches(ListArchiveSearchesRequest.Builder().apply(block).build())

/**
 * Returns a list of all email archives in your account.
 */
public suspend inline fun MailManagerClient.listArchives(crossinline block: ListArchivesRequest.Builder.() -> Unit): ListArchivesResponse = listArchives(ListArchivesRequest.Builder().apply(block).build())

/**
 * List all ingress endpoint resources.
 *
 * @sample aws.sdk.kotlin.services.mailmanager.samples.ListIngressPoints.sample
 * @sample aws.sdk.kotlin.services.mailmanager.samples.ListIngressPoints.sample2
 * @sample aws.sdk.kotlin.services.mailmanager.samples.ListIngressPoints.sample3
 */
public suspend inline fun MailManagerClient.listIngressPoints(crossinline block: ListIngressPointsRequest.Builder.() -> Unit): ListIngressPointsResponse = listIngressPoints(ListIngressPointsRequest.Builder().apply(block).build())

/**
 * Lists members of an address list.
 */
public suspend inline fun MailManagerClient.listMembersOfAddressList(crossinline block: ListMembersOfAddressListRequest.Builder.() -> Unit): ListMembersOfAddressListResponse = listMembersOfAddressList(ListMembersOfAddressListRequest.Builder().apply(block).build())

/**
 * Lists all the existing relay resources.
 */
public suspend inline fun MailManagerClient.listRelays(crossinline block: ListRelaysRequest.Builder.() -> Unit): ListRelaysResponse = listRelays(ListRelaysRequest.Builder().apply(block).build())

/**
 * List rule sets for this account.
 */
public suspend inline fun MailManagerClient.listRuleSets(crossinline block: ListRuleSetsRequest.Builder.() -> Unit): ListRuleSetsResponse = listRuleSets(ListRuleSetsRequest.Builder().apply(block).build())

/**
 * Retrieves the list of tags (keys and values) assigned to the resource.
 */
public suspend inline fun MailManagerClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * List traffic policy resources.
 *
 * @sample aws.sdk.kotlin.services.mailmanager.samples.ListTrafficPolicies.sample
 * @sample aws.sdk.kotlin.services.mailmanager.samples.ListTrafficPolicies.sample2
 * @sample aws.sdk.kotlin.services.mailmanager.samples.ListTrafficPolicies.sample3
 */
public suspend inline fun MailManagerClient.listTrafficPolicies(crossinline block: ListTrafficPoliciesRequest.Builder.() -> Unit): ListTrafficPoliciesResponse = listTrafficPolicies(ListTrafficPoliciesRequest.Builder().apply(block).build())

/**
 * Adds a member to an address list.
 */
public suspend inline fun MailManagerClient.registerMemberToAddressList(crossinline block: RegisterMemberToAddressListRequest.Builder.() -> Unit): RegisterMemberToAddressListResponse = registerMemberToAddressList(RegisterMemberToAddressListRequest.Builder().apply(block).build())

/**
 * Starts an import job for an address list.
 */
public suspend inline fun MailManagerClient.startAddressListImportJob(crossinline block: StartAddressListImportJobRequest.Builder.() -> Unit): StartAddressListImportJobResponse = startAddressListImportJob(StartAddressListImportJobRequest.Builder().apply(block).build())

/**
 * Initiates an export of emails from the specified archive.
 */
public suspend inline fun MailManagerClient.startArchiveExport(crossinline block: StartArchiveExportRequest.Builder.() -> Unit): StartArchiveExportResponse = startArchiveExport(StartArchiveExportRequest.Builder().apply(block).build())

/**
 * Initiates a search across emails in the specified archive.
 */
public suspend inline fun MailManagerClient.startArchiveSearch(crossinline block: StartArchiveSearchRequest.Builder.() -> Unit): StartArchiveSearchResponse = startArchiveSearch(StartArchiveSearchRequest.Builder().apply(block).build())

/**
 * Stops an ongoing import job for an address list.
 */
public suspend inline fun MailManagerClient.stopAddressListImportJob(crossinline block: StopAddressListImportJobRequest.Builder.() -> Unit): StopAddressListImportJobResponse = stopAddressListImportJob(StopAddressListImportJobRequest.Builder().apply(block).build())

/**
 * Stops an in-progress export of emails from an archive.
 */
public suspend inline fun MailManagerClient.stopArchiveExport(crossinline block: StopArchiveExportRequest.Builder.() -> Unit): StopArchiveExportResponse = stopArchiveExport(StopArchiveExportRequest.Builder().apply(block).build())

/**
 * Stops an in-progress archive search job.
 */
public suspend inline fun MailManagerClient.stopArchiveSearch(crossinline block: StopArchiveSearchRequest.Builder.() -> Unit): StopArchiveSearchResponse = stopArchiveSearch(StopArchiveSearchRequest.Builder().apply(block).build())

/**
 * Adds one or more tags (keys and values) to a specified resource.
 */
public suspend inline fun MailManagerClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Remove one or more tags (keys and values) from a specified resource.
 */
public suspend inline fun MailManagerClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the attributes of an existing email archive.
 */
public suspend inline fun MailManagerClient.updateArchive(crossinline block: UpdateArchiveRequest.Builder.() -> Unit): UpdateArchiveResponse = updateArchive(UpdateArchiveRequest.Builder().apply(block).build())

/**
 * Update attributes of a provisioned ingress endpoint resource.
 *
 * @sample aws.sdk.kotlin.services.mailmanager.samples.UpdateIngressPoint.sample
 * @sample aws.sdk.kotlin.services.mailmanager.samples.UpdateIngressPoint.sample2
 * @sample aws.sdk.kotlin.services.mailmanager.samples.UpdateIngressPoint.sample3
 * @sample aws.sdk.kotlin.services.mailmanager.samples.UpdateIngressPoint.sample4
 */
public suspend inline fun MailManagerClient.updateIngressPoint(crossinline block: UpdateIngressPointRequest.Builder.() -> Unit): UpdateIngressPointResponse = updateIngressPoint(UpdateIngressPointRequest.Builder().apply(block).build())

/**
 * Updates the attributes of an existing relay resource.
 */
public suspend inline fun MailManagerClient.updateRelay(crossinline block: UpdateRelayRequest.Builder.() -> Unit): UpdateRelayResponse = updateRelay(UpdateRelayRequest.Builder().apply(block).build())

/**
 * Update attributes of an already provisioned rule set.
 */
public suspend inline fun MailManagerClient.updateRuleSet(crossinline block: UpdateRuleSetRequest.Builder.() -> Unit): UpdateRuleSetResponse = updateRuleSet(UpdateRuleSetRequest.Builder().apply(block).build())

/**
 * Update attributes of an already provisioned traffic policy resource.
 *
 * @sample aws.sdk.kotlin.services.mailmanager.samples.UpdateTrafficPolicy.sample
 * @sample aws.sdk.kotlin.services.mailmanager.samples.UpdateTrafficPolicy.sample2
 * @sample aws.sdk.kotlin.services.mailmanager.samples.UpdateTrafficPolicy.sample3
 */
public suspend inline fun MailManagerClient.updateTrafficPolicy(crossinline block: UpdateTrafficPolicyRequest.Builder.() -> Unit): UpdateTrafficPolicyResponse = updateTrafficPolicy(UpdateTrafficPolicyRequest.Builder().apply(block).build())
