// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The database credentials to connect to a database on an RDS DB instance.
 */
public class RdsDatabaseCredentials private constructor(builder: Builder) {
    /**
     * The password to be used by Amazon ML to connect to a database on an RDS DB instance. The password should have sufficient permissions to execute the `RDSSelectQuery` query.
     */
    public val password: kotlin.String = requireNotNull(builder.password) { "A non-null value must be provided for password" }
    /**
     * The username to be used by Amazon ML to connect to database on an Amazon RDS instance. The username should have sufficient permissions to execute an `RDSSelectSqlQuery` query.
     */
    public val username: kotlin.String = requireNotNull(builder.username) { "A non-null value must be provided for username" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.RdsDatabaseCredentials = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RdsDatabaseCredentials(")
        append("password=*** Sensitive Data Redacted ***,")
        append("username=$username")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = password.hashCode()
        result = 31 * result + (username.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RdsDatabaseCredentials

        if (password != other.password) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.RdsDatabaseCredentials = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The password to be used by Amazon ML to connect to a database on an RDS DB instance. The password should have sufficient permissions to execute the `RDSSelectQuery` query.
         */
        public var password: kotlin.String? = null
        /**
         * The username to be used by Amazon ML to connect to database on an Amazon RDS instance. The username should have sufficient permissions to execute an `RDSSelectSqlQuery` query.
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.RdsDatabaseCredentials) : this() {
            this.password = x.password
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.RdsDatabaseCredentials = RdsDatabaseCredentials(this)

        internal fun correctErrors(): Builder {
            if (password == null) password = ""
            if (username == null) username = ""
            return this
        }
    }
}
