// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the output of a `GetDataSource` operation and describes a `DataSource`.
 */
public class GetDataSourceResponse private constructor(builder: Builder) {
    /**
     * The parameter is `true` if statistics need to be generated from the observation data.
     */
    public val computeStatistics: kotlin.Boolean = builder.computeStatistics
    /**
     * The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the `DataSource`, normalized and scaled on computation resources. `ComputeTime` is only available if the `DataSource` is in the `COMPLETED` state and the `ComputeStatistics` is set to true.
     */
    public val computeTime: kotlin.Long? = builder.computeTime
    /**
     * The time that the `DataSource` was created. The time is expressed in epoch time.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The AWS user account from which the `DataSource` was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.
     */
    public val createdByIamUser: kotlin.String? = builder.createdByIamUser
    /**
     * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     */
    public val dataLocationS3: kotlin.String? = builder.dataLocationS3
    /**
     * A JSON string that represents the splitting and rearrangement requirement used when this `DataSource` was created.
     */
    public val dataRearrangement: kotlin.String? = builder.dataRearrangement
    /**
     * The total size of observations in the data files.
     */
    public val dataSizeInBytes: kotlin.Long? = builder.dataSizeInBytes
    /**
     * The ID assigned to the `DataSource` at creation. This value should be identical to the value of the `DataSourceId` in the request.
     */
    public val dataSourceId: kotlin.String? = builder.dataSourceId
    /**
     * The schema used by all of the data files of this `DataSource`.
     *
     * **Note:** This parameter is provided as part of the verbose format.
     */
    public val dataSourceSchema: kotlin.String? = builder.dataSourceSchema
    /**
     * The epoch time when Amazon Machine Learning marked the `DataSource` as `COMPLETED` or `FAILED`. `FinishedAt` is only available when the `DataSource` is in the `COMPLETED` or `FAILED` state.
     */
    public val finishedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.finishedAt
    /**
     * The time of the most recent edit to the `DataSource`. The time is expressed in epoch time.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * A link to the file containing logs of `CreateDataSourceFrom*` operations.
     */
    public val logUri: kotlin.String? = builder.logUri
    /**
     * The user-supplied description of the most recent details about creating the `DataSource`.
     */
    public val message: kotlin.String? = builder.message
    /**
     * A user-supplied name or description of the `DataSource`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The number of data files referenced by the `DataSource`.
     */
    public val numberOfFiles: kotlin.Long? = builder.numberOfFiles
    /**
     * The datasource details that are specific to Amazon RDS.
     */
    public val rdsMetadata: aws.sdk.kotlin.services.machinelearning.model.RdsMetadata? = builder.rdsMetadata
    /**
     * Describes the `DataSource` details specific to Amazon Redshift.
     */
    public val redshiftMetadata: aws.sdk.kotlin.services.machinelearning.model.RedshiftMetadata? = builder.redshiftMetadata
    /**
     * The Amazon Resource Name (ARN) of an [AWS IAM Role](https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html#roles-about-termsandconcepts), such as the following: arn:aws:iam::account:role/rolename.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The epoch time when Amazon Machine Learning marked the `DataSource` as `INPROGRESS`. `StartedAt` isn't available if the `DataSource` is in the `PENDING` state.
     */
    public val startedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.startedAt
    /**
     * The current status of the `DataSource`. This element can have one of the following values:
     * + `PENDING` - Amazon ML submitted a request to create a `DataSource`.
     * + `INPROGRESS` - The creation process is underway.
     * + `FAILED` - The request to create a `DataSource` did not run to completion. It is not usable.
     * + `COMPLETED` - The creation process completed successfully.
     * + `DELETED` - The `DataSource` is marked as deleted. It is not usable.
     */
    public val status: aws.sdk.kotlin.services.machinelearning.model.EntityStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.GetDataSourceResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDataSourceResponse(")
        append("computeStatistics=$computeStatistics,")
        append("computeTime=$computeTime,")
        append("createdAt=$createdAt,")
        append("createdByIamUser=$createdByIamUser,")
        append("dataLocationS3=$dataLocationS3,")
        append("dataRearrangement=$dataRearrangement,")
        append("dataSizeInBytes=$dataSizeInBytes,")
        append("dataSourceId=$dataSourceId,")
        append("dataSourceSchema=$dataSourceSchema,")
        append("finishedAt=$finishedAt,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("logUri=$logUri,")
        append("message=$message,")
        append("name=$name,")
        append("numberOfFiles=$numberOfFiles,")
        append("rdsMetadata=$rdsMetadata,")
        append("redshiftMetadata=$redshiftMetadata,")
        append("roleArn=$roleArn,")
        append("startedAt=$startedAt,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeStatistics.hashCode()
        result = 31 * result + (computeTime?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdByIamUser?.hashCode() ?: 0)
        result = 31 * result + (dataLocationS3?.hashCode() ?: 0)
        result = 31 * result + (dataRearrangement?.hashCode() ?: 0)
        result = 31 * result + (dataSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (dataSourceId?.hashCode() ?: 0)
        result = 31 * result + (dataSourceSchema?.hashCode() ?: 0)
        result = 31 * result + (finishedAt?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (logUri?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (numberOfFiles?.hashCode() ?: 0)
        result = 31 * result + (rdsMetadata?.hashCode() ?: 0)
        result = 31 * result + (redshiftMetadata?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDataSourceResponse

        if (computeStatistics != other.computeStatistics) return false
        if (computeTime != other.computeTime) return false
        if (createdAt != other.createdAt) return false
        if (createdByIamUser != other.createdByIamUser) return false
        if (dataLocationS3 != other.dataLocationS3) return false
        if (dataRearrangement != other.dataRearrangement) return false
        if (dataSizeInBytes != other.dataSizeInBytes) return false
        if (dataSourceId != other.dataSourceId) return false
        if (dataSourceSchema != other.dataSourceSchema) return false
        if (finishedAt != other.finishedAt) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (logUri != other.logUri) return false
        if (message != other.message) return false
        if (name != other.name) return false
        if (numberOfFiles != other.numberOfFiles) return false
        if (rdsMetadata != other.rdsMetadata) return false
        if (redshiftMetadata != other.redshiftMetadata) return false
        if (roleArn != other.roleArn) return false
        if (startedAt != other.startedAt) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.GetDataSourceResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The parameter is `true` if statistics need to be generated from the observation data.
         */
        public var computeStatistics: kotlin.Boolean = false
        /**
         * The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the `DataSource`, normalized and scaled on computation resources. `ComputeTime` is only available if the `DataSource` is in the `COMPLETED` state and the `ComputeStatistics` is set to true.
         */
        public var computeTime: kotlin.Long? = null
        /**
         * The time that the `DataSource` was created. The time is expressed in epoch time.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The AWS user account from which the `DataSource` was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.
         */
        public var createdByIamUser: kotlin.String? = null
        /**
         * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         */
        public var dataLocationS3: kotlin.String? = null
        /**
         * A JSON string that represents the splitting and rearrangement requirement used when this `DataSource` was created.
         */
        public var dataRearrangement: kotlin.String? = null
        /**
         * The total size of observations in the data files.
         */
        public var dataSizeInBytes: kotlin.Long? = null
        /**
         * The ID assigned to the `DataSource` at creation. This value should be identical to the value of the `DataSourceId` in the request.
         */
        public var dataSourceId: kotlin.String? = null
        /**
         * The schema used by all of the data files of this `DataSource`.
         *
         * **Note:** This parameter is provided as part of the verbose format.
         */
        public var dataSourceSchema: kotlin.String? = null
        /**
         * The epoch time when Amazon Machine Learning marked the `DataSource` as `COMPLETED` or `FAILED`. `FinishedAt` is only available when the `DataSource` is in the `COMPLETED` or `FAILED` state.
         */
        public var finishedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time of the most recent edit to the `DataSource`. The time is expressed in epoch time.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A link to the file containing logs of `CreateDataSourceFrom*` operations.
         */
        public var logUri: kotlin.String? = null
        /**
         * The user-supplied description of the most recent details about creating the `DataSource`.
         */
        public var message: kotlin.String? = null
        /**
         * A user-supplied name or description of the `DataSource`.
         */
        public var name: kotlin.String? = null
        /**
         * The number of data files referenced by the `DataSource`.
         */
        public var numberOfFiles: kotlin.Long? = null
        /**
         * The datasource details that are specific to Amazon RDS.
         */
        public var rdsMetadata: aws.sdk.kotlin.services.machinelearning.model.RdsMetadata? = null
        /**
         * Describes the `DataSource` details specific to Amazon Redshift.
         */
        public var redshiftMetadata: aws.sdk.kotlin.services.machinelearning.model.RedshiftMetadata? = null
        /**
         * The Amazon Resource Name (ARN) of an [AWS IAM Role](https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html#roles-about-termsandconcepts), such as the following: arn:aws:iam::account:role/rolename.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The epoch time when Amazon Machine Learning marked the `DataSource` as `INPROGRESS`. `StartedAt` isn't available if the `DataSource` is in the `PENDING` state.
         */
        public var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of the `DataSource`. This element can have one of the following values:
         * + `PENDING` - Amazon ML submitted a request to create a `DataSource`.
         * + `INPROGRESS` - The creation process is underway.
         * + `FAILED` - The request to create a `DataSource` did not run to completion. It is not usable.
         * + `COMPLETED` - The creation process completed successfully.
         * + `DELETED` - The `DataSource` is marked as deleted. It is not usable.
         */
        public var status: aws.sdk.kotlin.services.machinelearning.model.EntityStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.GetDataSourceResponse) : this() {
            this.computeStatistics = x.computeStatistics
            this.computeTime = x.computeTime
            this.createdAt = x.createdAt
            this.createdByIamUser = x.createdByIamUser
            this.dataLocationS3 = x.dataLocationS3
            this.dataRearrangement = x.dataRearrangement
            this.dataSizeInBytes = x.dataSizeInBytes
            this.dataSourceId = x.dataSourceId
            this.dataSourceSchema = x.dataSourceSchema
            this.finishedAt = x.finishedAt
            this.lastUpdatedAt = x.lastUpdatedAt
            this.logUri = x.logUri
            this.message = x.message
            this.name = x.name
            this.numberOfFiles = x.numberOfFiles
            this.rdsMetadata = x.rdsMetadata
            this.redshiftMetadata = x.redshiftMetadata
            this.roleArn = x.roleArn
            this.startedAt = x.startedAt
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.GetDataSourceResponse = GetDataSourceResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.machinelearning.model.RdsMetadata] inside the given [block]
         */
        public fun rdsMetadata(block: aws.sdk.kotlin.services.machinelearning.model.RdsMetadata.Builder.() -> kotlin.Unit) {
            this.rdsMetadata = aws.sdk.kotlin.services.machinelearning.model.RdsMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.machinelearning.model.RedshiftMetadata] inside the given [block]
         */
        public fun redshiftMetadata(block: aws.sdk.kotlin.services.machinelearning.model.RedshiftMetadata.Builder.() -> kotlin.Unit) {
            this.redshiftMetadata = aws.sdk.kotlin.services.machinelearning.model.RedshiftMetadata.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
