// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.waiters

import aws.sdk.kotlin.services.machinelearning.MachineLearningClient
import aws.sdk.kotlin.services.machinelearning.model.DescribeBatchPredictionsRequest
import aws.sdk.kotlin.services.machinelearning.model.DescribeBatchPredictionsResponse
import aws.sdk.kotlin.services.machinelearning.model.DescribeDataSourcesRequest
import aws.sdk.kotlin.services.machinelearning.model.DescribeDataSourcesResponse
import aws.sdk.kotlin.services.machinelearning.model.DescribeEvaluationsRequest
import aws.sdk.kotlin.services.machinelearning.model.DescribeEvaluationsResponse
import aws.sdk.kotlin.services.machinelearning.model.DescribeMlModelsRequest
import aws.sdk.kotlin.services.machinelearning.model.DescribeMlModelsResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds


public suspend fun MachineLearningClient.waitUntilBatchPredictionAvailable(request: DescribeBatchPredictionsRequest = DescribeBatchPredictionsRequest { }): Outcome<DescribeBatchPredictionsResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeBatchPredictionsRequest, DescribeBatchPredictionsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val results = it.results
            val resultsOrEmpty = results?.flattenIfPossible()
            val projection = resultsOrEmpty?.flatMap {
                val status = it?.status?.value
                listOfNotNull(status)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "COMPLETED" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val results = it.results
            val resultsOrEmpty = results?.flattenIfPossible()
            val projection = resultsOrEmpty?.flatMap {
                val status = it?.status?.value
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "FAILED" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeBatchPredictions(request) }
}

public suspend fun MachineLearningClient.waitUntilBatchPredictionAvailable(block: DescribeBatchPredictionsRequest.Builder.() -> Unit): Outcome<DescribeBatchPredictionsResponse> =
    waitUntilBatchPredictionAvailable(DescribeBatchPredictionsRequest.Builder().apply(block).build())

public suspend fun MachineLearningClient.waitUntilDataSourceAvailable(request: DescribeDataSourcesRequest = DescribeDataSourcesRequest { }): Outcome<DescribeDataSourcesResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeDataSourcesRequest, DescribeDataSourcesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val results = it.results
            val resultsOrEmpty = results?.flattenIfPossible()
            val projection = resultsOrEmpty?.flatMap {
                val status = it?.status?.value
                listOfNotNull(status)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "COMPLETED" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val results = it.results
            val resultsOrEmpty = results?.flattenIfPossible()
            val projection = resultsOrEmpty?.flatMap {
                val status = it?.status?.value
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "FAILED" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDataSources(request) }
}

public suspend fun MachineLearningClient.waitUntilDataSourceAvailable(block: DescribeDataSourcesRequest.Builder.() -> Unit): Outcome<DescribeDataSourcesResponse> =
    waitUntilDataSourceAvailable(DescribeDataSourcesRequest.Builder().apply(block).build())

public suspend fun MachineLearningClient.waitUntilEvaluationAvailable(request: DescribeEvaluationsRequest = DescribeEvaluationsRequest { }): Outcome<DescribeEvaluationsResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeEvaluationsRequest, DescribeEvaluationsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val results = it.results
            val resultsOrEmpty = results?.flattenIfPossible()
            val projection = resultsOrEmpty?.flatMap {
                val status = it?.status?.value
                listOfNotNull(status)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "COMPLETED" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val results = it.results
            val resultsOrEmpty = results?.flattenIfPossible()
            val projection = resultsOrEmpty?.flatMap {
                val status = it?.status?.value
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "FAILED" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeEvaluations(request) }
}

public suspend fun MachineLearningClient.waitUntilEvaluationAvailable(block: DescribeEvaluationsRequest.Builder.() -> Unit): Outcome<DescribeEvaluationsResponse> =
    waitUntilEvaluationAvailable(DescribeEvaluationsRequest.Builder().apply(block).build())

public suspend fun MachineLearningClient.waitUntilMLModelAvailable(request: DescribeMlModelsRequest = DescribeMlModelsRequest { }): Outcome<DescribeMlModelsResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeMlModelsRequest, DescribeMlModelsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val results = it.results
            val resultsOrEmpty = results?.flattenIfPossible()
            val projection = resultsOrEmpty?.flatMap {
                val status = it?.status?.value
                listOfNotNull(status)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "COMPLETED" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val results = it.results
            val resultsOrEmpty = results?.flattenIfPossible()
            val projection = resultsOrEmpty?.flatMap {
                val status = it?.status?.value
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "FAILED" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeMlModels(request) }
}

public suspend fun MachineLearningClient.waitUntilMLModelAvailable(block: DescribeMlModelsRequest.Builder.() -> Unit): Outcome<DescribeMlModelsResponse> =
    waitUntilMLModelAvailable(DescribeMlModelsRequest.Builder().apply(block).build())
