// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.serde

import aws.sdk.kotlin.services.machinelearning.model.EntityStatus
import aws.sdk.kotlin.services.machinelearning.model.GetBatchPredictionResponse
import aws.sdk.kotlin.services.machinelearning.model.MachineLearningException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetBatchPredictionOperationDeserializer: HttpDeserializer.NonStreaming<GetBatchPredictionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetBatchPredictionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetBatchPredictionError(context, call, payload)
        }
        val builder = GetBatchPredictionResponse.Builder()

        if (payload != null) {
            deserializeGetBatchPredictionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetBatchPredictionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MachineLearningException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MachineLearningException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBatchPredictionOperationBody(builder: GetBatchPredictionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BATCHPREDICTIONDATASOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BatchPredictionDataSourceId"))
    val BATCHPREDICTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BatchPredictionId"))
    val COMPUTETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("ComputeTime"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val CREATEDBYIAMUSER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreatedByIamUser"))
    val FINISHEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("FinishedAt"))
    val INPUTDATALOCATIONS3_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InputDataLocationS3"))
    val INVALIDRECORDCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("InvalidRecordCount"))
    val LASTUPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdatedAt"))
    val LOGURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LogUri"))
    val MLMODELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MLModelId"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Message"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val OUTPUTURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OutputUri"))
    val STARTEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartedAt"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val TOTALRECORDCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("TotalRecordCount"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BATCHPREDICTIONDATASOURCEID_DESCRIPTOR)
        field(BATCHPREDICTIONID_DESCRIPTOR)
        field(COMPUTETIME_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(CREATEDBYIAMUSER_DESCRIPTOR)
        field(FINISHEDAT_DESCRIPTOR)
        field(INPUTDATALOCATIONS3_DESCRIPTOR)
        field(INVALIDRECORDCOUNT_DESCRIPTOR)
        field(LASTUPDATEDAT_DESCRIPTOR)
        field(LOGURI_DESCRIPTOR)
        field(MLMODELID_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OUTPUTURI_DESCRIPTOR)
        field(STARTEDAT_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TOTALRECORDCOUNT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BATCHPREDICTIONDATASOURCEID_DESCRIPTOR.index -> builder.batchPredictionDataSourceId = deserializeString()
                BATCHPREDICTIONID_DESCRIPTOR.index -> builder.batchPredictionId = deserializeString()
                COMPUTETIME_DESCRIPTOR.index -> builder.computeTime = deserializeLong()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                CREATEDBYIAMUSER_DESCRIPTOR.index -> builder.createdByIamUser = deserializeString()
                FINISHEDAT_DESCRIPTOR.index -> builder.finishedAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                INPUTDATALOCATIONS3_DESCRIPTOR.index -> builder.inputDataLocationS3 = deserializeString()
                INVALIDRECORDCOUNT_DESCRIPTOR.index -> builder.invalidRecordCount = deserializeLong()
                LASTUPDATEDAT_DESCRIPTOR.index -> builder.lastUpdatedAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LOGURI_DESCRIPTOR.index -> builder.logUri = deserializeString()
                MLMODELID_DESCRIPTOR.index -> builder.mlModelId = deserializeString()
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                OUTPUTURI_DESCRIPTOR.index -> builder.outputUri = deserializeString()
                STARTEDAT_DESCRIPTOR.index -> builder.startedAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { EntityStatus.fromValue(it) }
                TOTALRECORDCOUNT_DESCRIPTOR.index -> builder.totalRecordCount = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
