// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeMlModelsRequest private constructor(builder: Builder) {
    /**
     * The equal to operator. The `MLModel` results will have `FilterVariable` values that exactly match the value specified with `EQ`.
     */
    public val eq: kotlin.String? = builder.eq
    /**
     * Use one of the following variables to filter a list of `MLModel`:
     * + `CreatedAt` - Sets the search criteria to `MLModel` creation date.
     * + `Status` - Sets the search criteria to `MLModel` status.
     * + `Name` - Sets the search criteria to the contents of `MLModel`****`Name`.
     * + `IAMUser` - Sets the search criteria to the user account that invoked the `MLModel` creation.
     * + `TrainingDataSourceId` - Sets the search criteria to the `DataSource` used to train one or more `MLModel`.
     * + `RealtimeEndpointStatus` - Sets the search criteria to the `MLModel` real-time endpoint status.
     * + `MLModelType` - Sets the search criteria to `MLModel` type: binary, regression, or multi-class.
     * + `Algorithm` - Sets the search criteria to the algorithm that the `MLModel` uses.
     * + `TrainingDataURI` - Sets the search criteria to the data file(s) used in training a `MLModel`. The URL can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.
     */
    public val filterVariable: aws.sdk.kotlin.services.machinelearning.model.MlModelFilterVariable? = builder.filterVariable
    /**
     * The greater than or equal to operator. The `MLModel` results will have `FilterVariable` values that are greater than or equal to the value specified with `GE`.
     */
    public val ge: kotlin.String? = builder.ge
    /**
     * The greater than operator. The `MLModel` results will have `FilterVariable` values that are greater than the value specified with `GT`.
     */
    public val gt: kotlin.String? = builder.gt
    /**
     * The less than or equal to operator. The `MLModel` results will have `FilterVariable` values that are less than or equal to the value specified with `LE`.
     */
    public val le: kotlin.String? = builder.le
    /**
     * The number of pages of information to include in the result. The range of acceptable values is `1` through `100`. The default value is `100`.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * The less than operator. The `MLModel` results will have `FilterVariable` values that are less than the value specified with `LT`.
     */
    public val lt: kotlin.String? = builder.lt
    /**
     * The not equal to operator. The `MLModel` results will have `FilterVariable` values not equal to the value specified with `NE`.
     */
    public val ne: kotlin.String? = builder.ne
    /**
     * The ID of the page in the paginated results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * A string that is found at the beginning of a variable, such as `Name` or `Id`.
     *
     * For example, an `MLModel` could have the `Name``2014-09-09-HolidayGiftMailer`. To search for this `MLModel`, select `Name` for the `FilterVariable` and any of the following strings for the `Prefix`:
     * + 2014-09
     * + 2014-09-09
     * + 2014-09-09-Holiday
     */
    public val prefix: kotlin.String? = builder.prefix
    /**
     * A two-value parameter that determines the sequence of the resulting list of `MLModel`.
     * + `asc` - Arranges the list in ascending order (A-Z, 0-9).
     * + `dsc` - Arranges the list in descending order (Z-A, 9-0).
     *
     * Results are sorted by `FilterVariable`.
     */
    public val sortOrder: aws.sdk.kotlin.services.machinelearning.model.SortOrder? = builder.sortOrder

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.DescribeMlModelsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeMlModelsRequest(")
        append("eq=$eq,")
        append("filterVariable=$filterVariable,")
        append("ge=$ge,")
        append("gt=$gt,")
        append("le=$le,")
        append("limit=$limit,")
        append("lt=$lt,")
        append("ne=$ne,")
        append("nextToken=$nextToken,")
        append("prefix=$prefix,")
        append("sortOrder=$sortOrder")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = eq?.hashCode() ?: 0
        result = 31 * result + (filterVariable?.hashCode() ?: 0)
        result = 31 * result + (ge?.hashCode() ?: 0)
        result = 31 * result + (gt?.hashCode() ?: 0)
        result = 31 * result + (le?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (lt?.hashCode() ?: 0)
        result = 31 * result + (ne?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeMlModelsRequest

        if (eq != other.eq) return false
        if (filterVariable != other.filterVariable) return false
        if (ge != other.ge) return false
        if (gt != other.gt) return false
        if (le != other.le) return false
        if (limit != other.limit) return false
        if (lt != other.lt) return false
        if (ne != other.ne) return false
        if (nextToken != other.nextToken) return false
        if (prefix != other.prefix) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.DescribeMlModelsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The equal to operator. The `MLModel` results will have `FilterVariable` values that exactly match the value specified with `EQ`.
         */
        public var eq: kotlin.String? = null
        /**
         * Use one of the following variables to filter a list of `MLModel`:
         * + `CreatedAt` - Sets the search criteria to `MLModel` creation date.
         * + `Status` - Sets the search criteria to `MLModel` status.
         * + `Name` - Sets the search criteria to the contents of `MLModel`****`Name`.
         * + `IAMUser` - Sets the search criteria to the user account that invoked the `MLModel` creation.
         * + `TrainingDataSourceId` - Sets the search criteria to the `DataSource` used to train one or more `MLModel`.
         * + `RealtimeEndpointStatus` - Sets the search criteria to the `MLModel` real-time endpoint status.
         * + `MLModelType` - Sets the search criteria to `MLModel` type: binary, regression, or multi-class.
         * + `Algorithm` - Sets the search criteria to the algorithm that the `MLModel` uses.
         * + `TrainingDataURI` - Sets the search criteria to the data file(s) used in training a `MLModel`. The URL can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.
         */
        public var filterVariable: aws.sdk.kotlin.services.machinelearning.model.MlModelFilterVariable? = null
        /**
         * The greater than or equal to operator. The `MLModel` results will have `FilterVariable` values that are greater than or equal to the value specified with `GE`.
         */
        public var ge: kotlin.String? = null
        /**
         * The greater than operator. The `MLModel` results will have `FilterVariable` values that are greater than the value specified with `GT`.
         */
        public var gt: kotlin.String? = null
        /**
         * The less than or equal to operator. The `MLModel` results will have `FilterVariable` values that are less than or equal to the value specified with `LE`.
         */
        public var le: kotlin.String? = null
        /**
         * The number of pages of information to include in the result. The range of acceptable values is `1` through `100`. The default value is `100`.
         */
        public var limit: kotlin.Int? = null
        /**
         * The less than operator. The `MLModel` results will have `FilterVariable` values that are less than the value specified with `LT`.
         */
        public var lt: kotlin.String? = null
        /**
         * The not equal to operator. The `MLModel` results will have `FilterVariable` values not equal to the value specified with `NE`.
         */
        public var ne: kotlin.String? = null
        /**
         * The ID of the page in the paginated results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * A string that is found at the beginning of a variable, such as `Name` or `Id`.
         *
         * For example, an `MLModel` could have the `Name``2014-09-09-HolidayGiftMailer`. To search for this `MLModel`, select `Name` for the `FilterVariable` and any of the following strings for the `Prefix`:
         * + 2014-09
         * + 2014-09-09
         * + 2014-09-09-Holiday
         */
        public var prefix: kotlin.String? = null
        /**
         * A two-value parameter that determines the sequence of the resulting list of `MLModel`.
         * + `asc` - Arranges the list in ascending order (A-Z, 0-9).
         * + `dsc` - Arranges the list in descending order (Z-A, 9-0).
         *
         * Results are sorted by `FilterVariable`.
         */
        public var sortOrder: aws.sdk.kotlin.services.machinelearning.model.SortOrder? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.DescribeMlModelsRequest) : this() {
            this.eq = x.eq
            this.filterVariable = x.filterVariable
            this.ge = x.ge
            this.gt = x.gt
            this.le = x.le
            this.limit = x.limit
            this.lt = x.lt
            this.ne = x.ne
            this.nextToken = x.nextToken
            this.prefix = x.prefix
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.DescribeMlModelsRequest = DescribeMlModelsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
