// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.serde

import aws.sdk.kotlin.services.machinelearning.model.PredictRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PredictOperationSerializer: HttpSerializer.NonStreaming<PredictRequest> {
    override fun serialize(context: ExecutionContext, input: PredictRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializePredictOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializePredictOperationBody(context: ExecutionContext, input: PredictRequest): ByteArray {
    val serializer = JsonSerializer()
    val MLMODELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MLModelId"))
    val PREDICTENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PredictEndpoint"))
    val RECORD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Record"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MLMODELID_DESCRIPTOR)
        field(PREDICTENDPOINT_DESCRIPTOR)
        field(RECORD_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.mlModelId?.let { field(MLMODELID_DESCRIPTOR, it) }
        input.predictEndpoint?.let { field(PREDICTENDPOINT_DESCRIPTOR, it) }
        if (input.record != null) {
            mapField(RECORD_DESCRIPTOR) {
                input.record.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
    }
    return serializer.toByteArray()
}
