// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.serde

import aws.sdk.kotlin.services.machinelearning.model.EntityStatus
import aws.sdk.kotlin.services.machinelearning.model.GetMlModelResponse
import aws.sdk.kotlin.services.machinelearning.model.MachineLearningException
import aws.sdk.kotlin.services.machinelearning.model.MlModelType
import aws.sdk.kotlin.services.machinelearning.model.RealtimeEndpointInfo
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableMapOf


internal class GetMLModelOperationDeserializer: HttpDeserializer.NonStreaming<GetMlModelResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetMlModelResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetMlModelError(context, call, payload)
        }
        val builder = GetMlModelResponse.Builder()

        if (payload != null) {
            deserializeGetMLModelOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetMlModelError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MachineLearningException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MachineLearningException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMLModelOperationBody(builder: GetMlModelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPUTETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("ComputeTime"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val CREATEDBYIAMUSER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreatedByIamUser"))
    val ENDPOINTINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EndpointInfo"))
    val FINISHEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("FinishedAt"))
    val INPUTDATALOCATIONS3_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InputDataLocationS3"))
    val LASTUPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdatedAt"))
    val LOGURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LogUri"))
    val MLMODELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MLModelId"))
    val MLMODELTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("MLModelType"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Message"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val RECIPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Recipe"))
    val SCHEMA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Schema"))
    val SCORETHRESHOLD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Float, JsonSerialName("ScoreThreshold"))
    val SCORETHRESHOLDLASTUPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ScoreThresholdLastUpdatedAt"))
    val SIZEINBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("SizeInBytes"))
    val STARTEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartedAt"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val TRAININGDATASOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrainingDataSourceId"))
    val TRAININGPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("TrainingParameters"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPUTETIME_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(CREATEDBYIAMUSER_DESCRIPTOR)
        field(ENDPOINTINFO_DESCRIPTOR)
        field(FINISHEDAT_DESCRIPTOR)
        field(INPUTDATALOCATIONS3_DESCRIPTOR)
        field(LASTUPDATEDAT_DESCRIPTOR)
        field(LOGURI_DESCRIPTOR)
        field(MLMODELID_DESCRIPTOR)
        field(MLMODELTYPE_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(RECIPE_DESCRIPTOR)
        field(SCHEMA_DESCRIPTOR)
        field(SCORETHRESHOLD_DESCRIPTOR)
        field(SCORETHRESHOLDLASTUPDATEDAT_DESCRIPTOR)
        field(SIZEINBYTES_DESCRIPTOR)
        field(STARTEDAT_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TRAININGDATASOURCEID_DESCRIPTOR)
        field(TRAININGPARAMETERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPUTETIME_DESCRIPTOR.index -> builder.computeTime = deserializeLong()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATEDBYIAMUSER_DESCRIPTOR.index -> builder.createdByIamUser = deserializeString()
                ENDPOINTINFO_DESCRIPTOR.index -> builder.endpointInfo = deserializeRealtimeEndpointInfoDocument(deserializer)
                FINISHEDAT_DESCRIPTOR.index -> builder.finishedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                INPUTDATALOCATIONS3_DESCRIPTOR.index -> builder.inputDataLocationS3 = deserializeString()
                LASTUPDATEDAT_DESCRIPTOR.index -> builder.lastUpdatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                LOGURI_DESCRIPTOR.index -> builder.logUri = deserializeString()
                MLMODELID_DESCRIPTOR.index -> builder.mlModelId = deserializeString()
                MLMODELTYPE_DESCRIPTOR.index -> builder.mlModelType = deserializeString().let { MlModelType.fromValue(it) }
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                RECIPE_DESCRIPTOR.index -> builder.recipe = deserializeString()
                SCHEMA_DESCRIPTOR.index -> builder.schema = deserializeString()
                SCORETHRESHOLD_DESCRIPTOR.index -> builder.scoreThreshold = deserializeFloat()
                SCORETHRESHOLDLASTUPDATEDAT_DESCRIPTOR.index -> builder.scoreThresholdLastUpdatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                SIZEINBYTES_DESCRIPTOR.index -> builder.sizeInBytes = deserializeLong()
                STARTEDAT_DESCRIPTOR.index -> builder.startedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { EntityStatus.fromValue(it) }
                TRAININGDATASOURCEID_DESCRIPTOR.index -> builder.trainingDataSourceId = deserializeString()
                TRAININGPARAMETERS_DESCRIPTOR.index -> builder.trainingParameters =
                    deserializer.deserializeMap(TRAININGPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
