// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model



/**
 * The output from a `Predict` operation:
 * + `Details` - Contains the following attributes: `DetailsAttributes.PREDICTIVE_MODEL_TYPE - REGRESSION | BINARY | MULTICLASS``DetailsAttributes.ALGORITHM - SGD`
 * + `PredictedLabel` - Present for either a `BINARY` or `MULTICLASS``MLModel` request.
 * + `PredictedScores` - Contains the raw classification score corresponding to each label.
 * + `PredictedValue` - Present for a `REGRESSION``MLModel` request.
 */
public class Prediction private constructor(builder: Builder) {
    /**
     * Provides any additional details regarding the prediction.
     */
    public val details: Map<DetailsAttributes, String>? = builder.details
    /**
     * The prediction label for either a `BINARY` or `MULTICLASS``MLModel`.
     */
    public val predictedLabel: kotlin.String? = builder.predictedLabel
    /**
     * Provides the raw classification score corresponding to each label.
     */
    public val predictedScores: Map<String, Float>? = builder.predictedScores
    /**
     * The prediction value for `REGRESSION``MLModel`.
     */
    public val predictedValue: kotlin.Float? = builder.predictedValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.Prediction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Prediction(")
        append("details=$details,")
        append("predictedLabel=$predictedLabel,")
        append("predictedScores=$predictedScores,")
        append("predictedValue=$predictedValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = details?.hashCode() ?: 0
        result = 31 * result + (predictedLabel?.hashCode() ?: 0)
        result = 31 * result + (predictedScores?.hashCode() ?: 0)
        result = 31 * result + (predictedValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Prediction

        if (details != other.details) return false
        if (predictedLabel != other.predictedLabel) return false
        if (predictedScores != other.predictedScores) return false
        if (predictedValue != other.predictedValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.Prediction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Provides any additional details regarding the prediction.
         */
        public var details: Map<DetailsAttributes, String>? = null
        /**
         * The prediction label for either a `BINARY` or `MULTICLASS``MLModel`.
         */
        public var predictedLabel: kotlin.String? = null
        /**
         * Provides the raw classification score corresponding to each label.
         */
        public var predictedScores: Map<String, Float>? = null
        /**
         * The prediction value for `REGRESSION``MLModel`.
         */
        public var predictedValue: kotlin.Float? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.Prediction) : this() {
            this.details = x.details
            this.predictedLabel = x.predictedLabel
            this.predictedScores = x.predictedScores
            this.predictedValue = x.predictedValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.Prediction = Prediction(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
