// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model



public class CreateDataSourceFromRdsRequest private constructor(builder: Builder) {
    /**
     * The compute statistics for a `DataSource`. The statistics are generated from the observation data referenced by a `DataSource`. Amazon ML uses the statistics internally during `MLModel` training. This parameter must be set to `true` if the ``DataSource`` needs to be used for `MLModel` training.
     */
    public val computeStatistics: kotlin.Boolean? = builder.computeStatistics
    /**
     * A user-supplied ID that uniquely identifies the `DataSource`. Typically, an Amazon Resource Number (ARN) becomes the ID for a `DataSource`.
     */
    public val dataSourceId: kotlin.String? = builder.dataSourceId
    /**
     * A user-supplied name or description of the `DataSource`.
     */
    public val dataSourceName: kotlin.String? = builder.dataSourceName
    /**
     * The data specification of an Amazon RDS `DataSource`:
     * + DatabaseInformation -
     *    + `DatabaseName` - The name of the Amazon RDS database.
     *    + `InstanceIdentifier ` - A unique identifier for the Amazon RDS database instance.
     * + DatabaseCredentials - AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon RDS database.
     * + ResourceRole - A role (DataPipelineDefaultResourceRole) assumed by an EC2 instance to carry out the copy task from Amazon RDS to Amazon Simple Storage Service (Amazon S3). For more information, see [Role templates](https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html) for data pipelines.
     * + ServiceRole - A role (DataPipelineDefaultRole) assumed by the AWS Data Pipeline service to monitor the progress of the copy task from Amazon RDS to Amazon S3. For more information, see [Role templates](https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html) for data pipelines.
     * + SecurityInfo - The security information to use to access an RDS DB instance. You need to set up appropriate ingress rules for the security entity IDs provided to allow access to the Amazon RDS instance. Specify a &#91;`SubnetId`, `SecurityGroupIds`&#93; pair for a VPC-based RDS DB instance.
     * + SelectSqlQuery - A query that is used to retrieve the observation data for the `Datasource`.
     * + S3StagingLocation - The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon RDS using `SelectSqlQuery` is stored in this location.
     * + DataSchemaUri - The Amazon S3 location of the `DataSchema`.
     * + DataSchema - A JSON string representing the schema. This is not required if `DataSchemaUri` is specified.
     * + DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the `Datasource`.  Sample - ` "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"`
     */
    public val rdsData: aws.sdk.kotlin.services.machinelearning.model.RdsDataSpec? = builder.rdsData
    /**
     * The role that Amazon ML assumes on behalf of the user to create and activate a data pipeline in the user's account and copy data using the `SelectSqlQuery` query from Amazon RDS to Amazon S3.
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.CreateDataSourceFromRdsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDataSourceFromRdsRequest(")
        append("computeStatistics=$computeStatistics,")
        append("dataSourceId=$dataSourceId,")
        append("dataSourceName=$dataSourceName,")
        append("rdsData=$rdsData,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeStatistics?.hashCode() ?: 0
        result = 31 * result + (dataSourceId?.hashCode() ?: 0)
        result = 31 * result + (dataSourceName?.hashCode() ?: 0)
        result = 31 * result + (rdsData?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDataSourceFromRdsRequest

        if (computeStatistics != other.computeStatistics) return false
        if (dataSourceId != other.dataSourceId) return false
        if (dataSourceName != other.dataSourceName) return false
        if (rdsData != other.rdsData) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.CreateDataSourceFromRdsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The compute statistics for a `DataSource`. The statistics are generated from the observation data referenced by a `DataSource`. Amazon ML uses the statistics internally during `MLModel` training. This parameter must be set to `true` if the ``DataSource`` needs to be used for `MLModel` training.
         */
        public var computeStatistics: kotlin.Boolean? = null
        /**
         * A user-supplied ID that uniquely identifies the `DataSource`. Typically, an Amazon Resource Number (ARN) becomes the ID for a `DataSource`.
         */
        public var dataSourceId: kotlin.String? = null
        /**
         * A user-supplied name or description of the `DataSource`.
         */
        public var dataSourceName: kotlin.String? = null
        /**
         * The data specification of an Amazon RDS `DataSource`:
         * + DatabaseInformation -
         *    + `DatabaseName` - The name of the Amazon RDS database.
         *    + `InstanceIdentifier ` - A unique identifier for the Amazon RDS database instance.
         * + DatabaseCredentials - AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon RDS database.
         * + ResourceRole - A role (DataPipelineDefaultResourceRole) assumed by an EC2 instance to carry out the copy task from Amazon RDS to Amazon Simple Storage Service (Amazon S3). For more information, see [Role templates](https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html) for data pipelines.
         * + ServiceRole - A role (DataPipelineDefaultRole) assumed by the AWS Data Pipeline service to monitor the progress of the copy task from Amazon RDS to Amazon S3. For more information, see [Role templates](https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html) for data pipelines.
         * + SecurityInfo - The security information to use to access an RDS DB instance. You need to set up appropriate ingress rules for the security entity IDs provided to allow access to the Amazon RDS instance. Specify a &#91;`SubnetId`, `SecurityGroupIds`&#93; pair for a VPC-based RDS DB instance.
         * + SelectSqlQuery - A query that is used to retrieve the observation data for the `Datasource`.
         * + S3StagingLocation - The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon RDS using `SelectSqlQuery` is stored in this location.
         * + DataSchemaUri - The Amazon S3 location of the `DataSchema`.
         * + DataSchema - A JSON string representing the schema. This is not required if `DataSchemaUri` is specified.
         * + DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the `Datasource`.  Sample - ` "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"`
         */
        public var rdsData: aws.sdk.kotlin.services.machinelearning.model.RdsDataSpec? = null
        /**
         * The role that Amazon ML assumes on behalf of the user to create and activate a data pipeline in the user's account and copy data using the `SelectSqlQuery` query from Amazon RDS to Amazon S3.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.CreateDataSourceFromRdsRequest) : this() {
            this.computeStatistics = x.computeStatistics
            this.dataSourceId = x.dataSourceId
            this.dataSourceName = x.dataSourceName
            this.rdsData = x.rdsData
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.CreateDataSourceFromRdsRequest = CreateDataSourceFromRdsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.machinelearning.model.RdsDataSpec] inside the given [block]
         */
        public fun rdsData(block: aws.sdk.kotlin.services.machinelearning.model.RdsDataSpec.Builder.() -> kotlin.Unit) {
            this.rdsData = aws.sdk.kotlin.services.machinelearning.model.RdsDataSpec.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
