// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.serde

import aws.sdk.kotlin.services.machinelearning.model.DeleteTagsResponse
import aws.sdk.kotlin.services.machinelearning.model.MachineLearningException
import aws.sdk.kotlin.services.machinelearning.model.TaggableResourceType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteTagsOperationDeserializer: HttpDeserialize<DeleteTagsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteTagsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteTagsError(context, call)
        }
        val builder = DeleteTagsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteTagsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteTagsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MachineLearningException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidTagException" -> InvalidTagExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall)
        else -> MachineLearningException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteTagsOperationBody(builder: DeleteTagsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RESOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceId"))
    val RESOURCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ResourceType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESOURCEID_DESCRIPTOR)
        field(RESOURCETYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RESOURCEID_DESCRIPTOR.index -> builder.resourceId = deserializeString()
                RESOURCETYPE_DESCRIPTOR.index -> builder.resourceType = deserializeString().let { TaggableResourceType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
