// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.serde

import aws.sdk.kotlin.services.machinelearning.model.EntityStatus
import aws.sdk.kotlin.services.machinelearning.model.GetEvaluationResponse
import aws.sdk.kotlin.services.machinelearning.model.MachineLearningException
import aws.sdk.kotlin.services.machinelearning.model.PerformanceMetrics
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetEvaluationOperationDeserializer: HttpDeserialize<GetEvaluationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetEvaluationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetEvaluationError(context, call)
        }
        val builder = GetEvaluationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetEvaluationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetEvaluationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MachineLearningException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> MachineLearningException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetEvaluationOperationBody(builder: GetEvaluationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPUTETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("ComputeTime"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val CREATEDBYIAMUSER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreatedByIamUser"))
    val EVALUATIONDATASOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EvaluationDataSourceId"))
    val EVALUATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EvaluationId"))
    val FINISHEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("FinishedAt"))
    val INPUTDATALOCATIONS3_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InputDataLocationS3"))
    val LASTUPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdatedAt"))
    val LOGURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LogUri"))
    val MLMODELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MLModelId"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Message"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PERFORMANCEMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PerformanceMetrics"))
    val STARTEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartedAt"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPUTETIME_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(CREATEDBYIAMUSER_DESCRIPTOR)
        field(EVALUATIONDATASOURCEID_DESCRIPTOR)
        field(EVALUATIONID_DESCRIPTOR)
        field(FINISHEDAT_DESCRIPTOR)
        field(INPUTDATALOCATIONS3_DESCRIPTOR)
        field(LASTUPDATEDAT_DESCRIPTOR)
        field(LOGURI_DESCRIPTOR)
        field(MLMODELID_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PERFORMANCEMETRICS_DESCRIPTOR)
        field(STARTEDAT_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPUTETIME_DESCRIPTOR.index -> builder.computeTime = deserializeLong()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATEDBYIAMUSER_DESCRIPTOR.index -> builder.createdByIamUser = deserializeString()
                EVALUATIONDATASOURCEID_DESCRIPTOR.index -> builder.evaluationDataSourceId = deserializeString()
                EVALUATIONID_DESCRIPTOR.index -> builder.evaluationId = deserializeString()
                FINISHEDAT_DESCRIPTOR.index -> builder.finishedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                INPUTDATALOCATIONS3_DESCRIPTOR.index -> builder.inputDataLocationS3 = deserializeString()
                LASTUPDATEDAT_DESCRIPTOR.index -> builder.lastUpdatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                LOGURI_DESCRIPTOR.index -> builder.logUri = deserializeString()
                MLMODELID_DESCRIPTOR.index -> builder.mlModelId = deserializeString()
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PERFORMANCEMETRICS_DESCRIPTOR.index -> builder.performanceMetrics = deserializePerformanceMetricsDocument(deserializer)
                STARTEDAT_DESCRIPTOR.index -> builder.startedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { EntityStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
