// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model



/**
 * Describes the database credentials for connecting to a database on an Amazon Redshift cluster.
 */
public class RedshiftDatabaseCredentials private constructor(builder: Builder) {
    /**
     * A password to be used by Amazon ML to connect to a database on an Amazon Redshift cluster. The password should have sufficient permissions to execute a `RedshiftSelectSqlQuery` query. The password should be valid for an Amazon Redshift [USER](https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html).
     */
    public val password: kotlin.String = requireNotNull(builder.password) { "A non-null value must be provided for password" }
    /**
     * A username to be used by Amazon Machine Learning (Amazon ML)to connect to a database on an Amazon Redshift cluster. The username should have sufficient permissions to execute the `RedshiftSelectSqlQuery` query. The username should be valid for an Amazon Redshift [USER](https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html).
     */
    public val username: kotlin.String = requireNotNull(builder.username) { "A non-null value must be provided for username" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabaseCredentials = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedshiftDatabaseCredentials(")
        append("password=*** Sensitive Data Redacted ***,")
        append("username=$username")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = password.hashCode()
        result = 31 * result + (username.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedshiftDatabaseCredentials

        if (password != other.password) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabaseCredentials = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A password to be used by Amazon ML to connect to a database on an Amazon Redshift cluster. The password should have sufficient permissions to execute a `RedshiftSelectSqlQuery` query. The password should be valid for an Amazon Redshift [USER](https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html).
         */
        public var password: kotlin.String? = null
        /**
         * A username to be used by Amazon Machine Learning (Amazon ML)to connect to a database on an Amazon Redshift cluster. The username should have sufficient permissions to execute the `RedshiftSelectSqlQuery` query. The username should be valid for an Amazon Redshift [USER](https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html).
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabaseCredentials) : this() {
            this.password = x.password
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabaseCredentials = RedshiftDatabaseCredentials(this)

        internal fun correctErrors(): Builder {
            if (password == null) password = ""
            if (username == null) username = ""
            return this
        }
    }
}
