// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model



public class CreateMlModelRequest private constructor(builder: Builder) {
    /**
     * A user-supplied ID that uniquely identifies the `MLModel`.
     */
    public val mlModelId: kotlin.String? = builder.mlModelId
    /**
     * A user-supplied name or description of the `MLModel`.
     */
    public val mlModelName: kotlin.String? = builder.mlModelName
    /**
     * The category of supervised learning that this `MLModel` will address. Choose from the following types:
     * + Choose `REGRESSION` if the `MLModel` will be used to predict a numeric value.
     * + Choose `BINARY` if the `MLModel` result has two possible values.
     * + Choose `MULTICLASS` if the `MLModel` result has a limited number of values.
     *
     *  For more information, see the [Amazon Machine Learning Developer Guide](https://docs.aws.amazon.com/machine-learning/latest/dg).
     */
    public val mlModelType: aws.sdk.kotlin.services.machinelearning.model.MlModelType? = builder.mlModelType
    /**
     * A list of the training parameters in the `MLModel`. The list is implemented as a map of key-value pairs.
     *
     * The following is the current set of training parameters:
     * + `sgd.maxMLModelSizeInBytes` - The maximum allowed size of the model. Depending on the input data, the size of the model might affect its performance. The value is an integer that ranges from `100000` to `2147483648`. The default value is `33554432`.
     * + `sgd.maxPasses` - The number of times that the training process traverses the observations to build the `MLModel`. The value is an integer that ranges from `1` to `10000`. The default value is `10`.
     * + `sgd.shuffleType` - Whether Amazon ML shuffles the training data. Shuffling the data improves a model's ability to find the optimal solution for a variety of data types. The valid values are `auto` and `none`. The default value is `none`. We strongly recommend that you shuffle your data.
     * + `sgd.l1RegularizationAmount` - The coefficient regularization L1 norm. It controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a sparse feature set. If you use this parameter, start by specifying a small value, such as `1.0E-08`.The value is a double that ranges from `0` to `MAX_DOUBLE`. The default is to not use L1 normalization. This parameter can't be used when `L2` is specified. Use this parameter sparingly.
     * + `sgd.l2RegularizationAmount` - The coefficient regularization L2 norm. It controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use this parameter, start by specifying a small value, such as `1.0E-08`.The value is a double that ranges from `0` to `MAX_DOUBLE`. The default is to not use L2 normalization. This parameter can't be used when `L1` is specified. Use this parameter sparingly.
     */
    public val parameters: Map<String, String>? = builder.parameters
    /**
     * The data recipe for creating the `MLModel`. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.
     */
    public val recipe: kotlin.String? = builder.recipe
    /**
     * The Amazon Simple Storage Service (Amazon S3) location and file name that contains the `MLModel` recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.
     */
    public val recipeUri: kotlin.String? = builder.recipeUri
    /**
     * The `DataSource` that points to the training data.
     */
    public val trainingDataSourceId: kotlin.String? = builder.trainingDataSourceId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.CreateMlModelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateMlModelRequest(")
        append("mlModelId=$mlModelId,")
        append("mlModelName=$mlModelName,")
        append("mlModelType=$mlModelType,")
        append("parameters=$parameters,")
        append("recipe=$recipe,")
        append("recipeUri=$recipeUri,")
        append("trainingDataSourceId=$trainingDataSourceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = mlModelId?.hashCode() ?: 0
        result = 31 * result + (mlModelName?.hashCode() ?: 0)
        result = 31 * result + (mlModelType?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (recipe?.hashCode() ?: 0)
        result = 31 * result + (recipeUri?.hashCode() ?: 0)
        result = 31 * result + (trainingDataSourceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateMlModelRequest

        if (mlModelId != other.mlModelId) return false
        if (mlModelName != other.mlModelName) return false
        if (mlModelType != other.mlModelType) return false
        if (parameters != other.parameters) return false
        if (recipe != other.recipe) return false
        if (recipeUri != other.recipeUri) return false
        if (trainingDataSourceId != other.trainingDataSourceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.CreateMlModelRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A user-supplied ID that uniquely identifies the `MLModel`.
         */
        public var mlModelId: kotlin.String? = null
        /**
         * A user-supplied name or description of the `MLModel`.
         */
        public var mlModelName: kotlin.String? = null
        /**
         * The category of supervised learning that this `MLModel` will address. Choose from the following types:
         * + Choose `REGRESSION` if the `MLModel` will be used to predict a numeric value.
         * + Choose `BINARY` if the `MLModel` result has two possible values.
         * + Choose `MULTICLASS` if the `MLModel` result has a limited number of values.
         *
         *  For more information, see the [Amazon Machine Learning Developer Guide](https://docs.aws.amazon.com/machine-learning/latest/dg).
         */
        public var mlModelType: aws.sdk.kotlin.services.machinelearning.model.MlModelType? = null
        /**
         * A list of the training parameters in the `MLModel`. The list is implemented as a map of key-value pairs.
         *
         * The following is the current set of training parameters:
         * + `sgd.maxMLModelSizeInBytes` - The maximum allowed size of the model. Depending on the input data, the size of the model might affect its performance. The value is an integer that ranges from `100000` to `2147483648`. The default value is `33554432`.
         * + `sgd.maxPasses` - The number of times that the training process traverses the observations to build the `MLModel`. The value is an integer that ranges from `1` to `10000`. The default value is `10`.
         * + `sgd.shuffleType` - Whether Amazon ML shuffles the training data. Shuffling the data improves a model's ability to find the optimal solution for a variety of data types. The valid values are `auto` and `none`. The default value is `none`. We strongly recommend that you shuffle your data.
         * + `sgd.l1RegularizationAmount` - The coefficient regularization L1 norm. It controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a sparse feature set. If you use this parameter, start by specifying a small value, such as `1.0E-08`.The value is a double that ranges from `0` to `MAX_DOUBLE`. The default is to not use L1 normalization. This parameter can't be used when `L2` is specified. Use this parameter sparingly.
         * + `sgd.l2RegularizationAmount` - The coefficient regularization L2 norm. It controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use this parameter, start by specifying a small value, such as `1.0E-08`.The value is a double that ranges from `0` to `MAX_DOUBLE`. The default is to not use L2 normalization. This parameter can't be used when `L1` is specified. Use this parameter sparingly.
         */
        public var parameters: Map<String, String>? = null
        /**
         * The data recipe for creating the `MLModel`. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.
         */
        public var recipe: kotlin.String? = null
        /**
         * The Amazon Simple Storage Service (Amazon S3) location and file name that contains the `MLModel` recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.
         */
        public var recipeUri: kotlin.String? = null
        /**
         * The `DataSource` that points to the training data.
         */
        public var trainingDataSourceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.CreateMlModelRequest) : this() {
            this.mlModelId = x.mlModelId
            this.mlModelName = x.mlModelName
            this.mlModelType = x.mlModelType
            this.parameters = x.parameters
            this.recipe = x.recipe
            this.recipeUri = x.recipeUri
            this.trainingDataSourceId = x.trainingDataSourceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.CreateMlModelRequest = CreateMlModelRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
