// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.machinelearning.auth.AuthSchemeProviderAdapter
import aws.sdk.kotlin.services.machinelearning.auth.IdentityProviderConfigAdapter
import aws.sdk.kotlin.services.machinelearning.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.machinelearning.internal.ResolvePredictEndpoint
import aws.sdk.kotlin.services.machinelearning.model.*
import aws.sdk.kotlin.services.machinelearning.transform.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "Machine Learning"
public const val ServiceApiVersion: String = "2014-12-12"
public const val SdkVersion: String = "0.27.1-beta"

internal class DefaultMachineLearningClient(override val config: MachineLearningClient.Config) : MachineLearningClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = IdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(HttpAuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "machinelearning")
        }
        toMap()
    }

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Adds one or more tags to an object, up to a limit of 10. Each tag consists of a key and an optional value. If you add a tag using a key that is already associated with the ML object, `AddTags` updates the tag's value.
     */
    override suspend fun addTags(input: AddTagsRequest): AddTagsResponse {
        val op = SdkHttpOperation.build<AddTagsRequest, AddTagsResponse> {
            serializer = AddTagsOperationSerializer()
            deserializer = AddTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AddTags"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AddTags-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Generates predictions for a group of observations. The observations to process exist in one or more data files referenced by a `DataSource`. This operation creates a new `BatchPrediction`, and uses an `MLModel` and the data files referenced by the `DataSource` as information sources.
     *
     * `CreateBatchPrediction` is an asynchronous operation. In response to `CreateBatchPrediction`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `BatchPrediction` status to `PENDING`. After the `BatchPrediction` completes, Amazon ML sets the status to `COMPLETED`.
     *
     * You can poll for status updates by using the GetBatchPrediction operation and checking the `Status` parameter of the result. After the `COMPLETED` status appears, the results are available in the location specified by the `OutputUri` parameter.
     */
    override suspend fun createBatchPrediction(input: CreateBatchPredictionRequest): CreateBatchPredictionResponse {
        val op = SdkHttpOperation.build<CreateBatchPredictionRequest, CreateBatchPredictionResponse> {
            serializer = CreateBatchPredictionOperationSerializer()
            deserializer = CreateBatchPredictionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateBatchPrediction"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateBatchPrediction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a `DataSource` object from an [ Amazon Relational Database Service](http://aws.amazon.com/rds/) (Amazon RDS). A `DataSource` references data that can be used to perform `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
     *
     * `CreateDataSourceFromRDS` is an asynchronous operation. In response to `CreateDataSourceFromRDS`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `DataSource` status to `PENDING`. After the `DataSource` is created and ready for use, Amazon ML sets the `Status` parameter to `COMPLETED`. `DataSource` in the `COMPLETED` or `PENDING` state can be used only to perform `>CreateMLModel`>, `CreateEvaluation`, or `CreateBatchPrediction` operations.
     *
     *  If Amazon ML cannot accept the input source, it sets the `Status` parameter to `FAILED` and includes an error message in the `Message` attribute of the `GetDataSource` operation response.
     */
    override suspend fun createDataSourceFromRds(input: CreateDataSourceFromRdsRequest): CreateDataSourceFromRdsResponse {
        val op = SdkHttpOperation.build<CreateDataSourceFromRdsRequest, CreateDataSourceFromRdsResponse> {
            serializer = CreateDataSourceFromRDSOperationSerializer()
            deserializer = CreateDataSourceFromRDSOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateDataSourceFromRDS"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateDataSourceFromRDS-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a `DataSource` from a database hosted on an Amazon Redshift cluster. A `DataSource` references data that can be used to perform either `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
     *
     * `CreateDataSourceFromRedshift` is an asynchronous operation. In response to `CreateDataSourceFromRedshift`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `DataSource` status to `PENDING`. After the `DataSource` is created and ready for use, Amazon ML sets the `Status` parameter to `COMPLETED`. `DataSource` in `COMPLETED` or `PENDING` states can be used to perform only `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
     *
     *  If Amazon ML can't accept the input source, it sets the `Status` parameter to `FAILED` and includes an error message in the `Message` attribute of the `GetDataSource` operation response.
     *
     * The observations should be contained in the database hosted on an Amazon Redshift cluster and should be specified by a `SelectSqlQuery` query. Amazon ML executes an `Unload` command in Amazon Redshift to transfer the result set of the `SelectSqlQuery` query to `S3StagingLocation`.
     *
     * After the `DataSource` has been created, it's ready for use in evaluations and batch predictions. If you plan to use the `DataSource` to train an `MLModel`, the `DataSource` also requires a recipe. A recipe describes how each input variable will be used in training an `MLModel`. Will the variable be included or excluded from training? Will the variable be manipulated; for example, will it be combined with another variable or will it be split apart into word combinations? The recipe provides answers to these questions.
     *
     * You can't change an existing datasource, but you can copy and modify the settings from an existing Amazon Redshift datasource to create a new datasource. To do so, call `GetDataSource` for an existing datasource and copy the values to a `CreateDataSource` call. Change the settings that you want to change and make sure that all required fields have the appropriate values.
     */
    override suspend fun createDataSourceFromRedshift(input: CreateDataSourceFromRedshiftRequest): CreateDataSourceFromRedshiftResponse {
        val op = SdkHttpOperation.build<CreateDataSourceFromRedshiftRequest, CreateDataSourceFromRedshiftResponse> {
            serializer = CreateDataSourceFromRedshiftOperationSerializer()
            deserializer = CreateDataSourceFromRedshiftOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateDataSourceFromRedshift"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateDataSourceFromRedshift-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a `DataSource` object. A `DataSource` references data that can be used to perform `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
     *
     * `CreateDataSourceFromS3` is an asynchronous operation. In response to `CreateDataSourceFromS3`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `DataSource` status to `PENDING`. After the `DataSource` has been created and is ready for use, Amazon ML sets the `Status` parameter to `COMPLETED`. `DataSource` in the `COMPLETED` or `PENDING` state can be used to perform only `CreateMLModel`, `CreateEvaluation` or `CreateBatchPrediction` operations.
     *
     *  If Amazon ML can't accept the input source, it sets the `Status` parameter to `FAILED` and includes an error message in the `Message` attribute of the `GetDataSource` operation response.
     *
     * The observation data used in a `DataSource` should be ready to use; that is, it should have a consistent structure, and missing data values should be kept to a minimum. The observation data must reside in one or more .csv files in an Amazon Simple Storage Service (Amazon S3) location, along with a schema that describes the data items by name and type. The same schema must be used for all of the data files referenced by the `DataSource`.
     *
     * After the `DataSource` has been created, it's ready to use in evaluations and batch predictions. If you plan to use the `DataSource` to train an `MLModel`, the `DataSource` also needs a recipe. A recipe describes how each input variable will be used in training an `MLModel`. Will the variable be included or excluded from training? Will the variable be manipulated; for example, will it be combined with another variable or will it be split apart into word combinations? The recipe provides answers to these questions.
     */
    override suspend fun createDataSourceFromS3(input: CreateDataSourceFromS3Request): CreateDataSourceFromS3Response {
        val op = SdkHttpOperation.build<CreateDataSourceFromS3Request, CreateDataSourceFromS3Response> {
            serializer = CreateDataSourceFromS3OperationSerializer()
            deserializer = CreateDataSourceFromS3OperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateDataSourceFromS3"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateDataSourceFromS3-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new `Evaluation` of an `MLModel`. An `MLModel` is evaluated on a set of observations associated to a `DataSource`. Like a `DataSource` for an `MLModel`, the `DataSource` for an `Evaluation` contains values for the `Target Variable`. The `Evaluation` compares the predicted result for each observation to the actual outcome and provides a summary so that you know how effective the `MLModel` functions on the test data. Evaluation generates a relevant performance metric, such as BinaryAUC, RegressionRMSE or MulticlassAvgFScore based on the corresponding `MLModelType`: `BINARY`, `REGRESSION` or `MULTICLASS`.
     *
     * `CreateEvaluation` is an asynchronous operation. In response to `CreateEvaluation`, Amazon Machine Learning (Amazon ML) immediately returns and sets the evaluation status to `PENDING`. After the `Evaluation` is created and ready for use, Amazon ML sets the status to `COMPLETED`.
     *
     * You can use the `GetEvaluation` operation to check progress of the evaluation during the creation operation.
     */
    override suspend fun createEvaluation(input: CreateEvaluationRequest): CreateEvaluationResponse {
        val op = SdkHttpOperation.build<CreateEvaluationRequest, CreateEvaluationResponse> {
            serializer = CreateEvaluationOperationSerializer()
            deserializer = CreateEvaluationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateEvaluation"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateEvaluation-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new `MLModel` using the `DataSource` and the recipe as information sources.
     *
     * An `MLModel` is nearly immutable. Users can update only the `MLModelName` and the `ScoreThreshold` in an `MLModel` without creating a new `MLModel`.
     *
     * `CreateMLModel` is an asynchronous operation. In response to `CreateMLModel`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `MLModel` status to `PENDING`. After the `MLModel` has been created and ready is for use, Amazon ML sets the status to `COMPLETED`.
     *
     * You can use the `GetMLModel` operation to check the progress of the `MLModel` during the creation operation.
     *
     * `CreateMLModel` requires a `DataSource` with computed statistics, which can be created by setting `ComputeStatistics` to `true` in `CreateDataSourceFromRDS`, `CreateDataSourceFromS3`, or `CreateDataSourceFromRedshift` operations.
     */
    override suspend fun createMlModel(input: CreateMlModelRequest): CreateMlModelResponse {
        val op = SdkHttpOperation.build<CreateMlModelRequest, CreateMlModelResponse> {
            serializer = CreateMLModelOperationSerializer()
            deserializer = CreateMLModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateMLModel"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateMLModel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a real-time endpoint for the `MLModel`. The endpoint contains the URI of the `MLModel`; that is, the location to send real-time prediction requests for the specified `MLModel`.
     */
    override suspend fun createRealtimeEndpoint(input: CreateRealtimeEndpointRequest): CreateRealtimeEndpointResponse {
        val op = SdkHttpOperation.build<CreateRealtimeEndpointRequest, CreateRealtimeEndpointResponse> {
            serializer = CreateRealtimeEndpointOperationSerializer()
            deserializer = CreateRealtimeEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateRealtimeEndpoint"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateRealtimeEndpoint-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Assigns the DELETED status to a `BatchPrediction`, rendering it unusable.
     *
     * After using the `DeleteBatchPrediction` operation, you can use the GetBatchPrediction operation to verify that the status of the `BatchPrediction` changed to DELETED.
     *
     * **Caution:** The result of the `DeleteBatchPrediction` operation is irreversible.
     */
    override suspend fun deleteBatchPrediction(input: DeleteBatchPredictionRequest): DeleteBatchPredictionResponse {
        val op = SdkHttpOperation.build<DeleteBatchPredictionRequest, DeleteBatchPredictionResponse> {
            serializer = DeleteBatchPredictionOperationSerializer()
            deserializer = DeleteBatchPredictionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteBatchPrediction"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteBatchPrediction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Assigns the DELETED status to a `DataSource`, rendering it unusable.
     *
     * After using the `DeleteDataSource` operation, you can use the GetDataSource operation to verify that the status of the `DataSource` changed to DELETED.
     *
     * **Caution:** The results of the `DeleteDataSource` operation are irreversible.
     */
    override suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse {
        val op = SdkHttpOperation.build<DeleteDataSourceRequest, DeleteDataSourceResponse> {
            serializer = DeleteDataSourceOperationSerializer()
            deserializer = DeleteDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteDataSource"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteDataSource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Assigns the `DELETED` status to an `Evaluation`, rendering it unusable.
     *
     * After invoking the `DeleteEvaluation` operation, you can use the `GetEvaluation` operation to verify that the status of the `Evaluation` changed to `DELETED`.
     *
     * **Caution:** The results of the `DeleteEvaluation` operation are irreversible.
     */
    override suspend fun deleteEvaluation(input: DeleteEvaluationRequest): DeleteEvaluationResponse {
        val op = SdkHttpOperation.build<DeleteEvaluationRequest, DeleteEvaluationResponse> {
            serializer = DeleteEvaluationOperationSerializer()
            deserializer = DeleteEvaluationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteEvaluation"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteEvaluation-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Assigns the `DELETED` status to an `MLModel`, rendering it unusable.
     *
     * After using the `DeleteMLModel` operation, you can use the `GetMLModel` operation to verify that the status of the `MLModel` changed to DELETED.
     *
     * **Caution:** The result of the `DeleteMLModel` operation is irreversible.
     */
    override suspend fun deleteMlModel(input: DeleteMlModelRequest): DeleteMlModelResponse {
        val op = SdkHttpOperation.build<DeleteMlModelRequest, DeleteMlModelResponse> {
            serializer = DeleteMLModelOperationSerializer()
            deserializer = DeleteMLModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteMLModel"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteMLModel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a real time endpoint of an `MLModel`.
     */
    override suspend fun deleteRealtimeEndpoint(input: DeleteRealtimeEndpointRequest): DeleteRealtimeEndpointResponse {
        val op = SdkHttpOperation.build<DeleteRealtimeEndpointRequest, DeleteRealtimeEndpointResponse> {
            serializer = DeleteRealtimeEndpointOperationSerializer()
            deserializer = DeleteRealtimeEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteRealtimeEndpoint"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteRealtimeEndpoint-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified tags associated with an ML object. After this operation is complete, you can't recover deleted tags.
     *
     * If you specify a tag that doesn't exist, Amazon ML ignores it.
     */
    override suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse {
        val op = SdkHttpOperation.build<DeleteTagsRequest, DeleteTagsResponse> {
            serializer = DeleteTagsOperationSerializer()
            deserializer = DeleteTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteTags"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteTags-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of `BatchPrediction` operations that match the search criteria in the request.
     */
    override suspend fun describeBatchPredictions(input: DescribeBatchPredictionsRequest): DescribeBatchPredictionsResponse {
        val op = SdkHttpOperation.build<DescribeBatchPredictionsRequest, DescribeBatchPredictionsResponse> {
            serializer = DescribeBatchPredictionsOperationSerializer()
            deserializer = DescribeBatchPredictionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeBatchPredictions"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeBatchPredictions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of `DataSource` that match the search criteria in the request.
     */
    override suspend fun describeDataSources(input: DescribeDataSourcesRequest): DescribeDataSourcesResponse {
        val op = SdkHttpOperation.build<DescribeDataSourcesRequest, DescribeDataSourcesResponse> {
            serializer = DescribeDataSourcesOperationSerializer()
            deserializer = DescribeDataSourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeDataSources"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeDataSources-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of `DescribeEvaluations` that match the search criteria in the request.
     */
    override suspend fun describeEvaluations(input: DescribeEvaluationsRequest): DescribeEvaluationsResponse {
        val op = SdkHttpOperation.build<DescribeEvaluationsRequest, DescribeEvaluationsResponse> {
            serializer = DescribeEvaluationsOperationSerializer()
            deserializer = DescribeEvaluationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeEvaluations"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeEvaluations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of `MLModel` that match the search criteria in the request.
     */
    override suspend fun describeMlModels(input: DescribeMlModelsRequest): DescribeMlModelsResponse {
        val op = SdkHttpOperation.build<DescribeMlModelsRequest, DescribeMlModelsResponse> {
            serializer = DescribeMLModelsOperationSerializer()
            deserializer = DescribeMLModelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeMLModels"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeMLModels-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes one or more of the tags for your Amazon ML object.
     */
    override suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse {
        val op = SdkHttpOperation.build<DescribeTagsRequest, DescribeTagsResponse> {
            serializer = DescribeTagsOperationSerializer()
            deserializer = DescribeTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeTags"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeTags-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a `BatchPrediction` that includes detailed metadata, status, and data file information for a `Batch Prediction` request.
     */
    override suspend fun getBatchPrediction(input: GetBatchPredictionRequest): GetBatchPredictionResponse {
        val op = SdkHttpOperation.build<GetBatchPredictionRequest, GetBatchPredictionResponse> {
            serializer = GetBatchPredictionOperationSerializer()
            deserializer = GetBatchPredictionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetBatchPrediction"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetBatchPrediction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a `DataSource` that includes metadata and data file information, as well as the current status of the `DataSource`.
     *
     * `GetDataSource` provides results in normal or verbose format. The verbose format adds the schema description and the list of files pointed to by the DataSource to the normal format.
     */
    override suspend fun getDataSource(input: GetDataSourceRequest): GetDataSourceResponse {
        val op = SdkHttpOperation.build<GetDataSourceRequest, GetDataSourceResponse> {
            serializer = GetDataSourceOperationSerializer()
            deserializer = GetDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetDataSource"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetDataSource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns an `Evaluation` that includes metadata as well as the current status of the `Evaluation`.
     */
    override suspend fun getEvaluation(input: GetEvaluationRequest): GetEvaluationResponse {
        val op = SdkHttpOperation.build<GetEvaluationRequest, GetEvaluationResponse> {
            serializer = GetEvaluationOperationSerializer()
            deserializer = GetEvaluationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetEvaluation"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetEvaluation-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns an `MLModel` that includes detailed metadata, data source information, and the current status of the `MLModel`.
     *
     * `GetMLModel` provides results in normal or verbose format.
     */
    override suspend fun getMlModel(input: GetMlModelRequest): GetMlModelResponse {
        val op = SdkHttpOperation.build<GetMlModelRequest, GetMlModelResponse> {
            serializer = GetMLModelOperationSerializer()
            deserializer = GetMLModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetMLModel"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetMLModel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Generates a prediction for the observation using the specified `ML Model`.
     *
     * **Note:** Not all response parameters will be populated. Whether a response parameter is populated depends on the type of model requested.
     */
    override suspend fun predict(input: PredictRequest): PredictResponse {
        val op = SdkHttpOperation.build<PredictRequest, PredictResponse> {
            serializer = PredictOperationSerializer()
            deserializer = PredictOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "Predict"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(ResolvePredictEndpoint())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("Predict-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the `BatchPredictionName` of a `BatchPrediction`.
     *
     * You can use the `GetBatchPrediction` operation to view the contents of the updated data element.
     */
    override suspend fun updateBatchPrediction(input: UpdateBatchPredictionRequest): UpdateBatchPredictionResponse {
        val op = SdkHttpOperation.build<UpdateBatchPredictionRequest, UpdateBatchPredictionResponse> {
            serializer = UpdateBatchPredictionOperationSerializer()
            deserializer = UpdateBatchPredictionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateBatchPrediction"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateBatchPrediction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the `DataSourceName` of a `DataSource`.
     *
     * You can use the `GetDataSource` operation to view the contents of the updated data element.
     */
    override suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse {
        val op = SdkHttpOperation.build<UpdateDataSourceRequest, UpdateDataSourceResponse> {
            serializer = UpdateDataSourceOperationSerializer()
            deserializer = UpdateDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateDataSource"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateDataSource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the `EvaluationName` of an `Evaluation`.
     *
     * You can use the `GetEvaluation` operation to view the contents of the updated data element.
     */
    override suspend fun updateEvaluation(input: UpdateEvaluationRequest): UpdateEvaluationResponse {
        val op = SdkHttpOperation.build<UpdateEvaluationRequest, UpdateEvaluationResponse> {
            serializer = UpdateEvaluationOperationSerializer()
            deserializer = UpdateEvaluationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateEvaluation"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateEvaluation-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the `MLModelName` and the `ScoreThreshold` of an `MLModel`.
     *
     * You can use the `GetMLModel` operation to view the contents of the updated data element.
     */
    override suspend fun updateMlModel(input: UpdateMlModelRequest): UpdateMlModelResponse {
        val op = SdkHttpOperation.build<UpdateMlModelRequest, UpdateMlModelResponse> {
            serializer = UpdateMLModelOperationSerializer()
            deserializer = UpdateMLModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateMLModel"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("AmazonML_20141212", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateMLModel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "machinelearning")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
