// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the output of a `GetBatchPrediction` operation and describes a `BatchPrediction`.
 */
public class GetBatchPredictionResponse private constructor(builder: Builder) {
    /**
     * The ID of the `DataSource` that was used to create the `BatchPrediction`.
     */
    public val batchPredictionDataSourceId: kotlin.String? = builder.batchPredictionDataSourceId
    /**
     * An ID assigned to the `BatchPrediction` at creation. This value should be identical to the value of the `BatchPredictionID` in the request.
     */
    public val batchPredictionId: kotlin.String? = builder.batchPredictionId
    /**
     * The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the `BatchPrediction`, normalized and scaled on computation resources. `ComputeTime` is only available if the `BatchPrediction` is in the `COMPLETED` state.
     */
    public val computeTime: kotlin.Long? = builder.computeTime
    /**
     * The time when the `BatchPrediction` was created. The time is expressed in epoch time.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The AWS user account that invoked the `BatchPrediction`. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.
     */
    public val createdByIamUser: kotlin.String? = builder.createdByIamUser
    /**
     * The epoch time when Amazon Machine Learning marked the `BatchPrediction` as `COMPLETED` or `FAILED`. `FinishedAt` is only available when the `BatchPrediction` is in the `COMPLETED` or `FAILED` state.
     */
    public val finishedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.finishedAt
    /**
     * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     */
    public val inputDataLocationS3: kotlin.String? = builder.inputDataLocationS3
    /**
     * The number of invalid records that Amazon Machine Learning saw while processing the `BatchPrediction`.
     */
    public val invalidRecordCount: kotlin.Long? = builder.invalidRecordCount
    /**
     * The time of the most recent edit to `BatchPrediction`. The time is expressed in epoch time.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * A link to the file that contains logs of the `CreateBatchPrediction` operation.
     */
    public val logUri: kotlin.String? = builder.logUri
    /**
     * A description of the most recent details about processing the batch prediction request.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The ID of the `MLModel` that generated predictions for the `BatchPrediction` request.
     */
    public val mlModelId: kotlin.String? = builder.mlModelId
    /**
     * A user-supplied name or description of the `BatchPrediction`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The location of an Amazon S3 bucket or directory to receive the operation results.
     */
    public val outputUri: kotlin.String? = builder.outputUri
    /**
     * The epoch time when Amazon Machine Learning marked the `BatchPrediction` as `INPROGRESS`. `StartedAt` isn't available if the `BatchPrediction` is in the `PENDING` state.
     */
    public val startedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.startedAt
    /**
     * The status of the `BatchPrediction`, which can be one of the following values:
     * + `PENDING` - Amazon Machine Learning (Amazon ML) submitted a request to generate batch predictions.
     * + `INPROGRESS` - The batch predictions are in progress.
     * + `FAILED` - The request to perform a batch prediction did not run to completion. It is not usable.
     * + `COMPLETED` - The batch prediction process completed successfully.
     * + `DELETED` - The `BatchPrediction` is marked as deleted. It is not usable.
     */
    public val status: aws.sdk.kotlin.services.machinelearning.model.EntityStatus? = builder.status
    /**
     * The number of total records that Amazon Machine Learning saw while processing the `BatchPrediction`.
     */
    public val totalRecordCount: kotlin.Long? = builder.totalRecordCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.GetBatchPredictionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetBatchPredictionResponse(")
        append("batchPredictionDataSourceId=$batchPredictionDataSourceId,")
        append("batchPredictionId=$batchPredictionId,")
        append("computeTime=$computeTime,")
        append("createdAt=$createdAt,")
        append("createdByIamUser=$createdByIamUser,")
        append("finishedAt=$finishedAt,")
        append("inputDataLocationS3=$inputDataLocationS3,")
        append("invalidRecordCount=$invalidRecordCount,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("logUri=$logUri,")
        append("message=$message,")
        append("mlModelId=$mlModelId,")
        append("name=$name,")
        append("outputUri=$outputUri,")
        append("startedAt=$startedAt,")
        append("status=$status,")
        append("totalRecordCount=$totalRecordCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchPredictionDataSourceId?.hashCode() ?: 0
        result = 31 * result + (batchPredictionId?.hashCode() ?: 0)
        result = 31 * result + (computeTime?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdByIamUser?.hashCode() ?: 0)
        result = 31 * result + (finishedAt?.hashCode() ?: 0)
        result = 31 * result + (inputDataLocationS3?.hashCode() ?: 0)
        result = 31 * result + (invalidRecordCount?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (logUri?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (mlModelId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputUri?.hashCode() ?: 0)
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (totalRecordCount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetBatchPredictionResponse

        if (batchPredictionDataSourceId != other.batchPredictionDataSourceId) return false
        if (batchPredictionId != other.batchPredictionId) return false
        if (computeTime != other.computeTime) return false
        if (createdAt != other.createdAt) return false
        if (createdByIamUser != other.createdByIamUser) return false
        if (finishedAt != other.finishedAt) return false
        if (inputDataLocationS3 != other.inputDataLocationS3) return false
        if (invalidRecordCount != other.invalidRecordCount) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (logUri != other.logUri) return false
        if (message != other.message) return false
        if (mlModelId != other.mlModelId) return false
        if (name != other.name) return false
        if (outputUri != other.outputUri) return false
        if (startedAt != other.startedAt) return false
        if (status != other.status) return false
        if (totalRecordCount != other.totalRecordCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.GetBatchPredictionResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the `DataSource` that was used to create the `BatchPrediction`.
         */
        public var batchPredictionDataSourceId: kotlin.String? = null
        /**
         * An ID assigned to the `BatchPrediction` at creation. This value should be identical to the value of the `BatchPredictionID` in the request.
         */
        public var batchPredictionId: kotlin.String? = null
        /**
         * The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the `BatchPrediction`, normalized and scaled on computation resources. `ComputeTime` is only available if the `BatchPrediction` is in the `COMPLETED` state.
         */
        public var computeTime: kotlin.Long? = null
        /**
         * The time when the `BatchPrediction` was created. The time is expressed in epoch time.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The AWS user account that invoked the `BatchPrediction`. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.
         */
        public var createdByIamUser: kotlin.String? = null
        /**
         * The epoch time when Amazon Machine Learning marked the `BatchPrediction` as `COMPLETED` or `FAILED`. `FinishedAt` is only available when the `BatchPrediction` is in the `COMPLETED` or `FAILED` state.
         */
        public var finishedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         */
        public var inputDataLocationS3: kotlin.String? = null
        /**
         * The number of invalid records that Amazon Machine Learning saw while processing the `BatchPrediction`.
         */
        public var invalidRecordCount: kotlin.Long? = null
        /**
         * The time of the most recent edit to `BatchPrediction`. The time is expressed in epoch time.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A link to the file that contains logs of the `CreateBatchPrediction` operation.
         */
        public var logUri: kotlin.String? = null
        /**
         * A description of the most recent details about processing the batch prediction request.
         */
        public var message: kotlin.String? = null
        /**
         * The ID of the `MLModel` that generated predictions for the `BatchPrediction` request.
         */
        public var mlModelId: kotlin.String? = null
        /**
         * A user-supplied name or description of the `BatchPrediction`.
         */
        public var name: kotlin.String? = null
        /**
         * The location of an Amazon S3 bucket or directory to receive the operation results.
         */
        public var outputUri: kotlin.String? = null
        /**
         * The epoch time when Amazon Machine Learning marked the `BatchPrediction` as `INPROGRESS`. `StartedAt` isn't available if the `BatchPrediction` is in the `PENDING` state.
         */
        public var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the `BatchPrediction`, which can be one of the following values:
         * + `PENDING` - Amazon Machine Learning (Amazon ML) submitted a request to generate batch predictions.
         * + `INPROGRESS` - The batch predictions are in progress.
         * + `FAILED` - The request to perform a batch prediction did not run to completion. It is not usable.
         * + `COMPLETED` - The batch prediction process completed successfully.
         * + `DELETED` - The `BatchPrediction` is marked as deleted. It is not usable.
         */
        public var status: aws.sdk.kotlin.services.machinelearning.model.EntityStatus? = null
        /**
         * The number of total records that Amazon Machine Learning saw while processing the `BatchPrediction`.
         */
        public var totalRecordCount: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.GetBatchPredictionResponse) : this() {
            this.batchPredictionDataSourceId = x.batchPredictionDataSourceId
            this.batchPredictionId = x.batchPredictionId
            this.computeTime = x.computeTime
            this.createdAt = x.createdAt
            this.createdByIamUser = x.createdByIamUser
            this.finishedAt = x.finishedAt
            this.inputDataLocationS3 = x.inputDataLocationS3
            this.invalidRecordCount = x.invalidRecordCount
            this.lastUpdatedAt = x.lastUpdatedAt
            this.logUri = x.logUri
            this.message = x.message
            this.mlModelId = x.mlModelId
            this.name = x.name
            this.outputUri = x.outputUri
            this.startedAt = x.startedAt
            this.status = x.status
            this.totalRecordCount = x.totalRecordCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.GetBatchPredictionResponse = GetBatchPredictionResponse(this)
    }
}
