// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.waiters

import aws.sdk.kotlin.services.machinelearning.MachineLearningClient
import aws.sdk.kotlin.services.machinelearning.model.DescribeBatchPredictionsRequest
import aws.sdk.kotlin.services.machinelearning.model.DescribeBatchPredictionsResponse
import aws.sdk.kotlin.services.machinelearning.model.DescribeDataSourcesRequest
import aws.sdk.kotlin.services.machinelearning.model.DescribeDataSourcesResponse
import aws.sdk.kotlin.services.machinelearning.model.DescribeEvaluationsRequest
import aws.sdk.kotlin.services.machinelearning.model.DescribeEvaluationsResponse
import aws.sdk.kotlin.services.machinelearning.model.DescribeMlModelsRequest
import aws.sdk.kotlin.services.machinelearning.model.DescribeMlModelsResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds


public suspend fun MachineLearningClient.waitUntilBatchPredictionAvailable(request: DescribeBatchPredictionsRequest): Outcome<DescribeBatchPredictionsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeBatchPredictionsRequest, DescribeBatchPredictionsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val results = it?.results
            val resultsOrEmpty = results?.flattenIfPossible() ?: listOf()
            val projection = resultsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "COMPLETED" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val results = it?.results
            val resultsOrEmpty = results?.flattenIfPossible() ?: listOf()
            val projection = resultsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "FAILED" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeBatchPredictions(request) }
}

public suspend fun MachineLearningClient.waitUntilBatchPredictionAvailable(block: DescribeBatchPredictionsRequest.Builder.() -> Unit): Outcome<DescribeBatchPredictionsResponse> =
    waitUntilBatchPredictionAvailable(DescribeBatchPredictionsRequest.Builder().apply(block).build())

public suspend fun MachineLearningClient.waitUntilDataSourceAvailable(request: DescribeDataSourcesRequest): Outcome<DescribeDataSourcesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeDataSourcesRequest, DescribeDataSourcesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val results = it?.results
            val resultsOrEmpty = results?.flattenIfPossible() ?: listOf()
            val projection = resultsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "COMPLETED" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val results = it?.results
            val resultsOrEmpty = results?.flattenIfPossible() ?: listOf()
            val projection = resultsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "FAILED" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDataSources(request) }
}

public suspend fun MachineLearningClient.waitUntilDataSourceAvailable(block: DescribeDataSourcesRequest.Builder.() -> Unit): Outcome<DescribeDataSourcesResponse> =
    waitUntilDataSourceAvailable(DescribeDataSourcesRequest.Builder().apply(block).build())

public suspend fun MachineLearningClient.waitUntilEvaluationAvailable(request: DescribeEvaluationsRequest): Outcome<DescribeEvaluationsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeEvaluationsRequest, DescribeEvaluationsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val results = it?.results
            val resultsOrEmpty = results?.flattenIfPossible() ?: listOf()
            val projection = resultsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "COMPLETED" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val results = it?.results
            val resultsOrEmpty = results?.flattenIfPossible() ?: listOf()
            val projection = resultsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "FAILED" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeEvaluations(request) }
}

public suspend fun MachineLearningClient.waitUntilEvaluationAvailable(block: DescribeEvaluationsRequest.Builder.() -> Unit): Outcome<DescribeEvaluationsResponse> =
    waitUntilEvaluationAvailable(DescribeEvaluationsRequest.Builder().apply(block).build())

public suspend fun MachineLearningClient.waitUntilMLModelAvailable(request: DescribeMlModelsRequest): Outcome<DescribeMlModelsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeMlModelsRequest, DescribeMlModelsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val results = it?.results
            val resultsOrEmpty = results?.flattenIfPossible() ?: listOf()
            val projection = resultsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "COMPLETED" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val results = it?.results
            val resultsOrEmpty = results?.flattenIfPossible() ?: listOf()
            val projection = resultsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "FAILED" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeMlModels(request) }
}

public suspend fun MachineLearningClient.waitUntilMLModelAvailable(block: DescribeMlModelsRequest.Builder.() -> Unit): Outcome<DescribeMlModelsResponse> =
    waitUntilMLModelAvailable(DescribeMlModelsRequest.Builder().apply(block).build())
