// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.machinelearning.model.CreateRealtimeEndpointResponse
import aws.sdk.kotlin.services.machinelearning.model.MachineLearningException
import aws.sdk.kotlin.services.machinelearning.model.RealtimeEndpointInfo
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateRealtimeEndpointOperationDeserializer: HttpDeserialize<CreateRealtimeEndpointResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateRealtimeEndpointResponse {
        if (!response.status.isSuccess()) {
            throwCreateRealtimeEndpointError(context, response)
        }
        val builder = CreateRealtimeEndpointResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateRealtimeEndpointOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateRealtimeEndpointError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MachineLearningException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MachineLearningException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateRealtimeEndpointOperationBody(builder: CreateRealtimeEndpointResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MLMODELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MLModelId"))
    val REALTIMEENDPOINTINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RealtimeEndpointInfo"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MLMODELID_DESCRIPTOR)
        field(REALTIMEENDPOINTINFO_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MLMODELID_DESCRIPTOR.index -> builder.mlModelId = deserializeString()
                REALTIMEENDPOINTINFO_DESCRIPTOR.index -> builder.realtimeEndpointInfo = deserializeRealtimeEndpointInfoDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
