// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model



/**
 * The datasource details that are specific to Amazon RDS.
 */
class RdsMetadata private constructor(builder: Builder) {
    /**
     * The ID of the Data Pipeline instance that is used to carry to copy data from Amazon RDS to Amazon S3. You can use the ID to find details about the instance in the Data Pipeline console.
     */
    val dataPipelineId: kotlin.String? = builder.dataPipelineId
    /**
     * The database details required to connect to an Amazon RDS.
     */
    val database: aws.sdk.kotlin.services.machinelearning.model.RdsDatabase? = builder.database
    /**
     * The username to be used by Amazon ML to connect to database on an Amazon RDS instance. The username should have sufficient permissions to execute an `RDSSelectSqlQuery` query.
     */
    val databaseUserName: kotlin.String? = builder.databaseUserName
    /**
     * The role (DataPipelineDefaultResourceRole) assumed by an Amazon EC2 instance to carry out the copy task from Amazon RDS to Amazon S3. For more information, see [Role templates](https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html) for data pipelines.
     */
    val resourceRole: kotlin.String? = builder.resourceRole
    /**
     * The SQL query that is supplied during CreateDataSourceFromRDS. Returns only if `Verbose` is true in `GetDataSourceInput`.
     */
    val selectSqlQuery: kotlin.String? = builder.selectSqlQuery
    /**
     * The role (DataPipelineDefaultRole) assumed by the Data Pipeline service to monitor the progress of the copy task from Amazon RDS to Amazon S3. For more information, see [Role templates](https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html) for data pipelines.
     */
    val serviceRole: kotlin.String? = builder.serviceRole

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.RdsMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RdsMetadata(")
        append("dataPipelineId=$dataPipelineId,")
        append("database=$database,")
        append("databaseUserName=$databaseUserName,")
        append("resourceRole=$resourceRole,")
        append("selectSqlQuery=$selectSqlQuery,")
        append("serviceRole=$serviceRole)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataPipelineId?.hashCode() ?: 0
        result = 31 * result + (database?.hashCode() ?: 0)
        result = 31 * result + (databaseUserName?.hashCode() ?: 0)
        result = 31 * result + (resourceRole?.hashCode() ?: 0)
        result = 31 * result + (selectSqlQuery?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RdsMetadata

        if (dataPipelineId != other.dataPipelineId) return false
        if (database != other.database) return false
        if (databaseUserName != other.databaseUserName) return false
        if (resourceRole != other.resourceRole) return false
        if (selectSqlQuery != other.selectSqlQuery) return false
        if (serviceRole != other.serviceRole) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.RdsMetadata = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the Data Pipeline instance that is used to carry to copy data from Amazon RDS to Amazon S3. You can use the ID to find details about the instance in the Data Pipeline console.
         */
        var dataPipelineId: kotlin.String? = null
        /**
         * The database details required to connect to an Amazon RDS.
         */
        var database: aws.sdk.kotlin.services.machinelearning.model.RdsDatabase? = null
        /**
         * The username to be used by Amazon ML to connect to database on an Amazon RDS instance. The username should have sufficient permissions to execute an `RDSSelectSqlQuery` query.
         */
        var databaseUserName: kotlin.String? = null
        /**
         * The role (DataPipelineDefaultResourceRole) assumed by an Amazon EC2 instance to carry out the copy task from Amazon RDS to Amazon S3. For more information, see [Role templates](https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html) for data pipelines.
         */
        var resourceRole: kotlin.String? = null
        /**
         * The SQL query that is supplied during CreateDataSourceFromRDS. Returns only if `Verbose` is true in `GetDataSourceInput`.
         */
        var selectSqlQuery: kotlin.String? = null
        /**
         * The role (DataPipelineDefaultRole) assumed by the Data Pipeline service to monitor the progress of the copy task from Amazon RDS to Amazon S3. For more information, see [Role templates](https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html) for data pipelines.
         */
        var serviceRole: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.RdsMetadata) : this() {
            this.dataPipelineId = x.dataPipelineId
            this.database = x.database
            this.databaseUserName = x.databaseUserName
            this.resourceRole = x.resourceRole
            this.selectSqlQuery = x.selectSqlQuery
            this.serviceRole = x.serviceRole
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.RdsMetadata = RdsMetadata(this)

        /**
         * construct an [aws.sdk.kotlin.services.machinelearning.model.RdsDatabase] inside the given [block]
         */
        fun database(block: aws.sdk.kotlin.services.machinelearning.model.RdsDatabase.Builder.() -> kotlin.Unit) {
            this.database = aws.sdk.kotlin.services.machinelearning.model.RdsDatabase.invoke(block)
        }
    }
}
