// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model



/**
 * The data specification of an Amazon Relational Database Service (Amazon RDS) `DataSource`.
 */
class RdsDataSpec private constructor(builder: Builder) {
    /**
     * A JSON string that represents the splitting and rearrangement processing to be applied to a `DataSource`. If the `DataRearrangement` parameter is not provided, all of the input data is used to create the `Datasource`.
     *
     * There are multiple parameters that control what data is used to create a datasource:
     * + **`percentBegin`**Use `percentBegin` to indicate the beginning of the range of the data used to create the Datasource. If you do not include `percentBegin` and `percentEnd`, Amazon ML includes all of the data when creating the datasource.
     * + **`percentEnd`**Use `percentEnd` to indicate the end of the range of the data used to create the Datasource. If you do not include `percentBegin` and `percentEnd`, Amazon ML includes all of the data when creating the datasource.
     * + **`complement`**The `complement` parameter instructs Amazon ML to use the data that is not included in the range of `percentBegin` to `percentEnd` to create a datasource. The `complement` parameter is useful if you need to create complementary datasources for training and evaluation. To create a complementary datasource, use the same values for `percentBegin` and `percentEnd`, along with the `complement` parameter.For example, the following two datasources do not share any data, and can be used to train and evaluate a model. The first datasource has 25 percent of the data, and the second one has 75 percent of the data.Datasource for evaluation: `{"splitting":{"percentBegin":0, "percentEnd":25}}`Datasource for training: `{"splitting":{"percentBegin":0, "percentEnd":25, "complement":"true"}}`
     * + **`strategy`**To change how Amazon ML splits the data for a datasource, use the `strategy` parameter.The default value for the `strategy` parameter is `sequential`, meaning that Amazon ML takes all of the data records between the `percentBegin` and `percentEnd` parameters for the datasource, in the order that the records appear in the input data.The following two `DataRearrangement` lines are examples of sequentially ordered training and evaluation datasources:Datasource for evaluation: `{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"sequential"}}`Datasource for training: `{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"sequential", "complement":"true"}}`To randomly split the input data into the proportions indicated by the percentBegin and percentEnd parameters, set the `strategy` parameter to `random` and provide a string that is used as the seed value for the random data splitting (for example, you can use the S3 path to your data as the random seed string). If you choose the random split strategy, Amazon ML assigns each row of data a pseudo-random number between 0 and 100, and then selects the rows that have an assigned number between `percentBegin` and `percentEnd`. Pseudo-random numbers are assigned using both the input seed string value and the byte offset as a seed, so changing the data results in a different split. Any existing ordering is preserved. The random splitting strategy ensures that variables in the training and evaluation data are distributed similarly. It is useful in the cases where the input data may have an implicit sort order, which would otherwise result in training and evaluation datasources containing non-similar data records.The following two `DataRearrangement` lines are examples of non-sequentially ordered training and evaluation datasources:Datasource for evaluation: `{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv"}}`Datasource for training: `{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv", "complement":"true"}}`
     */
    val dataRearrangement: kotlin.String? = builder.dataRearrangement
    /**
     * A JSON string that represents the schema for an Amazon RDS `DataSource`. The `DataSchema` defines the structure of the observation data in the data file(s) referenced in the `DataSource`.
     *
     * A `DataSchema` is not required if you specify a `DataSchemaUri`
     *
     * Define your `DataSchema` as a series of key-value pairs. `attributes` and `excludedVariableNames` have an array of key-value pairs for their value. Use the following format to define your `DataSchema`.
     *
     * { "version": "1.0",
     *
     * "recordAnnotationFieldName": "F1",
     *
     * "recordWeightFieldName": "F2",
     *
     * "targetFieldName": "F3",
     *
     * "dataFormat": "CSV",
     *
     * "dataFileContainsHeader": true,
     *
     * "attributes": &#91;
     *
     * { "fieldName": "F1", "fieldType": "TEXT" }, { "fieldName": "F2", "fieldType": "NUMERIC" }, { "fieldName": "F3", "fieldType": "CATEGORICAL" }, { "fieldName": "F4", "fieldType": "NUMERIC" }, { "fieldName": "F5", "fieldType": "CATEGORICAL" }, { "fieldName": "F6", "fieldType": "TEXT" }, { "fieldName": "F7", "fieldType": "WEIGHTED_INT_SEQUENCE" }, { "fieldName": "F8", "fieldType": "WEIGHTED_STRING_SEQUENCE" } &#93;,
     *
     * "excludedVariableNames": &#91; "F6" &#93; }
     */
    val dataSchema: kotlin.String? = builder.dataSchema
    /**
     * The Amazon S3 location of the `DataSchema`.
     */
    val dataSchemaUri: kotlin.String? = builder.dataSchemaUri
    /**
     * The AWS Identity and Access Management (IAM) credentials that are used connect to the Amazon RDS database.
     */
    val databaseCredentials: aws.sdk.kotlin.services.machinelearning.model.RdsDatabaseCredentials? = builder.databaseCredentials
    /**
     * Describes the `DatabaseName` and `InstanceIdentifier` of an Amazon RDS database.
     */
    val databaseInformation: aws.sdk.kotlin.services.machinelearning.model.RdsDatabase? = builder.databaseInformation
    /**
     * The role (DataPipelineDefaultResourceRole) assumed by an Amazon Elastic Compute Cloud (Amazon EC2) instance to carry out the copy operation from Amazon RDS to an Amazon S3 task. For more information, see [Role templates](https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html) for data pipelines.
     */
    val resourceRole: kotlin.String? = builder.resourceRole
    /**
     * The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon RDS using `SelectSqlQuery` is stored in this location.
     */
    val s3StagingLocation: kotlin.String? = builder.s3StagingLocation
    /**
     * The security group IDs to be used to access a VPC-based RDS DB instance. Ensure that there are appropriate ingress rules set up to allow access to the RDS DB instance. This attribute is used by Data Pipeline to carry out the copy operation from Amazon RDS to an Amazon S3 task.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The query that is used to retrieve the observation data for the `DataSource`.
     */
    val selectSqlQuery: kotlin.String? = builder.selectSqlQuery
    /**
     * The role (DataPipelineDefaultRole) assumed by AWS Data Pipeline service to monitor the progress of the copy task from Amazon RDS to Amazon S3. For more information, see [Role templates](https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html) for data pipelines.
     */
    val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * The subnet ID to be used to access a VPC-based RDS DB instance. This attribute is used by Data Pipeline to carry out the copy task from Amazon RDS to Amazon S3.
     */
    val subnetId: kotlin.String? = builder.subnetId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.RdsDataSpec = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RdsDataSpec(")
        append("dataRearrangement=$dataRearrangement,")
        append("dataSchema=$dataSchema,")
        append("dataSchemaUri=$dataSchemaUri,")
        append("databaseCredentials=$databaseCredentials,")
        append("databaseInformation=$databaseInformation,")
        append("resourceRole=$resourceRole,")
        append("s3StagingLocation=$s3StagingLocation,")
        append("securityGroupIds=$securityGroupIds,")
        append("selectSqlQuery=$selectSqlQuery,")
        append("serviceRole=$serviceRole,")
        append("subnetId=$subnetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataRearrangement?.hashCode() ?: 0
        result = 31 * result + (dataSchema?.hashCode() ?: 0)
        result = 31 * result + (dataSchemaUri?.hashCode() ?: 0)
        result = 31 * result + (databaseCredentials?.hashCode() ?: 0)
        result = 31 * result + (databaseInformation?.hashCode() ?: 0)
        result = 31 * result + (resourceRole?.hashCode() ?: 0)
        result = 31 * result + (s3StagingLocation?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (selectSqlQuery?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RdsDataSpec

        if (dataRearrangement != other.dataRearrangement) return false
        if (dataSchema != other.dataSchema) return false
        if (dataSchemaUri != other.dataSchemaUri) return false
        if (databaseCredentials != other.databaseCredentials) return false
        if (databaseInformation != other.databaseInformation) return false
        if (resourceRole != other.resourceRole) return false
        if (s3StagingLocation != other.s3StagingLocation) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (selectSqlQuery != other.selectSqlQuery) return false
        if (serviceRole != other.serviceRole) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.RdsDataSpec = Builder(this).apply(block).build()

    class Builder {
        /**
         * A JSON string that represents the splitting and rearrangement processing to be applied to a `DataSource`. If the `DataRearrangement` parameter is not provided, all of the input data is used to create the `Datasource`.
         *
         * There are multiple parameters that control what data is used to create a datasource:
         * + **`percentBegin`**Use `percentBegin` to indicate the beginning of the range of the data used to create the Datasource. If you do not include `percentBegin` and `percentEnd`, Amazon ML includes all of the data when creating the datasource.
         * + **`percentEnd`**Use `percentEnd` to indicate the end of the range of the data used to create the Datasource. If you do not include `percentBegin` and `percentEnd`, Amazon ML includes all of the data when creating the datasource.
         * + **`complement`**The `complement` parameter instructs Amazon ML to use the data that is not included in the range of `percentBegin` to `percentEnd` to create a datasource. The `complement` parameter is useful if you need to create complementary datasources for training and evaluation. To create a complementary datasource, use the same values for `percentBegin` and `percentEnd`, along with the `complement` parameter.For example, the following two datasources do not share any data, and can be used to train and evaluate a model. The first datasource has 25 percent of the data, and the second one has 75 percent of the data.Datasource for evaluation: `{"splitting":{"percentBegin":0, "percentEnd":25}}`Datasource for training: `{"splitting":{"percentBegin":0, "percentEnd":25, "complement":"true"}}`
         * + **`strategy`**To change how Amazon ML splits the data for a datasource, use the `strategy` parameter.The default value for the `strategy` parameter is `sequential`, meaning that Amazon ML takes all of the data records between the `percentBegin` and `percentEnd` parameters for the datasource, in the order that the records appear in the input data.The following two `DataRearrangement` lines are examples of sequentially ordered training and evaluation datasources:Datasource for evaluation: `{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"sequential"}}`Datasource for training: `{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"sequential", "complement":"true"}}`To randomly split the input data into the proportions indicated by the percentBegin and percentEnd parameters, set the `strategy` parameter to `random` and provide a string that is used as the seed value for the random data splitting (for example, you can use the S3 path to your data as the random seed string). If you choose the random split strategy, Amazon ML assigns each row of data a pseudo-random number between 0 and 100, and then selects the rows that have an assigned number between `percentBegin` and `percentEnd`. Pseudo-random numbers are assigned using both the input seed string value and the byte offset as a seed, so changing the data results in a different split. Any existing ordering is preserved. The random splitting strategy ensures that variables in the training and evaluation data are distributed similarly. It is useful in the cases where the input data may have an implicit sort order, which would otherwise result in training and evaluation datasources containing non-similar data records.The following two `DataRearrangement` lines are examples of non-sequentially ordered training and evaluation datasources:Datasource for evaluation: `{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv"}}`Datasource for training: `{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv", "complement":"true"}}`
         */
        var dataRearrangement: kotlin.String? = null
        /**
         * A JSON string that represents the schema for an Amazon RDS `DataSource`. The `DataSchema` defines the structure of the observation data in the data file(s) referenced in the `DataSource`.
         *
         * A `DataSchema` is not required if you specify a `DataSchemaUri`
         *
         * Define your `DataSchema` as a series of key-value pairs. `attributes` and `excludedVariableNames` have an array of key-value pairs for their value. Use the following format to define your `DataSchema`.
         *
         * { "version": "1.0",
         *
         * "recordAnnotationFieldName": "F1",
         *
         * "recordWeightFieldName": "F2",
         *
         * "targetFieldName": "F3",
         *
         * "dataFormat": "CSV",
         *
         * "dataFileContainsHeader": true,
         *
         * "attributes": &#91;
         *
         * { "fieldName": "F1", "fieldType": "TEXT" }, { "fieldName": "F2", "fieldType": "NUMERIC" }, { "fieldName": "F3", "fieldType": "CATEGORICAL" }, { "fieldName": "F4", "fieldType": "NUMERIC" }, { "fieldName": "F5", "fieldType": "CATEGORICAL" }, { "fieldName": "F6", "fieldType": "TEXT" }, { "fieldName": "F7", "fieldType": "WEIGHTED_INT_SEQUENCE" }, { "fieldName": "F8", "fieldType": "WEIGHTED_STRING_SEQUENCE" } &#93;,
         *
         * "excludedVariableNames": &#91; "F6" &#93; }
         */
        var dataSchema: kotlin.String? = null
        /**
         * The Amazon S3 location of the `DataSchema`.
         */
        var dataSchemaUri: kotlin.String? = null
        /**
         * The AWS Identity and Access Management (IAM) credentials that are used connect to the Amazon RDS database.
         */
        var databaseCredentials: aws.sdk.kotlin.services.machinelearning.model.RdsDatabaseCredentials? = null
        /**
         * Describes the `DatabaseName` and `InstanceIdentifier` of an Amazon RDS database.
         */
        var databaseInformation: aws.sdk.kotlin.services.machinelearning.model.RdsDatabase? = null
        /**
         * The role (DataPipelineDefaultResourceRole) assumed by an Amazon Elastic Compute Cloud (Amazon EC2) instance to carry out the copy operation from Amazon RDS to an Amazon S3 task. For more information, see [Role templates](https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html) for data pipelines.
         */
        var resourceRole: kotlin.String? = null
        /**
         * The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon RDS using `SelectSqlQuery` is stored in this location.
         */
        var s3StagingLocation: kotlin.String? = null
        /**
         * The security group IDs to be used to access a VPC-based RDS DB instance. Ensure that there are appropriate ingress rules set up to allow access to the RDS DB instance. This attribute is used by Data Pipeline to carry out the copy operation from Amazon RDS to an Amazon S3 task.
         */
        var securityGroupIds: List<String>? = null
        /**
         * The query that is used to retrieve the observation data for the `DataSource`.
         */
        var selectSqlQuery: kotlin.String? = null
        /**
         * The role (DataPipelineDefaultRole) assumed by AWS Data Pipeline service to monitor the progress of the copy task from Amazon RDS to Amazon S3. For more information, see [Role templates](https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html) for data pipelines.
         */
        var serviceRole: kotlin.String? = null
        /**
         * The subnet ID to be used to access a VPC-based RDS DB instance. This attribute is used by Data Pipeline to carry out the copy task from Amazon RDS to Amazon S3.
         */
        var subnetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.RdsDataSpec) : this() {
            this.dataRearrangement = x.dataRearrangement
            this.dataSchema = x.dataSchema
            this.dataSchemaUri = x.dataSchemaUri
            this.databaseCredentials = x.databaseCredentials
            this.databaseInformation = x.databaseInformation
            this.resourceRole = x.resourceRole
            this.s3StagingLocation = x.s3StagingLocation
            this.securityGroupIds = x.securityGroupIds
            this.selectSqlQuery = x.selectSqlQuery
            this.serviceRole = x.serviceRole
            this.subnetId = x.subnetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.RdsDataSpec = RdsDataSpec(this)

        /**
         * construct an [aws.sdk.kotlin.services.machinelearning.model.RdsDatabaseCredentials] inside the given [block]
         */
        fun databaseCredentials(block: aws.sdk.kotlin.services.machinelearning.model.RdsDatabaseCredentials.Builder.() -> kotlin.Unit) {
            this.databaseCredentials = aws.sdk.kotlin.services.machinelearning.model.RdsDatabaseCredentials.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.machinelearning.model.RdsDatabase] inside the given [block]
         */
        fun databaseInformation(block: aws.sdk.kotlin.services.machinelearning.model.RdsDatabase.Builder.() -> kotlin.Unit) {
            this.databaseInformation = aws.sdk.kotlin.services.machinelearning.model.RdsDatabase.invoke(block)
        }
    }
}
