// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model



/**
 * Measurements of how well the `MLModel` performed on known observations. One of the following metrics is returned, based on the type of the `MLModel`:
 * + BinaryAUC: The binary `MLModel` uses the Area Under the Curve (AUC) technique to measure performance.
 * + RegressionRMSE: The regression `MLModel` uses the Root Mean Square Error (RMSE) technique to measure performance. RMSE measures the difference between predicted and actual values for a single variable.
 * + MulticlassAvgFScore: The multiclass `MLModel` uses the F1 score technique to measure performance.
 *
 *  For more information about performance metrics, please see the [Amazon Machine Learning Developer Guide](https://docs.aws.amazon.com/machine-learning/latest/dg).
 */
class PerformanceMetrics private constructor(builder: Builder) {
    val properties: Map<String, String>? = builder.properties

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.PerformanceMetrics = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PerformanceMetrics(")
        append("properties=$properties)")
    }

    override fun hashCode(): kotlin.Int {
        var result = properties?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PerformanceMetrics

        if (properties != other.properties) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.PerformanceMetrics = Builder(this).apply(block).build()

    class Builder {
        var properties: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.PerformanceMetrics) : this() {
            this.properties = x.properties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.PerformanceMetrics = PerformanceMetrics(this)
    }
}
