// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the output of a `GetMLModel` operation.
 *
 * The content consists of the detailed metadata and the current status of the `MLModel`.
 */
class MlModel private constructor(builder: Builder) {
    /**
     * The algorithm used to train the `MLModel`. The following algorithm is supported:
     * + `SGD` -- Stochastic gradient descent. The goal of `SGD` is to minimize the gradient of the loss function.
     */
    val algorithm: aws.sdk.kotlin.services.machinelearning.model.Algorithm? = builder.algorithm
    /**
     * Long integer type that is a 64-bit signed number.
     */
    val computeTime: kotlin.Long? = builder.computeTime
    /**
     * The time that the `MLModel` was created. The time is expressed in epoch time.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The AWS user account from which the `MLModel` was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.
     */
    val createdByIamUser: kotlin.String? = builder.createdByIamUser
    /**
     * The current endpoint of the `MLModel`.
     */
    val endpointInfo: aws.sdk.kotlin.services.machinelearning.model.RealtimeEndpointInfo? = builder.endpointInfo
    /**
     * A timestamp represented in epoch time.
     */
    val finishedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.finishedAt
    /**
     * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     */
    val inputDataLocationS3: kotlin.String? = builder.inputDataLocationS3
    /**
     * The time of the most recent edit to the `MLModel`. The time is expressed in epoch time.
     */
    val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * A description of the most recent details about accessing the `MLModel`.
     */
    val message: kotlin.String? = builder.message
    /**
     * The ID assigned to the `MLModel` at creation.
     */
    val mlModelId: kotlin.String? = builder.mlModelId
    /**
     * Identifies the `MLModel` category. The following are the available types:
     * + `REGRESSION` - Produces a numeric result. For example, "What price should a house be listed at?"
     * + `BINARY` - Produces one of two possible results. For example, "Is this a child-friendly web site?".
     * + `MULTICLASS` - Produces one of several possible results. For example, "Is this a HIGH-, LOW-, or MEDIUM-risk trade?".
     */
    val mlModelType: aws.sdk.kotlin.services.machinelearning.model.MlModelType? = builder.mlModelType
    /**
     * A user-supplied name or description of the `MLModel`.
     */
    val name: kotlin.String? = builder.name
    val scoreThreshold: kotlin.Float? = builder.scoreThreshold
    /**
     * The time of the most recent edit to the `ScoreThreshold`. The time is expressed in epoch time.
     */
    val scoreThresholdLastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.scoreThresholdLastUpdatedAt
    /**
     * Long integer type that is a 64-bit signed number.
     */
    val sizeInBytes: kotlin.Long? = builder.sizeInBytes
    /**
     * A timestamp represented in epoch time.
     */
    val startedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.startedAt
    /**
     * The current status of an `MLModel`. This element can have one of the following values:
     * + `PENDING` - Amazon Machine Learning (Amazon ML) submitted a request to create an `MLModel`.
     * + `INPROGRESS` - The creation process is underway.
     * + `FAILED` - The request to create an `MLModel` didn't run to completion. The model isn't usable.
     * + `COMPLETED` - The creation process completed successfully.
     * + `DELETED` - The `MLModel` is marked as deleted. It isn't usable.
     */
    val status: aws.sdk.kotlin.services.machinelearning.model.EntityStatus? = builder.status
    /**
     * The ID of the training `DataSource`. The `CreateMLModel` operation uses the `TrainingDataSourceId`.
     */
    val trainingDataSourceId: kotlin.String? = builder.trainingDataSourceId
    /**
     * A list of the training parameters in the `MLModel`. The list is implemented as a map of key-value pairs.
     *
     * The following is the current set of training parameters:
     * + `sgd.maxMLModelSizeInBytes` - The maximum allowed size of the model. Depending on the input data, the size of the model might affect its performance. The value is an integer that ranges from `100000` to `2147483648`. The default value is `33554432`.
     * + `sgd.maxPasses` - The number of times that the training process traverses the observations to build the `MLModel`. The value is an integer that ranges from `1` to `10000`. The default value is `10`.
     * + `sgd.shuffleType` - Whether Amazon ML shuffles the training data. Shuffling the data improves a model's ability to find the optimal solution for a variety of data types. The valid values are `auto` and `none`. The default value is `none`.
     * + `sgd.l1RegularizationAmount` - The coefficient regularization L1 norm, which controls overfitting the data by penalizing large coefficients. This parameter tends to drive coefficients to zero, resulting in sparse feature set. If you use this parameter, start by specifying a small value, such as `1.0E-08`.The value is a double that ranges from `0` to `MAX_DOUBLE`. The default is to not use L1 normalization. This parameter can't be used when `L2` is specified. Use this parameter sparingly.
     * + `sgd.l2RegularizationAmount` - The coefficient regularization L2 norm, which controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use this parameter, start by specifying a small value, such as `1.0E-08`.The value is a double that ranges from `0` to `MAX_DOUBLE`. The default is to not use L2 normalization. This parameter can't be used when `L1` is specified. Use this parameter sparingly.
     */
    val trainingParameters: Map<String, String>? = builder.trainingParameters

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.MlModel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MlModel(")
        append("algorithm=$algorithm,")
        append("computeTime=$computeTime,")
        append("createdAt=$createdAt,")
        append("createdByIamUser=$createdByIamUser,")
        append("endpointInfo=$endpointInfo,")
        append("finishedAt=$finishedAt,")
        append("inputDataLocationS3=$inputDataLocationS3,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("message=$message,")
        append("mlModelId=$mlModelId,")
        append("mlModelType=$mlModelType,")
        append("name=$name,")
        append("scoreThreshold=$scoreThreshold,")
        append("scoreThresholdLastUpdatedAt=$scoreThresholdLastUpdatedAt,")
        append("sizeInBytes=$sizeInBytes,")
        append("startedAt=$startedAt,")
        append("status=$status,")
        append("trainingDataSourceId=$trainingDataSourceId,")
        append("trainingParameters=$trainingParameters)")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithm?.hashCode() ?: 0
        result = 31 * result + (computeTime?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdByIamUser?.hashCode() ?: 0)
        result = 31 * result + (endpointInfo?.hashCode() ?: 0)
        result = 31 * result + (finishedAt?.hashCode() ?: 0)
        result = 31 * result + (inputDataLocationS3?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (mlModelId?.hashCode() ?: 0)
        result = 31 * result + (mlModelType?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (scoreThreshold?.hashCode() ?: 0)
        result = 31 * result + (scoreThresholdLastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (sizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (trainingDataSourceId?.hashCode() ?: 0)
        result = 31 * result + (trainingParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MlModel

        if (algorithm != other.algorithm) return false
        if (computeTime != other.computeTime) return false
        if (createdAt != other.createdAt) return false
        if (createdByIamUser != other.createdByIamUser) return false
        if (endpointInfo != other.endpointInfo) return false
        if (finishedAt != other.finishedAt) return false
        if (inputDataLocationS3 != other.inputDataLocationS3) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (message != other.message) return false
        if (mlModelId != other.mlModelId) return false
        if (mlModelType != other.mlModelType) return false
        if (name != other.name) return false
        if (scoreThreshold != other.scoreThreshold) return false
        if (scoreThresholdLastUpdatedAt != other.scoreThresholdLastUpdatedAt) return false
        if (sizeInBytes != other.sizeInBytes) return false
        if (startedAt != other.startedAt) return false
        if (status != other.status) return false
        if (trainingDataSourceId != other.trainingDataSourceId) return false
        if (trainingParameters != other.trainingParameters) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.MlModel = Builder(this).apply(block).build()

    class Builder {
        /**
         * The algorithm used to train the `MLModel`. The following algorithm is supported:
         * + `SGD` -- Stochastic gradient descent. The goal of `SGD` is to minimize the gradient of the loss function.
         */
        var algorithm: aws.sdk.kotlin.services.machinelearning.model.Algorithm? = null
        /**
         * Long integer type that is a 64-bit signed number.
         */
        var computeTime: kotlin.Long? = null
        /**
         * The time that the `MLModel` was created. The time is expressed in epoch time.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The AWS user account from which the `MLModel` was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.
         */
        var createdByIamUser: kotlin.String? = null
        /**
         * The current endpoint of the `MLModel`.
         */
        var endpointInfo: aws.sdk.kotlin.services.machinelearning.model.RealtimeEndpointInfo? = null
        /**
         * A timestamp represented in epoch time.
         */
        var finishedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         */
        var inputDataLocationS3: kotlin.String? = null
        /**
         * The time of the most recent edit to the `MLModel`. The time is expressed in epoch time.
         */
        var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description of the most recent details about accessing the `MLModel`.
         */
        var message: kotlin.String? = null
        /**
         * The ID assigned to the `MLModel` at creation.
         */
        var mlModelId: kotlin.String? = null
        /**
         * Identifies the `MLModel` category. The following are the available types:
         * + `REGRESSION` - Produces a numeric result. For example, "What price should a house be listed at?"
         * + `BINARY` - Produces one of two possible results. For example, "Is this a child-friendly web site?".
         * + `MULTICLASS` - Produces one of several possible results. For example, "Is this a HIGH-, LOW-, or MEDIUM-risk trade?".
         */
        var mlModelType: aws.sdk.kotlin.services.machinelearning.model.MlModelType? = null
        /**
         * A user-supplied name or description of the `MLModel`.
         */
        var name: kotlin.String? = null
        var scoreThreshold: kotlin.Float? = null
        /**
         * The time of the most recent edit to the `ScoreThreshold`. The time is expressed in epoch time.
         */
        var scoreThresholdLastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Long integer type that is a 64-bit signed number.
         */
        var sizeInBytes: kotlin.Long? = null
        /**
         * A timestamp represented in epoch time.
         */
        var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of an `MLModel`. This element can have one of the following values:
         * + `PENDING` - Amazon Machine Learning (Amazon ML) submitted a request to create an `MLModel`.
         * + `INPROGRESS` - The creation process is underway.
         * + `FAILED` - The request to create an `MLModel` didn't run to completion. The model isn't usable.
         * + `COMPLETED` - The creation process completed successfully.
         * + `DELETED` - The `MLModel` is marked as deleted. It isn't usable.
         */
        var status: aws.sdk.kotlin.services.machinelearning.model.EntityStatus? = null
        /**
         * The ID of the training `DataSource`. The `CreateMLModel` operation uses the `TrainingDataSourceId`.
         */
        var trainingDataSourceId: kotlin.String? = null
        /**
         * A list of the training parameters in the `MLModel`. The list is implemented as a map of key-value pairs.
         *
         * The following is the current set of training parameters:
         * + `sgd.maxMLModelSizeInBytes` - The maximum allowed size of the model. Depending on the input data, the size of the model might affect its performance. The value is an integer that ranges from `100000` to `2147483648`. The default value is `33554432`.
         * + `sgd.maxPasses` - The number of times that the training process traverses the observations to build the `MLModel`. The value is an integer that ranges from `1` to `10000`. The default value is `10`.
         * + `sgd.shuffleType` - Whether Amazon ML shuffles the training data. Shuffling the data improves a model's ability to find the optimal solution for a variety of data types. The valid values are `auto` and `none`. The default value is `none`.
         * + `sgd.l1RegularizationAmount` - The coefficient regularization L1 norm, which controls overfitting the data by penalizing large coefficients. This parameter tends to drive coefficients to zero, resulting in sparse feature set. If you use this parameter, start by specifying a small value, such as `1.0E-08`.The value is a double that ranges from `0` to `MAX_DOUBLE`. The default is to not use L1 normalization. This parameter can't be used when `L2` is specified. Use this parameter sparingly.
         * + `sgd.l2RegularizationAmount` - The coefficient regularization L2 norm, which controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use this parameter, start by specifying a small value, such as `1.0E-08`.The value is a double that ranges from `0` to `MAX_DOUBLE`. The default is to not use L2 normalization. This parameter can't be used when `L1` is specified. Use this parameter sparingly.
         */
        var trainingParameters: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.MlModel) : this() {
            this.algorithm = x.algorithm
            this.computeTime = x.computeTime
            this.createdAt = x.createdAt
            this.createdByIamUser = x.createdByIamUser
            this.endpointInfo = x.endpointInfo
            this.finishedAt = x.finishedAt
            this.inputDataLocationS3 = x.inputDataLocationS3
            this.lastUpdatedAt = x.lastUpdatedAt
            this.message = x.message
            this.mlModelId = x.mlModelId
            this.mlModelType = x.mlModelType
            this.name = x.name
            this.scoreThreshold = x.scoreThreshold
            this.scoreThresholdLastUpdatedAt = x.scoreThresholdLastUpdatedAt
            this.sizeInBytes = x.sizeInBytes
            this.startedAt = x.startedAt
            this.status = x.status
            this.trainingDataSourceId = x.trainingDataSourceId
            this.trainingParameters = x.trainingParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.MlModel = MlModel(this)

        /**
         * construct an [aws.sdk.kotlin.services.machinelearning.model.RealtimeEndpointInfo] inside the given [block]
         */
        fun endpointInfo(block: aws.sdk.kotlin.services.machinelearning.model.RealtimeEndpointInfo.Builder.() -> kotlin.Unit) {
            this.endpointInfo = aws.sdk.kotlin.services.machinelearning.model.RealtimeEndpointInfo.invoke(block)
        }
    }
}
