// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model



class DescribeDataSourcesRequest private constructor(builder: Builder) {
    /**
     * The equal to operator. The `DataSource` results will have `FilterVariable` values that exactly match the value specified with `EQ`.
     */
    val eq: kotlin.String? = builder.eq
    /**
     * Use one of the following variables to filter a list of `DataSource`:
     * + `CreatedAt` - Sets the search criteria to `DataSource` creation dates.
     * + `Status` - Sets the search criteria to `DataSource` statuses.
     * + `Name` - Sets the search criteria to the contents of `DataSource``Name`.
     * + `DataUri` - Sets the search criteria to the URI of data files used to create the `DataSource`. The URI can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.
     * + `IAMUser` - Sets the search criteria to the user account that invoked the `DataSource` creation.
     */
    val filterVariable: aws.sdk.kotlin.services.machinelearning.model.DataSourceFilterVariable? = builder.filterVariable
    /**
     * The greater than or equal to operator. The `DataSource` results will have `FilterVariable` values that are greater than or equal to the value specified with `GE`.
     */
    val ge: kotlin.String? = builder.ge
    /**
     * The greater than operator. The `DataSource` results will have `FilterVariable` values that are greater than the value specified with `GT`.
     */
    val gt: kotlin.String? = builder.gt
    /**
     * The less than or equal to operator. The `DataSource` results will have `FilterVariable` values that are less than or equal to the value specified with `LE`.
     */
    val le: kotlin.String? = builder.le
    /**
     * The maximum number of `DataSource` to include in the result.
     */
    val limit: kotlin.Int? = builder.limit
    /**
     * The less than operator. The `DataSource` results will have `FilterVariable` values that are less than the value specified with `LT`.
     */
    val lt: kotlin.String? = builder.lt
    /**
     * The not equal to operator. The `DataSource` results will have `FilterVariable` values not equal to the value specified with `NE`.
     */
    val ne: kotlin.String? = builder.ne
    /**
     * The ID of the page in the paginated results.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * A string that is found at the beginning of a variable, such as `Name` or `Id`.
     *
     * For example, a `DataSource` could have the `Name``2014-09-09-HolidayGiftMailer`. To search for this `DataSource`, select `Name` for the `FilterVariable` and any of the following strings for the `Prefix`:
     * + 2014-09
     * + 2014-09-09
     * + 2014-09-09-Holiday
     */
    val prefix: kotlin.String? = builder.prefix
    /**
     * A two-value parameter that determines the sequence of the resulting list of `DataSource`.
     * + `asc` - Arranges the list in ascending order (A-Z, 0-9).
     * + `dsc` - Arranges the list in descending order (Z-A, 9-0).
     *
     * Results are sorted by `FilterVariable`.
     */
    val sortOrder: aws.sdk.kotlin.services.machinelearning.model.SortOrder? = builder.sortOrder

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.DescribeDataSourcesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDataSourcesRequest(")
        append("eq=$eq,")
        append("filterVariable=$filterVariable,")
        append("ge=$ge,")
        append("gt=$gt,")
        append("le=$le,")
        append("limit=$limit,")
        append("lt=$lt,")
        append("ne=$ne,")
        append("nextToken=$nextToken,")
        append("prefix=$prefix,")
        append("sortOrder=$sortOrder)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eq?.hashCode() ?: 0
        result = 31 * result + (filterVariable?.hashCode() ?: 0)
        result = 31 * result + (ge?.hashCode() ?: 0)
        result = 31 * result + (gt?.hashCode() ?: 0)
        result = 31 * result + (le?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (lt?.hashCode() ?: 0)
        result = 31 * result + (ne?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDataSourcesRequest

        if (eq != other.eq) return false
        if (filterVariable != other.filterVariable) return false
        if (ge != other.ge) return false
        if (gt != other.gt) return false
        if (le != other.le) return false
        if (limit != other.limit) return false
        if (lt != other.lt) return false
        if (ne != other.ne) return false
        if (nextToken != other.nextToken) return false
        if (prefix != other.prefix) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.DescribeDataSourcesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The equal to operator. The `DataSource` results will have `FilterVariable` values that exactly match the value specified with `EQ`.
         */
        var eq: kotlin.String? = null
        /**
         * Use one of the following variables to filter a list of `DataSource`:
         * + `CreatedAt` - Sets the search criteria to `DataSource` creation dates.
         * + `Status` - Sets the search criteria to `DataSource` statuses.
         * + `Name` - Sets the search criteria to the contents of `DataSource``Name`.
         * + `DataUri` - Sets the search criteria to the URI of data files used to create the `DataSource`. The URI can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.
         * + `IAMUser` - Sets the search criteria to the user account that invoked the `DataSource` creation.
         */
        var filterVariable: aws.sdk.kotlin.services.machinelearning.model.DataSourceFilterVariable? = null
        /**
         * The greater than or equal to operator. The `DataSource` results will have `FilterVariable` values that are greater than or equal to the value specified with `GE`.
         */
        var ge: kotlin.String? = null
        /**
         * The greater than operator. The `DataSource` results will have `FilterVariable` values that are greater than the value specified with `GT`.
         */
        var gt: kotlin.String? = null
        /**
         * The less than or equal to operator. The `DataSource` results will have `FilterVariable` values that are less than or equal to the value specified with `LE`.
         */
        var le: kotlin.String? = null
        /**
         * The maximum number of `DataSource` to include in the result.
         */
        var limit: kotlin.Int? = null
        /**
         * The less than operator. The `DataSource` results will have `FilterVariable` values that are less than the value specified with `LT`.
         */
        var lt: kotlin.String? = null
        /**
         * The not equal to operator. The `DataSource` results will have `FilterVariable` values not equal to the value specified with `NE`.
         */
        var ne: kotlin.String? = null
        /**
         * The ID of the page in the paginated results.
         */
        var nextToken: kotlin.String? = null
        /**
         * A string that is found at the beginning of a variable, such as `Name` or `Id`.
         *
         * For example, a `DataSource` could have the `Name``2014-09-09-HolidayGiftMailer`. To search for this `DataSource`, select `Name` for the `FilterVariable` and any of the following strings for the `Prefix`:
         * + 2014-09
         * + 2014-09-09
         * + 2014-09-09-Holiday
         */
        var prefix: kotlin.String? = null
        /**
         * A two-value parameter that determines the sequence of the resulting list of `DataSource`.
         * + `asc` - Arranges the list in ascending order (A-Z, 0-9).
         * + `dsc` - Arranges the list in descending order (Z-A, 9-0).
         *
         * Results are sorted by `FilterVariable`.
         */
        var sortOrder: aws.sdk.kotlin.services.machinelearning.model.SortOrder? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.DescribeDataSourcesRequest) : this() {
            this.eq = x.eq
            this.filterVariable = x.filterVariable
            this.ge = x.ge
            this.gt = x.gt
            this.le = x.le
            this.limit = x.limit
            this.lt = x.lt
            this.ne = x.ne
            this.nextToken = x.nextToken
            this.prefix = x.prefix
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.DescribeDataSourcesRequest = DescribeDataSourcesRequest(this)
    }
}
