// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the output of a `GetBatchPrediction` operation.
 *
 *  The content consists of the detailed metadata, the status, and the data file information of a `Batch Prediction`.
 */
class BatchPrediction private constructor(builder: Builder) {
    /**
     * The ID of the `DataSource` that points to the group of observations to predict.
     */
    val batchPredictionDataSourceId: kotlin.String? = builder.batchPredictionDataSourceId
    /**
     * The ID assigned to the `BatchPrediction` at creation. This value should be identical to the value of the `BatchPredictionID` in the request.
     */
    val batchPredictionId: kotlin.String? = builder.batchPredictionId
    /**
     * Long integer type that is a 64-bit signed number.
     */
    val computeTime: kotlin.Long? = builder.computeTime
    /**
     * The time that the `BatchPrediction` was created. The time is expressed in epoch time.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The AWS user account that invoked the `BatchPrediction`. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.
     */
    val createdByIamUser: kotlin.String? = builder.createdByIamUser
    /**
     * A timestamp represented in epoch time.
     */
    val finishedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.finishedAt
    /**
     * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     */
    val inputDataLocationS3: kotlin.String? = builder.inputDataLocationS3
    /**
     * Long integer type that is a 64-bit signed number.
     */
    val invalidRecordCount: kotlin.Long? = builder.invalidRecordCount
    /**
     * The time of the most recent edit to the `BatchPrediction`. The time is expressed in epoch time.
     */
    val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * A description of the most recent details about processing the batch prediction request.
     */
    val message: kotlin.String? = builder.message
    /**
     * The ID of the `MLModel` that generated predictions for the `BatchPrediction` request.
     */
    val mlModelId: kotlin.String? = builder.mlModelId
    /**
     * A user-supplied name or description of the `BatchPrediction`.
     */
    val name: kotlin.String? = builder.name
    /**
     * The location of an Amazon S3 bucket or directory to receive the operation results. The following substrings are not allowed in the `s3 key` portion of the `outputURI` field: ':', '//', '/./', '/../'.
     */
    val outputUri: kotlin.String? = builder.outputUri
    /**
     * A timestamp represented in epoch time.
     */
    val startedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.startedAt
    /**
     * The status of the `BatchPrediction`. This element can have one of the following values:
     * + `PENDING` - Amazon Machine Learning (Amazon ML) submitted a request to generate predictions for a batch of observations.
     * + `INPROGRESS` - The process is underway.
     * + `FAILED` - The request to perform a batch prediction did not run to completion. It is not usable.
     * + `COMPLETED` - The batch prediction process completed successfully.
     * + `DELETED` - The `BatchPrediction` is marked as deleted. It is not usable.
     */
    val status: aws.sdk.kotlin.services.machinelearning.model.EntityStatus? = builder.status
    /**
     * Long integer type that is a 64-bit signed number.
     */
    val totalRecordCount: kotlin.Long? = builder.totalRecordCount

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.BatchPrediction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchPrediction(")
        append("batchPredictionDataSourceId=$batchPredictionDataSourceId,")
        append("batchPredictionId=$batchPredictionId,")
        append("computeTime=$computeTime,")
        append("createdAt=$createdAt,")
        append("createdByIamUser=$createdByIamUser,")
        append("finishedAt=$finishedAt,")
        append("inputDataLocationS3=$inputDataLocationS3,")
        append("invalidRecordCount=$invalidRecordCount,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("message=$message,")
        append("mlModelId=$mlModelId,")
        append("name=$name,")
        append("outputUri=$outputUri,")
        append("startedAt=$startedAt,")
        append("status=$status,")
        append("totalRecordCount=$totalRecordCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchPredictionDataSourceId?.hashCode() ?: 0
        result = 31 * result + (batchPredictionId?.hashCode() ?: 0)
        result = 31 * result + (computeTime?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdByIamUser?.hashCode() ?: 0)
        result = 31 * result + (finishedAt?.hashCode() ?: 0)
        result = 31 * result + (inputDataLocationS3?.hashCode() ?: 0)
        result = 31 * result + (invalidRecordCount?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (mlModelId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputUri?.hashCode() ?: 0)
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (totalRecordCount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchPrediction

        if (batchPredictionDataSourceId != other.batchPredictionDataSourceId) return false
        if (batchPredictionId != other.batchPredictionId) return false
        if (computeTime != other.computeTime) return false
        if (createdAt != other.createdAt) return false
        if (createdByIamUser != other.createdByIamUser) return false
        if (finishedAt != other.finishedAt) return false
        if (inputDataLocationS3 != other.inputDataLocationS3) return false
        if (invalidRecordCount != other.invalidRecordCount) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (message != other.message) return false
        if (mlModelId != other.mlModelId) return false
        if (name != other.name) return false
        if (outputUri != other.outputUri) return false
        if (startedAt != other.startedAt) return false
        if (status != other.status) return false
        if (totalRecordCount != other.totalRecordCount) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.BatchPrediction = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the `DataSource` that points to the group of observations to predict.
         */
        var batchPredictionDataSourceId: kotlin.String? = null
        /**
         * The ID assigned to the `BatchPrediction` at creation. This value should be identical to the value of the `BatchPredictionID` in the request.
         */
        var batchPredictionId: kotlin.String? = null
        /**
         * Long integer type that is a 64-bit signed number.
         */
        var computeTime: kotlin.Long? = null
        /**
         * The time that the `BatchPrediction` was created. The time is expressed in epoch time.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The AWS user account that invoked the `BatchPrediction`. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.
         */
        var createdByIamUser: kotlin.String? = null
        /**
         * A timestamp represented in epoch time.
         */
        var finishedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         */
        var inputDataLocationS3: kotlin.String? = null
        /**
         * Long integer type that is a 64-bit signed number.
         */
        var invalidRecordCount: kotlin.Long? = null
        /**
         * The time of the most recent edit to the `BatchPrediction`. The time is expressed in epoch time.
         */
        var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description of the most recent details about processing the batch prediction request.
         */
        var message: kotlin.String? = null
        /**
         * The ID of the `MLModel` that generated predictions for the `BatchPrediction` request.
         */
        var mlModelId: kotlin.String? = null
        /**
         * A user-supplied name or description of the `BatchPrediction`.
         */
        var name: kotlin.String? = null
        /**
         * The location of an Amazon S3 bucket or directory to receive the operation results. The following substrings are not allowed in the `s3 key` portion of the `outputURI` field: ':', '//', '/./', '/../'.
         */
        var outputUri: kotlin.String? = null
        /**
         * A timestamp represented in epoch time.
         */
        var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the `BatchPrediction`. This element can have one of the following values:
         * + `PENDING` - Amazon Machine Learning (Amazon ML) submitted a request to generate predictions for a batch of observations.
         * + `INPROGRESS` - The process is underway.
         * + `FAILED` - The request to perform a batch prediction did not run to completion. It is not usable.
         * + `COMPLETED` - The batch prediction process completed successfully.
         * + `DELETED` - The `BatchPrediction` is marked as deleted. It is not usable.
         */
        var status: aws.sdk.kotlin.services.machinelearning.model.EntityStatus? = null
        /**
         * Long integer type that is a 64-bit signed number.
         */
        var totalRecordCount: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.BatchPrediction) : this() {
            this.batchPredictionDataSourceId = x.batchPredictionDataSourceId
            this.batchPredictionId = x.batchPredictionId
            this.computeTime = x.computeTime
            this.createdAt = x.createdAt
            this.createdByIamUser = x.createdByIamUser
            this.finishedAt = x.finishedAt
            this.inputDataLocationS3 = x.inputDataLocationS3
            this.invalidRecordCount = x.invalidRecordCount
            this.lastUpdatedAt = x.lastUpdatedAt
            this.message = x.message
            this.mlModelId = x.mlModelId
            this.name = x.name
            this.outputUri = x.outputUri
            this.startedAt = x.startedAt
            this.status = x.status
            this.totalRecordCount = x.totalRecordCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.BatchPrediction = BatchPrediction(this)
    }
}
