// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.machinelearning.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.machinelearning.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Definition of the public APIs exposed by Amazon Machine Learning
 */
interface MachineLearningClient : SdkClient {

    override val serviceName: String
        get() = "Machine Learning"
    /**
     * MachineLearningClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): MachineLearningClient {
            val config = Config.Builder().apply(block).build()
            return DefaultMachineLearningClient(config)
        }

        operator fun invoke(config: Config): MachineLearningClient = DefaultMachineLearningClient(config)

        /**
         * Construct a [MachineLearningClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): MachineLearningClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultMachineLearningClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds one or more tags to an object, up to a limit of 10. Each tag consists of a key and an optional value. If you add a tag using a key that is already associated with the ML object, `AddTags` updates the tag's value.
     */
    suspend fun addTags(input: AddTagsRequest): AddTagsResponse

    /**
     * Generates predictions for a group of observations. The observations to process exist in one or more data files referenced by a `DataSource`. This operation creates a new `BatchPrediction`, and uses an `MLModel` and the data files referenced by the `DataSource` as information sources.
     *
     * `CreateBatchPrediction` is an asynchronous operation. In response to `CreateBatchPrediction`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `BatchPrediction` status to `PENDING`. After the `BatchPrediction` completes, Amazon ML sets the status to `COMPLETED`.
     *
     * You can poll for status updates by using the GetBatchPrediction operation and checking the `Status` parameter of the result. After the `COMPLETED` status appears, the results are available in the location specified by the `OutputUri` parameter.
     */
    suspend fun createBatchPrediction(input: CreateBatchPredictionRequest): CreateBatchPredictionResponse

    /**
     * Creates a `DataSource` object from an [ Amazon Relational Database Service](http://aws.amazon.com/rds/) (Amazon RDS). A `DataSource` references data that can be used to perform `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
     *
     * `CreateDataSourceFromRDS` is an asynchronous operation. In response to `CreateDataSourceFromRDS`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `DataSource` status to `PENDING`. After the `DataSource` is created and ready for use, Amazon ML sets the `Status` parameter to `COMPLETED`. `DataSource` in the `COMPLETED` or `PENDING` state can be used only to perform `>CreateMLModel`>, `CreateEvaluation`, or `CreateBatchPrediction` operations.
     *
     *  If Amazon ML cannot accept the input source, it sets the `Status` parameter to `FAILED` and includes an error message in the `Message` attribute of the `GetDataSource` operation response.
     */
    suspend fun createDataSourceFromRds(input: CreateDataSourceFromRdsRequest): CreateDataSourceFromRdsResponse

    /**
     * Creates a `DataSource` from a database hosted on an Amazon Redshift cluster. A `DataSource` references data that can be used to perform either `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
     *
     * `CreateDataSourceFromRedshift` is an asynchronous operation. In response to `CreateDataSourceFromRedshift`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `DataSource` status to `PENDING`. After the `DataSource` is created and ready for use, Amazon ML sets the `Status` parameter to `COMPLETED`. `DataSource` in `COMPLETED` or `PENDING` states can be used to perform only `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
     *
     *  If Amazon ML can't accept the input source, it sets the `Status` parameter to `FAILED` and includes an error message in the `Message` attribute of the `GetDataSource` operation response.
     *
     * The observations should be contained in the database hosted on an Amazon Redshift cluster and should be specified by a `SelectSqlQuery` query. Amazon ML executes an `Unload` command in Amazon Redshift to transfer the result set of the `SelectSqlQuery` query to `S3StagingLocation`.
     *
     * After the `DataSource` has been created, it's ready for use in evaluations and batch predictions. If you plan to use the `DataSource` to train an `MLModel`, the `DataSource` also requires a recipe. A recipe describes how each input variable will be used in training an `MLModel`. Will the variable be included or excluded from training? Will the variable be manipulated; for example, will it be combined with another variable or will it be split apart into word combinations? The recipe provides answers to these questions.
     *
     * You can't change an existing datasource, but you can copy and modify the settings from an existing Amazon Redshift datasource to create a new datasource. To do so, call `GetDataSource` for an existing datasource and copy the values to a `CreateDataSource` call. Change the settings that you want to change and make sure that all required fields have the appropriate values.
     */
    suspend fun createDataSourceFromRedshift(input: CreateDataSourceFromRedshiftRequest): CreateDataSourceFromRedshiftResponse

    /**
     * Creates a `DataSource` object. A `DataSource` references data that can be used to perform `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
     *
     * `CreateDataSourceFromS3` is an asynchronous operation. In response to `CreateDataSourceFromS3`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `DataSource` status to `PENDING`. After the `DataSource` has been created and is ready for use, Amazon ML sets the `Status` parameter to `COMPLETED`. `DataSource` in the `COMPLETED` or `PENDING` state can be used to perform only `CreateMLModel`, `CreateEvaluation` or `CreateBatchPrediction` operations.
     *
     *  If Amazon ML can't accept the input source, it sets the `Status` parameter to `FAILED` and includes an error message in the `Message` attribute of the `GetDataSource` operation response.
     *
     * The observation data used in a `DataSource` should be ready to use; that is, it should have a consistent structure, and missing data values should be kept to a minimum. The observation data must reside in one or more .csv files in an Amazon Simple Storage Service (Amazon S3) location, along with a schema that describes the data items by name and type. The same schema must be used for all of the data files referenced by the `DataSource`.
     *
     * After the `DataSource` has been created, it's ready to use in evaluations and batch predictions. If you plan to use the `DataSource` to train an `MLModel`, the `DataSource` also needs a recipe. A recipe describes how each input variable will be used in training an `MLModel`. Will the variable be included or excluded from training? Will the variable be manipulated; for example, will it be combined with another variable or will it be split apart into word combinations? The recipe provides answers to these questions.
     */
    suspend fun createDataSourceFromS3(input: CreateDataSourceFromS3Request): CreateDataSourceFromS3Response

    /**
     * Creates a new `Evaluation` of an `MLModel`. An `MLModel` is evaluated on a set of observations associated to a `DataSource`. Like a `DataSource` for an `MLModel`, the `DataSource` for an `Evaluation` contains values for the `Target Variable`. The `Evaluation` compares the predicted result for each observation to the actual outcome and provides a summary so that you know how effective the `MLModel` functions on the test data. Evaluation generates a relevant performance metric, such as BinaryAUC, RegressionRMSE or MulticlassAvgFScore based on the corresponding `MLModelType`: `BINARY`, `REGRESSION` or `MULTICLASS`.
     *
     * `CreateEvaluation` is an asynchronous operation. In response to `CreateEvaluation`, Amazon Machine Learning (Amazon ML) immediately returns and sets the evaluation status to `PENDING`. After the `Evaluation` is created and ready for use, Amazon ML sets the status to `COMPLETED`.
     *
     * You can use the `GetEvaluation` operation to check progress of the evaluation during the creation operation.
     */
    suspend fun createEvaluation(input: CreateEvaluationRequest): CreateEvaluationResponse

    /**
     * Creates a new `MLModel` using the `DataSource` and the recipe as information sources.
     *
     * An `MLModel` is nearly immutable. Users can update only the `MLModelName` and the `ScoreThreshold` in an `MLModel` without creating a new `MLModel`.
     *
     * `CreateMLModel` is an asynchronous operation. In response to `CreateMLModel`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `MLModel` status to `PENDING`. After the `MLModel` has been created and ready is for use, Amazon ML sets the status to `COMPLETED`.
     *
     * You can use the `GetMLModel` operation to check the progress of the `MLModel` during the creation operation.
     *
     * `CreateMLModel` requires a `DataSource` with computed statistics, which can be created by setting `ComputeStatistics` to `true` in `CreateDataSourceFromRDS`, `CreateDataSourceFromS3`, or `CreateDataSourceFromRedshift` operations.
     */
    suspend fun createMlModel(input: CreateMlModelRequest): CreateMlModelResponse

    /**
     * Creates a real-time endpoint for the `MLModel`. The endpoint contains the URI of the `MLModel`; that is, the location to send real-time prediction requests for the specified `MLModel`.
     */
    suspend fun createRealtimeEndpoint(input: CreateRealtimeEndpointRequest): CreateRealtimeEndpointResponse

    /**
     * Assigns the DELETED status to a `BatchPrediction`, rendering it unusable.
     *
     * After using the `DeleteBatchPrediction` operation, you can use the GetBatchPrediction operation to verify that the status of the `BatchPrediction` changed to DELETED.
     *
     * **Caution:** The result of the `DeleteBatchPrediction` operation is irreversible.
     */
    suspend fun deleteBatchPrediction(input: DeleteBatchPredictionRequest): DeleteBatchPredictionResponse

    /**
     * Assigns the DELETED status to a `DataSource`, rendering it unusable.
     *
     * After using the `DeleteDataSource` operation, you can use the GetDataSource operation to verify that the status of the `DataSource` changed to DELETED.
     *
     * **Caution:** The results of the `DeleteDataSource` operation are irreversible.
     */
    suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse

    /**
     * Assigns the `DELETED` status to an `Evaluation`, rendering it unusable.
     *
     * After invoking the `DeleteEvaluation` operation, you can use the `GetEvaluation` operation to verify that the status of the `Evaluation` changed to `DELETED`.
     *
     * **Caution:** The results of the `DeleteEvaluation` operation are irreversible.
     */
    suspend fun deleteEvaluation(input: DeleteEvaluationRequest): DeleteEvaluationResponse

    /**
     * Assigns the `DELETED` status to an `MLModel`, rendering it unusable.
     *
     * After using the `DeleteMLModel` operation, you can use the `GetMLModel` operation to verify that the status of the `MLModel` changed to DELETED.
     *
     * **Caution:** The result of the `DeleteMLModel` operation is irreversible.
     */
    suspend fun deleteMlModel(input: DeleteMlModelRequest): DeleteMlModelResponse

    /**
     * Deletes a real time endpoint of an `MLModel`.
     */
    suspend fun deleteRealtimeEndpoint(input: DeleteRealtimeEndpointRequest): DeleteRealtimeEndpointResponse

    /**
     * Deletes the specified tags associated with an ML object. After this operation is complete, you can't recover deleted tags.
     *
     * If you specify a tag that doesn't exist, Amazon ML ignores it.
     */
    suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse

    /**
     * Returns a list of `BatchPrediction` operations that match the search criteria in the request.
     */
    suspend fun describeBatchPredictions(input: DescribeBatchPredictionsRequest = DescribeBatchPredictionsRequest {}): DescribeBatchPredictionsResponse

    /**
     * Returns a list of `DataSource` that match the search criteria in the request.
     */
    suspend fun describeDataSources(input: DescribeDataSourcesRequest = DescribeDataSourcesRequest {}): DescribeDataSourcesResponse

    /**
     * Returns a list of `DescribeEvaluations` that match the search criteria in the request.
     */
    suspend fun describeEvaluations(input: DescribeEvaluationsRequest = DescribeEvaluationsRequest {}): DescribeEvaluationsResponse

    /**
     * Returns a list of `MLModel` that match the search criteria in the request.
     */
    suspend fun describeMlModels(input: DescribeMlModelsRequest = DescribeMlModelsRequest {}): DescribeMlModelsResponse

    /**
     * Describes one or more of the tags for your Amazon ML object.
     */
    suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse

    /**
     * Returns a `BatchPrediction` that includes detailed metadata, status, and data file information for a `Batch Prediction` request.
     */
    suspend fun getBatchPrediction(input: GetBatchPredictionRequest): GetBatchPredictionResponse

    /**
     * Returns a `DataSource` that includes metadata and data file information, as well as the current status of the `DataSource`.
     *
     * `GetDataSource` provides results in normal or verbose format. The verbose format adds the schema description and the list of files pointed to by the DataSource to the normal format.
     */
    suspend fun getDataSource(input: GetDataSourceRequest): GetDataSourceResponse

    /**
     * Returns an `Evaluation` that includes metadata as well as the current status of the `Evaluation`.
     */
    suspend fun getEvaluation(input: GetEvaluationRequest): GetEvaluationResponse

    /**
     * Returns an `MLModel` that includes detailed metadata, data source information, and the current status of the `MLModel`.
     *
     * `GetMLModel` provides results in normal or verbose format.
     */
    suspend fun getMlModel(input: GetMlModelRequest): GetMlModelResponse

    /**
     * Generates a prediction for the observation using the specified `ML Model`.
     *
     * **Note:** Not all response parameters will be populated. Whether a response parameter is populated depends on the type of model requested.
     */
    suspend fun predict(input: PredictRequest): PredictResponse

    /**
     * Updates the `BatchPredictionName` of a `BatchPrediction`.
     *
     * You can use the `GetBatchPrediction` operation to view the contents of the updated data element.
     */
    suspend fun updateBatchPrediction(input: UpdateBatchPredictionRequest): UpdateBatchPredictionResponse

    /**
     * Updates the `DataSourceName` of a `DataSource`.
     *
     * You can use the `GetDataSource` operation to view the contents of the updated data element.
     */
    suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse

    /**
     * Updates the `EvaluationName` of an `Evaluation`.
     *
     * You can use the `GetEvaluation` operation to view the contents of the updated data element.
     */
    suspend fun updateEvaluation(input: UpdateEvaluationRequest): UpdateEvaluationResponse

    /**
     * Updates the `MLModelName` and the `ScoreThreshold` of an `MLModel`.
     *
     * You can use the `GetMLModel` operation to view the contents of the updated data element.
     */
    suspend fun updateMlModel(input: UpdateMlModelRequest): UpdateMlModelResponse
}

/**
 * Adds one or more tags to an object, up to a limit of 10. Each tag consists of a key and an optional value. If you add a tag using a key that is already associated with the ML object, `AddTags` updates the tag's value.
 */
suspend inline fun MachineLearningClient.addTags(crossinline block: AddTagsRequest.Builder.() -> Unit) = addTags(AddTagsRequest.Builder().apply(block).build())

/**
 * Generates predictions for a group of observations. The observations to process exist in one or more data files referenced by a `DataSource`. This operation creates a new `BatchPrediction`, and uses an `MLModel` and the data files referenced by the `DataSource` as information sources.
 *
 * `CreateBatchPrediction` is an asynchronous operation. In response to `CreateBatchPrediction`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `BatchPrediction` status to `PENDING`. After the `BatchPrediction` completes, Amazon ML sets the status to `COMPLETED`.
 *
 * You can poll for status updates by using the GetBatchPrediction operation and checking the `Status` parameter of the result. After the `COMPLETED` status appears, the results are available in the location specified by the `OutputUri` parameter.
 */
suspend inline fun MachineLearningClient.createBatchPrediction(crossinline block: CreateBatchPredictionRequest.Builder.() -> Unit) = createBatchPrediction(CreateBatchPredictionRequest.Builder().apply(block).build())

/**
 * Creates a `DataSource` object from an [ Amazon Relational Database Service](http://aws.amazon.com/rds/) (Amazon RDS). A `DataSource` references data that can be used to perform `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
 *
 * `CreateDataSourceFromRDS` is an asynchronous operation. In response to `CreateDataSourceFromRDS`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `DataSource` status to `PENDING`. After the `DataSource` is created and ready for use, Amazon ML sets the `Status` parameter to `COMPLETED`. `DataSource` in the `COMPLETED` or `PENDING` state can be used only to perform `>CreateMLModel`>, `CreateEvaluation`, or `CreateBatchPrediction` operations.
 *
 *  If Amazon ML cannot accept the input source, it sets the `Status` parameter to `FAILED` and includes an error message in the `Message` attribute of the `GetDataSource` operation response.
 */
suspend inline fun MachineLearningClient.createDataSourceFromRds(crossinline block: CreateDataSourceFromRdsRequest.Builder.() -> Unit) = createDataSourceFromRds(CreateDataSourceFromRdsRequest.Builder().apply(block).build())

/**
 * Creates a `DataSource` from a database hosted on an Amazon Redshift cluster. A `DataSource` references data that can be used to perform either `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
 *
 * `CreateDataSourceFromRedshift` is an asynchronous operation. In response to `CreateDataSourceFromRedshift`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `DataSource` status to `PENDING`. After the `DataSource` is created and ready for use, Amazon ML sets the `Status` parameter to `COMPLETED`. `DataSource` in `COMPLETED` or `PENDING` states can be used to perform only `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
 *
 *  If Amazon ML can't accept the input source, it sets the `Status` parameter to `FAILED` and includes an error message in the `Message` attribute of the `GetDataSource` operation response.
 *
 * The observations should be contained in the database hosted on an Amazon Redshift cluster and should be specified by a `SelectSqlQuery` query. Amazon ML executes an `Unload` command in Amazon Redshift to transfer the result set of the `SelectSqlQuery` query to `S3StagingLocation`.
 *
 * After the `DataSource` has been created, it's ready for use in evaluations and batch predictions. If you plan to use the `DataSource` to train an `MLModel`, the `DataSource` also requires a recipe. A recipe describes how each input variable will be used in training an `MLModel`. Will the variable be included or excluded from training? Will the variable be manipulated; for example, will it be combined with another variable or will it be split apart into word combinations? The recipe provides answers to these questions.
 *
 * You can't change an existing datasource, but you can copy and modify the settings from an existing Amazon Redshift datasource to create a new datasource. To do so, call `GetDataSource` for an existing datasource and copy the values to a `CreateDataSource` call. Change the settings that you want to change and make sure that all required fields have the appropriate values.
 */
suspend inline fun MachineLearningClient.createDataSourceFromRedshift(crossinline block: CreateDataSourceFromRedshiftRequest.Builder.() -> Unit) = createDataSourceFromRedshift(CreateDataSourceFromRedshiftRequest.Builder().apply(block).build())

/**
 * Creates a `DataSource` object. A `DataSource` references data that can be used to perform `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
 *
 * `CreateDataSourceFromS3` is an asynchronous operation. In response to `CreateDataSourceFromS3`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `DataSource` status to `PENDING`. After the `DataSource` has been created and is ready for use, Amazon ML sets the `Status` parameter to `COMPLETED`. `DataSource` in the `COMPLETED` or `PENDING` state can be used to perform only `CreateMLModel`, `CreateEvaluation` or `CreateBatchPrediction` operations.
 *
 *  If Amazon ML can't accept the input source, it sets the `Status` parameter to `FAILED` and includes an error message in the `Message` attribute of the `GetDataSource` operation response.
 *
 * The observation data used in a `DataSource` should be ready to use; that is, it should have a consistent structure, and missing data values should be kept to a minimum. The observation data must reside in one or more .csv files in an Amazon Simple Storage Service (Amazon S3) location, along with a schema that describes the data items by name and type. The same schema must be used for all of the data files referenced by the `DataSource`.
 *
 * After the `DataSource` has been created, it's ready to use in evaluations and batch predictions. If you plan to use the `DataSource` to train an `MLModel`, the `DataSource` also needs a recipe. A recipe describes how each input variable will be used in training an `MLModel`. Will the variable be included or excluded from training? Will the variable be manipulated; for example, will it be combined with another variable or will it be split apart into word combinations? The recipe provides answers to these questions.
 */
suspend inline fun MachineLearningClient.createDataSourceFromS3(crossinline block: CreateDataSourceFromS3Request.Builder.() -> Unit) = createDataSourceFromS3(CreateDataSourceFromS3Request.Builder().apply(block).build())

/**
 * Creates a new `Evaluation` of an `MLModel`. An `MLModel` is evaluated on a set of observations associated to a `DataSource`. Like a `DataSource` for an `MLModel`, the `DataSource` for an `Evaluation` contains values for the `Target Variable`. The `Evaluation` compares the predicted result for each observation to the actual outcome and provides a summary so that you know how effective the `MLModel` functions on the test data. Evaluation generates a relevant performance metric, such as BinaryAUC, RegressionRMSE or MulticlassAvgFScore based on the corresponding `MLModelType`: `BINARY`, `REGRESSION` or `MULTICLASS`.
 *
 * `CreateEvaluation` is an asynchronous operation. In response to `CreateEvaluation`, Amazon Machine Learning (Amazon ML) immediately returns and sets the evaluation status to `PENDING`. After the `Evaluation` is created and ready for use, Amazon ML sets the status to `COMPLETED`.
 *
 * You can use the `GetEvaluation` operation to check progress of the evaluation during the creation operation.
 */
suspend inline fun MachineLearningClient.createEvaluation(crossinline block: CreateEvaluationRequest.Builder.() -> Unit) = createEvaluation(CreateEvaluationRequest.Builder().apply(block).build())

/**
 * Creates a new `MLModel` using the `DataSource` and the recipe as information sources.
 *
 * An `MLModel` is nearly immutable. Users can update only the `MLModelName` and the `ScoreThreshold` in an `MLModel` without creating a new `MLModel`.
 *
 * `CreateMLModel` is an asynchronous operation. In response to `CreateMLModel`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `MLModel` status to `PENDING`. After the `MLModel` has been created and ready is for use, Amazon ML sets the status to `COMPLETED`.
 *
 * You can use the `GetMLModel` operation to check the progress of the `MLModel` during the creation operation.
 *
 * `CreateMLModel` requires a `DataSource` with computed statistics, which can be created by setting `ComputeStatistics` to `true` in `CreateDataSourceFromRDS`, `CreateDataSourceFromS3`, or `CreateDataSourceFromRedshift` operations.
 */
suspend inline fun MachineLearningClient.createMlModel(crossinline block: CreateMlModelRequest.Builder.() -> Unit) = createMlModel(CreateMlModelRequest.Builder().apply(block).build())

/**
 * Creates a real-time endpoint for the `MLModel`. The endpoint contains the URI of the `MLModel`; that is, the location to send real-time prediction requests for the specified `MLModel`.
 */
suspend inline fun MachineLearningClient.createRealtimeEndpoint(crossinline block: CreateRealtimeEndpointRequest.Builder.() -> Unit) = createRealtimeEndpoint(CreateRealtimeEndpointRequest.Builder().apply(block).build())

/**
 * Assigns the DELETED status to a `BatchPrediction`, rendering it unusable.
 *
 * After using the `DeleteBatchPrediction` operation, you can use the GetBatchPrediction operation to verify that the status of the `BatchPrediction` changed to DELETED.
 *
 * **Caution:** The result of the `DeleteBatchPrediction` operation is irreversible.
 */
suspend inline fun MachineLearningClient.deleteBatchPrediction(crossinline block: DeleteBatchPredictionRequest.Builder.() -> Unit) = deleteBatchPrediction(DeleteBatchPredictionRequest.Builder().apply(block).build())

/**
 * Assigns the DELETED status to a `DataSource`, rendering it unusable.
 *
 * After using the `DeleteDataSource` operation, you can use the GetDataSource operation to verify that the status of the `DataSource` changed to DELETED.
 *
 * **Caution:** The results of the `DeleteDataSource` operation are irreversible.
 */
suspend inline fun MachineLearningClient.deleteDataSource(crossinline block: DeleteDataSourceRequest.Builder.() -> Unit) = deleteDataSource(DeleteDataSourceRequest.Builder().apply(block).build())

/**
 * Assigns the `DELETED` status to an `Evaluation`, rendering it unusable.
 *
 * After invoking the `DeleteEvaluation` operation, you can use the `GetEvaluation` operation to verify that the status of the `Evaluation` changed to `DELETED`.
 *
 * **Caution:** The results of the `DeleteEvaluation` operation are irreversible.
 */
suspend inline fun MachineLearningClient.deleteEvaluation(crossinline block: DeleteEvaluationRequest.Builder.() -> Unit) = deleteEvaluation(DeleteEvaluationRequest.Builder().apply(block).build())

/**
 * Assigns the `DELETED` status to an `MLModel`, rendering it unusable.
 *
 * After using the `DeleteMLModel` operation, you can use the `GetMLModel` operation to verify that the status of the `MLModel` changed to DELETED.
 *
 * **Caution:** The result of the `DeleteMLModel` operation is irreversible.
 */
suspend inline fun MachineLearningClient.deleteMlModel(crossinline block: DeleteMlModelRequest.Builder.() -> Unit) = deleteMlModel(DeleteMlModelRequest.Builder().apply(block).build())

/**
 * Deletes a real time endpoint of an `MLModel`.
 */
suspend inline fun MachineLearningClient.deleteRealtimeEndpoint(crossinline block: DeleteRealtimeEndpointRequest.Builder.() -> Unit) = deleteRealtimeEndpoint(DeleteRealtimeEndpointRequest.Builder().apply(block).build())

/**
 * Deletes the specified tags associated with an ML object. After this operation is complete, you can't recover deleted tags.
 *
 * If you specify a tag that doesn't exist, Amazon ML ignores it.
 */
suspend inline fun MachineLearningClient.deleteTags(crossinline block: DeleteTagsRequest.Builder.() -> Unit) = deleteTags(DeleteTagsRequest.Builder().apply(block).build())

/**
 * Returns a list of `BatchPrediction` operations that match the search criteria in the request.
 */
suspend inline fun MachineLearningClient.describeBatchPredictions(crossinline block: DescribeBatchPredictionsRequest.Builder.() -> Unit) = describeBatchPredictions(DescribeBatchPredictionsRequest.Builder().apply(block).build())

/**
 * Returns a list of `DataSource` that match the search criteria in the request.
 */
suspend inline fun MachineLearningClient.describeDataSources(crossinline block: DescribeDataSourcesRequest.Builder.() -> Unit) = describeDataSources(DescribeDataSourcesRequest.Builder().apply(block).build())

/**
 * Returns a list of `DescribeEvaluations` that match the search criteria in the request.
 */
suspend inline fun MachineLearningClient.describeEvaluations(crossinline block: DescribeEvaluationsRequest.Builder.() -> Unit) = describeEvaluations(DescribeEvaluationsRequest.Builder().apply(block).build())

/**
 * Returns a list of `MLModel` that match the search criteria in the request.
 */
suspend inline fun MachineLearningClient.describeMlModels(crossinline block: DescribeMlModelsRequest.Builder.() -> Unit) = describeMlModels(DescribeMlModelsRequest.Builder().apply(block).build())

/**
 * Describes one or more of the tags for your Amazon ML object.
 */
suspend inline fun MachineLearningClient.describeTags(crossinline block: DescribeTagsRequest.Builder.() -> Unit) = describeTags(DescribeTagsRequest.Builder().apply(block).build())

/**
 * Returns a `BatchPrediction` that includes detailed metadata, status, and data file information for a `Batch Prediction` request.
 */
suspend inline fun MachineLearningClient.getBatchPrediction(crossinline block: GetBatchPredictionRequest.Builder.() -> Unit) = getBatchPrediction(GetBatchPredictionRequest.Builder().apply(block).build())

/**
 * Returns a `DataSource` that includes metadata and data file information, as well as the current status of the `DataSource`.
 *
 * `GetDataSource` provides results in normal or verbose format. The verbose format adds the schema description and the list of files pointed to by the DataSource to the normal format.
 */
suspend inline fun MachineLearningClient.getDataSource(crossinline block: GetDataSourceRequest.Builder.() -> Unit) = getDataSource(GetDataSourceRequest.Builder().apply(block).build())

/**
 * Returns an `Evaluation` that includes metadata as well as the current status of the `Evaluation`.
 */
suspend inline fun MachineLearningClient.getEvaluation(crossinline block: GetEvaluationRequest.Builder.() -> Unit) = getEvaluation(GetEvaluationRequest.Builder().apply(block).build())

/**
 * Returns an `MLModel` that includes detailed metadata, data source information, and the current status of the `MLModel`.
 *
 * `GetMLModel` provides results in normal or verbose format.
 */
suspend inline fun MachineLearningClient.getMlModel(crossinline block: GetMlModelRequest.Builder.() -> Unit) = getMlModel(GetMlModelRequest.Builder().apply(block).build())

/**
 * Generates a prediction for the observation using the specified `ML Model`.
 *
 * **Note:** Not all response parameters will be populated. Whether a response parameter is populated depends on the type of model requested.
 */
suspend inline fun MachineLearningClient.predict(crossinline block: PredictRequest.Builder.() -> Unit) = predict(PredictRequest.Builder().apply(block).build())

/**
 * Updates the `BatchPredictionName` of a `BatchPrediction`.
 *
 * You can use the `GetBatchPrediction` operation to view the contents of the updated data element.
 */
suspend inline fun MachineLearningClient.updateBatchPrediction(crossinline block: UpdateBatchPredictionRequest.Builder.() -> Unit) = updateBatchPrediction(UpdateBatchPredictionRequest.Builder().apply(block).build())

/**
 * Updates the `DataSourceName` of a `DataSource`.
 *
 * You can use the `GetDataSource` operation to view the contents of the updated data element.
 */
suspend inline fun MachineLearningClient.updateDataSource(crossinline block: UpdateDataSourceRequest.Builder.() -> Unit) = updateDataSource(UpdateDataSourceRequest.Builder().apply(block).build())

/**
 * Updates the `EvaluationName` of an `Evaluation`.
 *
 * You can use the `GetEvaluation` operation to view the contents of the updated data element.
 */
suspend inline fun MachineLearningClient.updateEvaluation(crossinline block: UpdateEvaluationRequest.Builder.() -> Unit) = updateEvaluation(UpdateEvaluationRequest.Builder().apply(block).build())

/**
 * Updates the `MLModelName` and the `ScoreThreshold` of an `MLModel`.
 *
 * You can use the `GetMLModel` operation to view the contents of the updated data element.
 */
suspend inline fun MachineLearningClient.updateMlModel(crossinline block: UpdateMlModelRequest.Builder.() -> Unit) = updateMlModel(UpdateMlModelRequest.Builder().apply(block).build())
