// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.m2.auth.DefaultM2AuthSchemeProvider
import aws.sdk.kotlin.services.m2.auth.M2AuthSchemeProvider
import aws.sdk.kotlin.services.m2.endpoints.DefaultM2EndpointProvider
import aws.sdk.kotlin.services.m2.endpoints.M2EndpointParameters
import aws.sdk.kotlin.services.m2.endpoints.M2EndpointProvider
import aws.sdk.kotlin.services.m2.model.CancelBatchJobExecutionRequest
import aws.sdk.kotlin.services.m2.model.CancelBatchJobExecutionResponse
import aws.sdk.kotlin.services.m2.model.CreateApplicationRequest
import aws.sdk.kotlin.services.m2.model.CreateApplicationResponse
import aws.sdk.kotlin.services.m2.model.CreateDataSetExportTaskRequest
import aws.sdk.kotlin.services.m2.model.CreateDataSetExportTaskResponse
import aws.sdk.kotlin.services.m2.model.CreateDataSetImportTaskRequest
import aws.sdk.kotlin.services.m2.model.CreateDataSetImportTaskResponse
import aws.sdk.kotlin.services.m2.model.CreateDeploymentRequest
import aws.sdk.kotlin.services.m2.model.CreateDeploymentResponse
import aws.sdk.kotlin.services.m2.model.CreateEnvironmentRequest
import aws.sdk.kotlin.services.m2.model.CreateEnvironmentResponse
import aws.sdk.kotlin.services.m2.model.DeleteApplicationFromEnvironmentRequest
import aws.sdk.kotlin.services.m2.model.DeleteApplicationFromEnvironmentResponse
import aws.sdk.kotlin.services.m2.model.DeleteApplicationRequest
import aws.sdk.kotlin.services.m2.model.DeleteApplicationResponse
import aws.sdk.kotlin.services.m2.model.DeleteEnvironmentRequest
import aws.sdk.kotlin.services.m2.model.DeleteEnvironmentResponse
import aws.sdk.kotlin.services.m2.model.GetApplicationRequest
import aws.sdk.kotlin.services.m2.model.GetApplicationResponse
import aws.sdk.kotlin.services.m2.model.GetApplicationVersionRequest
import aws.sdk.kotlin.services.m2.model.GetApplicationVersionResponse
import aws.sdk.kotlin.services.m2.model.GetBatchJobExecutionRequest
import aws.sdk.kotlin.services.m2.model.GetBatchJobExecutionResponse
import aws.sdk.kotlin.services.m2.model.GetDataSetDetailsRequest
import aws.sdk.kotlin.services.m2.model.GetDataSetDetailsResponse
import aws.sdk.kotlin.services.m2.model.GetDataSetExportTaskRequest
import aws.sdk.kotlin.services.m2.model.GetDataSetExportTaskResponse
import aws.sdk.kotlin.services.m2.model.GetDataSetImportTaskRequest
import aws.sdk.kotlin.services.m2.model.GetDataSetImportTaskResponse
import aws.sdk.kotlin.services.m2.model.GetDeploymentRequest
import aws.sdk.kotlin.services.m2.model.GetDeploymentResponse
import aws.sdk.kotlin.services.m2.model.GetEnvironmentRequest
import aws.sdk.kotlin.services.m2.model.GetEnvironmentResponse
import aws.sdk.kotlin.services.m2.model.GetSignedBluinsightsUrlRequest
import aws.sdk.kotlin.services.m2.model.GetSignedBluinsightsUrlResponse
import aws.sdk.kotlin.services.m2.model.ListApplicationVersionsRequest
import aws.sdk.kotlin.services.m2.model.ListApplicationVersionsResponse
import aws.sdk.kotlin.services.m2.model.ListApplicationsRequest
import aws.sdk.kotlin.services.m2.model.ListApplicationsResponse
import aws.sdk.kotlin.services.m2.model.ListBatchJobDefinitionsRequest
import aws.sdk.kotlin.services.m2.model.ListBatchJobDefinitionsResponse
import aws.sdk.kotlin.services.m2.model.ListBatchJobExecutionsRequest
import aws.sdk.kotlin.services.m2.model.ListBatchJobExecutionsResponse
import aws.sdk.kotlin.services.m2.model.ListBatchJobRestartPointsRequest
import aws.sdk.kotlin.services.m2.model.ListBatchJobRestartPointsResponse
import aws.sdk.kotlin.services.m2.model.ListDataSetExportHistoryRequest
import aws.sdk.kotlin.services.m2.model.ListDataSetExportHistoryResponse
import aws.sdk.kotlin.services.m2.model.ListDataSetImportHistoryRequest
import aws.sdk.kotlin.services.m2.model.ListDataSetImportHistoryResponse
import aws.sdk.kotlin.services.m2.model.ListDataSetsRequest
import aws.sdk.kotlin.services.m2.model.ListDataSetsResponse
import aws.sdk.kotlin.services.m2.model.ListDeploymentsRequest
import aws.sdk.kotlin.services.m2.model.ListDeploymentsResponse
import aws.sdk.kotlin.services.m2.model.ListEngineVersionsRequest
import aws.sdk.kotlin.services.m2.model.ListEngineVersionsResponse
import aws.sdk.kotlin.services.m2.model.ListEnvironmentsRequest
import aws.sdk.kotlin.services.m2.model.ListEnvironmentsResponse
import aws.sdk.kotlin.services.m2.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.m2.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.m2.model.StartApplicationRequest
import aws.sdk.kotlin.services.m2.model.StartApplicationResponse
import aws.sdk.kotlin.services.m2.model.StartBatchJobRequest
import aws.sdk.kotlin.services.m2.model.StartBatchJobResponse
import aws.sdk.kotlin.services.m2.model.StopApplicationRequest
import aws.sdk.kotlin.services.m2.model.StopApplicationResponse
import aws.sdk.kotlin.services.m2.model.TagResourceRequest
import aws.sdk.kotlin.services.m2.model.TagResourceResponse
import aws.sdk.kotlin.services.m2.model.UntagResourceRequest
import aws.sdk.kotlin.services.m2.model.UntagResourceResponse
import aws.sdk.kotlin.services.m2.model.UpdateApplicationRequest
import aws.sdk.kotlin.services.m2.model.UpdateApplicationResponse
import aws.sdk.kotlin.services.m2.model.UpdateEnvironmentRequest
import aws.sdk.kotlin.services.m2.model.UpdateEnvironmentResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "m2"
public const val SdkVersion: String = "1.5.9"
public const val ServiceApiVersion: String = "2021-04-28"

/**
 * Amazon Web Services Mainframe Modernization provides tools and resources to help you plan and implement migration and modernization from mainframes to Amazon Web Services managed runtime environments. It provides tools for analyzing existing mainframe applications, developing or updating mainframe applications using COBOL or PL/I, and implementing an automated pipeline for continuous integration and continuous delivery (CI/CD) of the applications.
 */
public interface M2Client : SdkClient {
    /**
     * M2Client's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, M2Client, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "M2",
                "M2",
                "m2",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, M2Client>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): M2Client = DefaultM2Client(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: M2EndpointProvider = builder.endpointProvider ?: DefaultM2EndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: M2AuthSchemeProvider = builder.authSchemeProvider ?: DefaultM2AuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "m2"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: M2EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: M2AuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels the running of a specific batch job execution.
     */
    public suspend fun cancelBatchJobExecution(input: CancelBatchJobExecutionRequest): CancelBatchJobExecutionResponse

    /**
     * Creates a new application with given parameters. Requires an existing runtime environment and application definition file.
     */
    public suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Starts a data set export task for a specific application.
     */
    public suspend fun createDataSetExportTask(input: CreateDataSetExportTaskRequest): CreateDataSetExportTaskResponse

    /**
     * Starts a data set import task for a specific application.
     */
    public suspend fun createDataSetImportTask(input: CreateDataSetImportTaskRequest): CreateDataSetImportTaskResponse

    /**
     * Creates and starts a deployment to deploy an application into a runtime environment.
     */
    public suspend fun createDeployment(input: CreateDeploymentRequest): CreateDeploymentResponse

    /**
     * Creates a runtime environment for a given runtime engine.
     */
    public suspend fun createEnvironment(input: CreateEnvironmentRequest): CreateEnvironmentResponse

    /**
     * Deletes a specific application. You cannot delete a running application.
     */
    public suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Deletes a specific application from the specific runtime environment where it was previously deployed. You cannot delete a runtime environment using DeleteEnvironment if any application has ever been deployed to it. This API removes the association of the application with the runtime environment so you can delete the environment smoothly.
     */
    public suspend fun deleteApplicationFromEnvironment(input: DeleteApplicationFromEnvironmentRequest): DeleteApplicationFromEnvironmentResponse

    /**
     * Deletes a specific runtime environment. The environment cannot contain deployed applications. If it does, you must delete those applications before you delete the environment.
     */
    public suspend fun deleteEnvironment(input: DeleteEnvironmentRequest): DeleteEnvironmentResponse

    /**
     * Describes the details of a specific application.
     */
    public suspend fun getApplication(input: GetApplicationRequest): GetApplicationResponse

    /**
     * Returns details about a specific version of a specific application.
     */
    public suspend fun getApplicationVersion(input: GetApplicationVersionRequest): GetApplicationVersionResponse

    /**
     * Gets the details of a specific batch job execution for a specific application.
     */
    public suspend fun getBatchJobExecution(input: GetBatchJobExecutionRequest): GetBatchJobExecutionResponse

    /**
     * Gets the details of a specific data set.
     */
    public suspend fun getDataSetDetails(input: GetDataSetDetailsRequest): GetDataSetDetailsResponse

    /**
     * Gets the status of a data set import task initiated with the CreateDataSetExportTask operation.
     */
    public suspend fun getDataSetExportTask(input: GetDataSetExportTaskRequest): GetDataSetExportTaskResponse

    /**
     * Gets the status of a data set import task initiated with the CreateDataSetImportTask operation.
     */
    public suspend fun getDataSetImportTask(input: GetDataSetImportTaskRequest): GetDataSetImportTaskResponse

    /**
     * Gets details of a specific deployment with a given deployment identifier.
     */
    public suspend fun getDeployment(input: GetDeploymentRequest): GetDeploymentResponse

    /**
     * Describes a specific runtime environment.
     */
    public suspend fun getEnvironment(input: GetEnvironmentRequest): GetEnvironmentResponse

    /**
     * Gets a single sign-on URL that can be used to connect to AWS Blu Insights.
     */
    public suspend fun getSignedBluinsightsUrl(input: GetSignedBluinsightsUrlRequest = GetSignedBluinsightsUrlRequest { }): GetSignedBluinsightsUrlResponse

    /**
     * Returns a list of the application versions for a specific application.
     */
    public suspend fun listApplicationVersions(input: ListApplicationVersionsRequest): ListApplicationVersionsResponse

    /**
     * Lists the applications associated with a specific Amazon Web Services account. You can provide the unique identifier of a specific runtime environment in a query parameter to see all applications associated with that environment.
     */
    public suspend fun listApplications(input: ListApplicationsRequest = ListApplicationsRequest { }): ListApplicationsResponse

    /**
     * Lists all the available batch job definitions based on the batch job resources uploaded during the application creation. You can use the batch job definitions in the list to start a batch job.
     */
    public suspend fun listBatchJobDefinitions(input: ListBatchJobDefinitionsRequest): ListBatchJobDefinitionsResponse

    /**
     * Lists historical, current, and scheduled batch job executions for a specific application.
     */
    public suspend fun listBatchJobExecutions(input: ListBatchJobExecutionsRequest): ListBatchJobExecutionsResponse

    /**
     * Lists all the job steps for a JCL file to restart a batch job. This is only applicable for Micro Focus engine with versions 8.0.6 and above.
     */
    public suspend fun listBatchJobRestartPoints(input: ListBatchJobRestartPointsRequest): ListBatchJobRestartPointsResponse

    /**
     * Lists the data set exports for the specified application.
     */
    public suspend fun listDataSetExportHistory(input: ListDataSetExportHistoryRequest): ListDataSetExportHistoryResponse

    /**
     * Lists the data set imports for the specified application.
     */
    public suspend fun listDataSetImportHistory(input: ListDataSetImportHistoryRequest): ListDataSetImportHistoryResponse

    /**
     * Lists the data sets imported for a specific application. In Amazon Web Services Mainframe Modernization, data sets are associated with applications deployed on runtime environments. This is known as importing data sets. Currently, Amazon Web Services Mainframe Modernization can import data sets into catalogs using [CreateDataSetImportTask](https://docs.aws.amazon.com/m2/latest/APIReference/API_CreateDataSetImportTask.html).
     */
    public suspend fun listDataSets(input: ListDataSetsRequest): ListDataSetsResponse

    /**
     * Returns a list of all deployments of a specific application. A deployment is a combination of a specific application and a specific version of that application. Each deployment is mapped to a particular application version.
     */
    public suspend fun listDeployments(input: ListDeploymentsRequest): ListDeploymentsResponse

    /**
     * Lists the available engine versions.
     */
    public suspend fun listEngineVersions(input: ListEngineVersionsRequest = ListEngineVersionsRequest { }): ListEngineVersionsResponse

    /**
     * Lists the runtime environments.
     */
    public suspend fun listEnvironments(input: ListEnvironmentsRequest = ListEnvironmentsRequest { }): ListEnvironmentsResponse

    /**
     * Lists the tags for the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Starts an application that is currently stopped.
     */
    public suspend fun startApplication(input: StartApplicationRequest): StartApplicationResponse

    /**
     * Starts a batch job and returns the unique identifier of this execution of the batch job. The associated application must be running in order to start the batch job.
     */
    public suspend fun startBatchJob(input: StartBatchJobRequest): StartBatchJobResponse

    /**
     * Stops a running application.
     */
    public suspend fun stopApplication(input: StopApplicationRequest): StopApplicationResponse

    /**
     * Adds one or more tags to the specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an application and creates a new version.
     */
    public suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse

    /**
     * Updates the configuration details for a specific runtime environment.
     */
    public suspend fun updateEnvironment(input: UpdateEnvironmentRequest): UpdateEnvironmentResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun M2Client.withConfig(block: M2Client.Config.Builder.() -> Unit): M2Client {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultM2Client(newConfig)
}

/**
 * Cancels the running of a specific batch job execution.
 */
public suspend inline fun M2Client.cancelBatchJobExecution(crossinline block: CancelBatchJobExecutionRequest.Builder.() -> Unit): CancelBatchJobExecutionResponse = cancelBatchJobExecution(CancelBatchJobExecutionRequest.Builder().apply(block).build())

/**
 * Creates a new application with given parameters. Requires an existing runtime environment and application definition file.
 */
public suspend inline fun M2Client.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Starts a data set export task for a specific application.
 */
public suspend inline fun M2Client.createDataSetExportTask(crossinline block: CreateDataSetExportTaskRequest.Builder.() -> Unit): CreateDataSetExportTaskResponse = createDataSetExportTask(CreateDataSetExportTaskRequest.Builder().apply(block).build())

/**
 * Starts a data set import task for a specific application.
 */
public suspend inline fun M2Client.createDataSetImportTask(crossinline block: CreateDataSetImportTaskRequest.Builder.() -> Unit): CreateDataSetImportTaskResponse = createDataSetImportTask(CreateDataSetImportTaskRequest.Builder().apply(block).build())

/**
 * Creates and starts a deployment to deploy an application into a runtime environment.
 */
public suspend inline fun M2Client.createDeployment(crossinline block: CreateDeploymentRequest.Builder.() -> Unit): CreateDeploymentResponse = createDeployment(CreateDeploymentRequest.Builder().apply(block).build())

/**
 * Creates a runtime environment for a given runtime engine.
 */
public suspend inline fun M2Client.createEnvironment(crossinline block: CreateEnvironmentRequest.Builder.() -> Unit): CreateEnvironmentResponse = createEnvironment(CreateEnvironmentRequest.Builder().apply(block).build())

/**
 * Deletes a specific application. You cannot delete a running application.
 */
public suspend inline fun M2Client.deleteApplication(crossinline block: DeleteApplicationRequest.Builder.() -> Unit): DeleteApplicationResponse = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

/**
 * Deletes a specific application from the specific runtime environment where it was previously deployed. You cannot delete a runtime environment using DeleteEnvironment if any application has ever been deployed to it. This API removes the association of the application with the runtime environment so you can delete the environment smoothly.
 */
public suspend inline fun M2Client.deleteApplicationFromEnvironment(crossinline block: DeleteApplicationFromEnvironmentRequest.Builder.() -> Unit): DeleteApplicationFromEnvironmentResponse = deleteApplicationFromEnvironment(DeleteApplicationFromEnvironmentRequest.Builder().apply(block).build())

/**
 * Deletes a specific runtime environment. The environment cannot contain deployed applications. If it does, you must delete those applications before you delete the environment.
 */
public suspend inline fun M2Client.deleteEnvironment(crossinline block: DeleteEnvironmentRequest.Builder.() -> Unit): DeleteEnvironmentResponse = deleteEnvironment(DeleteEnvironmentRequest.Builder().apply(block).build())

/**
 * Describes the details of a specific application.
 */
public suspend inline fun M2Client.getApplication(crossinline block: GetApplicationRequest.Builder.() -> Unit): GetApplicationResponse = getApplication(GetApplicationRequest.Builder().apply(block).build())

/**
 * Returns details about a specific version of a specific application.
 */
public suspend inline fun M2Client.getApplicationVersion(crossinline block: GetApplicationVersionRequest.Builder.() -> Unit): GetApplicationVersionResponse = getApplicationVersion(GetApplicationVersionRequest.Builder().apply(block).build())

/**
 * Gets the details of a specific batch job execution for a specific application.
 */
public suspend inline fun M2Client.getBatchJobExecution(crossinline block: GetBatchJobExecutionRequest.Builder.() -> Unit): GetBatchJobExecutionResponse = getBatchJobExecution(GetBatchJobExecutionRequest.Builder().apply(block).build())

/**
 * Gets the details of a specific data set.
 */
public suspend inline fun M2Client.getDataSetDetails(crossinline block: GetDataSetDetailsRequest.Builder.() -> Unit): GetDataSetDetailsResponse = getDataSetDetails(GetDataSetDetailsRequest.Builder().apply(block).build())

/**
 * Gets the status of a data set import task initiated with the CreateDataSetExportTask operation.
 */
public suspend inline fun M2Client.getDataSetExportTask(crossinline block: GetDataSetExportTaskRequest.Builder.() -> Unit): GetDataSetExportTaskResponse = getDataSetExportTask(GetDataSetExportTaskRequest.Builder().apply(block).build())

/**
 * Gets the status of a data set import task initiated with the CreateDataSetImportTask operation.
 */
public suspend inline fun M2Client.getDataSetImportTask(crossinline block: GetDataSetImportTaskRequest.Builder.() -> Unit): GetDataSetImportTaskResponse = getDataSetImportTask(GetDataSetImportTaskRequest.Builder().apply(block).build())

/**
 * Gets details of a specific deployment with a given deployment identifier.
 */
public suspend inline fun M2Client.getDeployment(crossinline block: GetDeploymentRequest.Builder.() -> Unit): GetDeploymentResponse = getDeployment(GetDeploymentRequest.Builder().apply(block).build())

/**
 * Describes a specific runtime environment.
 */
public suspend inline fun M2Client.getEnvironment(crossinline block: GetEnvironmentRequest.Builder.() -> Unit): GetEnvironmentResponse = getEnvironment(GetEnvironmentRequest.Builder().apply(block).build())

/**
 * Gets a single sign-on URL that can be used to connect to AWS Blu Insights.
 */
public suspend inline fun M2Client.getSignedBluinsightsUrl(crossinline block: GetSignedBluinsightsUrlRequest.Builder.() -> Unit): GetSignedBluinsightsUrlResponse = getSignedBluinsightsUrl(GetSignedBluinsightsUrlRequest.Builder().apply(block).build())

/**
 * Returns a list of the application versions for a specific application.
 */
public suspend inline fun M2Client.listApplicationVersions(crossinline block: ListApplicationVersionsRequest.Builder.() -> Unit): ListApplicationVersionsResponse = listApplicationVersions(ListApplicationVersionsRequest.Builder().apply(block).build())

/**
 * Lists the applications associated with a specific Amazon Web Services account. You can provide the unique identifier of a specific runtime environment in a query parameter to see all applications associated with that environment.
 */
public suspend inline fun M2Client.listApplications(crossinline block: ListApplicationsRequest.Builder.() -> Unit): ListApplicationsResponse = listApplications(ListApplicationsRequest.Builder().apply(block).build())

/**
 * Lists all the available batch job definitions based on the batch job resources uploaded during the application creation. You can use the batch job definitions in the list to start a batch job.
 */
public suspend inline fun M2Client.listBatchJobDefinitions(crossinline block: ListBatchJobDefinitionsRequest.Builder.() -> Unit): ListBatchJobDefinitionsResponse = listBatchJobDefinitions(ListBatchJobDefinitionsRequest.Builder().apply(block).build())

/**
 * Lists historical, current, and scheduled batch job executions for a specific application.
 */
public suspend inline fun M2Client.listBatchJobExecutions(crossinline block: ListBatchJobExecutionsRequest.Builder.() -> Unit): ListBatchJobExecutionsResponse = listBatchJobExecutions(ListBatchJobExecutionsRequest.Builder().apply(block).build())

/**
 * Lists all the job steps for a JCL file to restart a batch job. This is only applicable for Micro Focus engine with versions 8.0.6 and above.
 */
public suspend inline fun M2Client.listBatchJobRestartPoints(crossinline block: ListBatchJobRestartPointsRequest.Builder.() -> Unit): ListBatchJobRestartPointsResponse = listBatchJobRestartPoints(ListBatchJobRestartPointsRequest.Builder().apply(block).build())

/**
 * Lists the data set exports for the specified application.
 */
public suspend inline fun M2Client.listDataSetExportHistory(crossinline block: ListDataSetExportHistoryRequest.Builder.() -> Unit): ListDataSetExportHistoryResponse = listDataSetExportHistory(ListDataSetExportHistoryRequest.Builder().apply(block).build())

/**
 * Lists the data set imports for the specified application.
 */
public suspend inline fun M2Client.listDataSetImportHistory(crossinline block: ListDataSetImportHistoryRequest.Builder.() -> Unit): ListDataSetImportHistoryResponse = listDataSetImportHistory(ListDataSetImportHistoryRequest.Builder().apply(block).build())

/**
 * Lists the data sets imported for a specific application. In Amazon Web Services Mainframe Modernization, data sets are associated with applications deployed on runtime environments. This is known as importing data sets. Currently, Amazon Web Services Mainframe Modernization can import data sets into catalogs using [CreateDataSetImportTask](https://docs.aws.amazon.com/m2/latest/APIReference/API_CreateDataSetImportTask.html).
 */
public suspend inline fun M2Client.listDataSets(crossinline block: ListDataSetsRequest.Builder.() -> Unit): ListDataSetsResponse = listDataSets(ListDataSetsRequest.Builder().apply(block).build())

/**
 * Returns a list of all deployments of a specific application. A deployment is a combination of a specific application and a specific version of that application. Each deployment is mapped to a particular application version.
 */
public suspend inline fun M2Client.listDeployments(crossinline block: ListDeploymentsRequest.Builder.() -> Unit): ListDeploymentsResponse = listDeployments(ListDeploymentsRequest.Builder().apply(block).build())

/**
 * Lists the available engine versions.
 */
public suspend inline fun M2Client.listEngineVersions(crossinline block: ListEngineVersionsRequest.Builder.() -> Unit): ListEngineVersionsResponse = listEngineVersions(ListEngineVersionsRequest.Builder().apply(block).build())

/**
 * Lists the runtime environments.
 */
public suspend inline fun M2Client.listEnvironments(crossinline block: ListEnvironmentsRequest.Builder.() -> Unit): ListEnvironmentsResponse = listEnvironments(ListEnvironmentsRequest.Builder().apply(block).build())

/**
 * Lists the tags for the specified resource.
 */
public suspend inline fun M2Client.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Starts an application that is currently stopped.
 */
public suspend inline fun M2Client.startApplication(crossinline block: StartApplicationRequest.Builder.() -> Unit): StartApplicationResponse = startApplication(StartApplicationRequest.Builder().apply(block).build())

/**
 * Starts a batch job and returns the unique identifier of this execution of the batch job. The associated application must be running in order to start the batch job.
 */
public suspend inline fun M2Client.startBatchJob(crossinline block: StartBatchJobRequest.Builder.() -> Unit): StartBatchJobResponse = startBatchJob(StartBatchJobRequest.Builder().apply(block).build())

/**
 * Stops a running application.
 */
public suspend inline fun M2Client.stopApplication(crossinline block: StopApplicationRequest.Builder.() -> Unit): StopApplicationResponse = stopApplication(StopApplicationRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to the specified resource.
 */
public suspend inline fun M2Client.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified resource.
 */
public suspend inline fun M2Client.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an application and creates a new version.
 */
public suspend inline fun M2Client.updateApplication(crossinline block: UpdateApplicationRequest.Builder.() -> Unit): UpdateApplicationResponse = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())

/**
 * Updates the configuration details for a specific runtime environment.
 */
public suspend inline fun M2Client.updateEnvironment(crossinline block: UpdateEnvironmentRequest.Builder.() -> Unit): UpdateEnvironmentResponse = updateEnvironment(UpdateEnvironmentRequest.Builder().apply(block).build())
