// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.serde

import aws.sdk.kotlin.services.m2.model.DataSetExportSummary
import aws.sdk.kotlin.services.m2.model.DataSetTaskLifecycle
import aws.sdk.kotlin.services.m2.model.GetDataSetExportTaskResponse
import aws.sdk.kotlin.services.m2.model.M2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetDataSetExportTaskOperationDeserializer: HttpDeserializer.NonStreaming<GetDataSetExportTaskResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetDataSetExportTaskResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetDataSetExportTaskError(context, call, payload)
        }
        val builder = GetDataSetExportTaskResponse.Builder()

        if (payload != null) {
            deserializeGetDataSetExportTaskOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetDataSetExportTaskError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw M2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> M2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDataSetExportTaskOperationBody(builder: GetDataSetExportTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsKeyArn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusReason"))
    val SUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("summary"))
    val TASKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("taskId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(KMSKEYARN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
        field(SUMMARY_DESCRIPTOR)
        field(TASKID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                KMSKEYARN_DESCRIPTOR.index -> builder.kmsKeyArn = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { DataSetTaskLifecycle.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                SUMMARY_DESCRIPTOR.index -> builder.summary = deserializeDataSetExportSummaryDocument(deserializer)
                TASKID_DESCRIPTOR.index -> builder.taskId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
