// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.paginators

import aws.sdk.kotlin.services.m2.M2Client
import aws.sdk.kotlin.services.m2.model.ApplicationSummary
import aws.sdk.kotlin.services.m2.model.ApplicationVersionSummary
import aws.sdk.kotlin.services.m2.model.BatchJobDefinition
import aws.sdk.kotlin.services.m2.model.BatchJobExecutionSummary
import aws.sdk.kotlin.services.m2.model.DataSetExportTask
import aws.sdk.kotlin.services.m2.model.DataSetImportTask
import aws.sdk.kotlin.services.m2.model.DataSetSummary
import aws.sdk.kotlin.services.m2.model.DeploymentSummary
import aws.sdk.kotlin.services.m2.model.EngineVersionsSummary
import aws.sdk.kotlin.services.m2.model.EnvironmentSummary
import aws.sdk.kotlin.services.m2.model.ListApplicationVersionsRequest
import aws.sdk.kotlin.services.m2.model.ListApplicationVersionsResponse
import aws.sdk.kotlin.services.m2.model.ListApplicationsRequest
import aws.sdk.kotlin.services.m2.model.ListApplicationsResponse
import aws.sdk.kotlin.services.m2.model.ListBatchJobDefinitionsRequest
import aws.sdk.kotlin.services.m2.model.ListBatchJobDefinitionsResponse
import aws.sdk.kotlin.services.m2.model.ListBatchJobExecutionsRequest
import aws.sdk.kotlin.services.m2.model.ListBatchJobExecutionsResponse
import aws.sdk.kotlin.services.m2.model.ListDataSetExportHistoryRequest
import aws.sdk.kotlin.services.m2.model.ListDataSetExportHistoryResponse
import aws.sdk.kotlin.services.m2.model.ListDataSetImportHistoryRequest
import aws.sdk.kotlin.services.m2.model.ListDataSetImportHistoryResponse
import aws.sdk.kotlin.services.m2.model.ListDataSetsRequest
import aws.sdk.kotlin.services.m2.model.ListDataSetsResponse
import aws.sdk.kotlin.services.m2.model.ListDeploymentsRequest
import aws.sdk.kotlin.services.m2.model.ListDeploymentsResponse
import aws.sdk.kotlin.services.m2.model.ListEngineVersionsRequest
import aws.sdk.kotlin.services.m2.model.ListEngineVersionsResponse
import aws.sdk.kotlin.services.m2.model.ListEnvironmentsRequest
import aws.sdk.kotlin.services.m2.model.ListEnvironmentsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApplicationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun M2Client.listApplicationsPaginated(initialRequest: ListApplicationsRequest = ListApplicationsRequest { }): Flow<ListApplicationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApplicationsPaginated.listApplications(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun M2Client.listApplicationsPaginated(block: ListApplicationsRequest.Builder.() -> Unit): Flow<ListApplicationsResponse> =
    listApplicationsPaginated(ListApplicationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listApplicationsPaginated]
 * to access the nested member [ApplicationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ApplicationSummary]
 */
@JvmName("listApplicationsResponseApplicationSummary")
public fun Flow<ListApplicationsResponse>.applications(): Flow<ApplicationSummary> =
    transform() { response ->
        response.applications?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListApplicationVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApplicationVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationVersionsResponse]
 */
public fun M2Client.listApplicationVersionsPaginated(initialRequest: ListApplicationVersionsRequest): Flow<ListApplicationVersionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApplicationVersionsPaginated.listApplicationVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListApplicationVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationVersionsResponse]
 */
public fun M2Client.listApplicationVersionsPaginated(block: ListApplicationVersionsRequest.Builder.() -> Unit): Flow<ListApplicationVersionsResponse> =
    listApplicationVersionsPaginated(ListApplicationVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listApplicationVersionsPaginated]
 * to access the nested member [ApplicationVersionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ApplicationVersionSummary]
 */
@JvmName("listApplicationVersionsResponseApplicationVersionSummary")
public fun Flow<ListApplicationVersionsResponse>.applicationVersions(): Flow<ApplicationVersionSummary> =
    transform() { response ->
        response.applicationVersions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListBatchJobDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBatchJobDefinitionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBatchJobDefinitionsResponse]
 */
public fun M2Client.listBatchJobDefinitionsPaginated(initialRequest: ListBatchJobDefinitionsRequest): Flow<ListBatchJobDefinitionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBatchJobDefinitionsPaginated.listBatchJobDefinitions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListBatchJobDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBatchJobDefinitionsResponse]
 */
public fun M2Client.listBatchJobDefinitionsPaginated(block: ListBatchJobDefinitionsRequest.Builder.() -> Unit): Flow<ListBatchJobDefinitionsResponse> =
    listBatchJobDefinitionsPaginated(ListBatchJobDefinitionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBatchJobDefinitionsPaginated]
 * to access the nested member [BatchJobDefinition]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BatchJobDefinition]
 */
@JvmName("listBatchJobDefinitionsResponseBatchJobDefinition")
public fun Flow<ListBatchJobDefinitionsResponse>.batchJobDefinitions(): Flow<BatchJobDefinition> =
    transform() { response ->
        response.batchJobDefinitions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListBatchJobExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBatchJobExecutionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBatchJobExecutionsResponse]
 */
public fun M2Client.listBatchJobExecutionsPaginated(initialRequest: ListBatchJobExecutionsRequest): Flow<ListBatchJobExecutionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBatchJobExecutionsPaginated.listBatchJobExecutions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListBatchJobExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBatchJobExecutionsResponse]
 */
public fun M2Client.listBatchJobExecutionsPaginated(block: ListBatchJobExecutionsRequest.Builder.() -> Unit): Flow<ListBatchJobExecutionsResponse> =
    listBatchJobExecutionsPaginated(ListBatchJobExecutionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBatchJobExecutionsPaginated]
 * to access the nested member [BatchJobExecutionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BatchJobExecutionSummary]
 */
@JvmName("listBatchJobExecutionsResponseBatchJobExecutionSummary")
public fun Flow<ListBatchJobExecutionsResponse>.batchJobExecutions(): Flow<BatchJobExecutionSummary> =
    transform() { response ->
        response.batchJobExecutions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDataSetExportHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataSetExportHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSetExportHistoryResponse]
 */
public fun M2Client.listDataSetExportHistoryPaginated(initialRequest: ListDataSetExportHistoryRequest): Flow<ListDataSetExportHistoryResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataSetExportHistoryPaginated.listDataSetExportHistory(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDataSetExportHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSetExportHistoryResponse]
 */
public fun M2Client.listDataSetExportHistoryPaginated(block: ListDataSetExportHistoryRequest.Builder.() -> Unit): Flow<ListDataSetExportHistoryResponse> =
    listDataSetExportHistoryPaginated(ListDataSetExportHistoryRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDataSetExportHistoryPaginated]
 * to access the nested member [DataSetExportTask]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataSetExportTask]
 */
@JvmName("listDataSetExportHistoryResponseDataSetExportTask")
public fun Flow<ListDataSetExportHistoryResponse>.dataSetExportTasks(): Flow<DataSetExportTask> =
    transform() { response ->
        response.dataSetExportTasks?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDataSetImportHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataSetImportHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSetImportHistoryResponse]
 */
public fun M2Client.listDataSetImportHistoryPaginated(initialRequest: ListDataSetImportHistoryRequest): Flow<ListDataSetImportHistoryResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataSetImportHistoryPaginated.listDataSetImportHistory(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDataSetImportHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSetImportHistoryResponse]
 */
public fun M2Client.listDataSetImportHistoryPaginated(block: ListDataSetImportHistoryRequest.Builder.() -> Unit): Flow<ListDataSetImportHistoryResponse> =
    listDataSetImportHistoryPaginated(ListDataSetImportHistoryRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDataSetImportHistoryPaginated]
 * to access the nested member [DataSetImportTask]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataSetImportTask]
 */
@JvmName("listDataSetImportHistoryResponseDataSetImportTask")
public fun Flow<ListDataSetImportHistoryResponse>.dataSetImportTasks(): Flow<DataSetImportTask> =
    transform() { response ->
        response.dataSetImportTasks?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDataSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataSetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSetsResponse]
 */
public fun M2Client.listDataSetsPaginated(initialRequest: ListDataSetsRequest): Flow<ListDataSetsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataSetsPaginated.listDataSets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDataSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSetsResponse]
 */
public fun M2Client.listDataSetsPaginated(block: ListDataSetsRequest.Builder.() -> Unit): Flow<ListDataSetsResponse> =
    listDataSetsPaginated(ListDataSetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDataSetsPaginated]
 * to access the nested member [DataSetSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataSetSummary]
 */
@JvmName("listDataSetsResponseDataSetSummary")
public fun Flow<ListDataSetsResponse>.dataSets(): Flow<DataSetSummary> =
    transform() { response ->
        response.dataSets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDeploymentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDeploymentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentsResponse]
 */
public fun M2Client.listDeploymentsPaginated(initialRequest: ListDeploymentsRequest): Flow<ListDeploymentsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDeploymentsPaginated.listDeployments(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDeploymentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentsResponse]
 */
public fun M2Client.listDeploymentsPaginated(block: ListDeploymentsRequest.Builder.() -> Unit): Flow<ListDeploymentsResponse> =
    listDeploymentsPaginated(ListDeploymentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDeploymentsPaginated]
 * to access the nested member [DeploymentSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DeploymentSummary]
 */
@JvmName("listDeploymentsResponseDeploymentSummary")
public fun Flow<ListDeploymentsResponse>.deployments(): Flow<DeploymentSummary> =
    transform() { response ->
        response.deployments?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEngineVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEngineVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEngineVersionsResponse]
 */
public fun M2Client.listEngineVersionsPaginated(initialRequest: ListEngineVersionsRequest = ListEngineVersionsRequest { }): Flow<ListEngineVersionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEngineVersionsPaginated.listEngineVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEngineVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEngineVersionsResponse]
 */
public fun M2Client.listEngineVersionsPaginated(block: ListEngineVersionsRequest.Builder.() -> Unit): Flow<ListEngineVersionsResponse> =
    listEngineVersionsPaginated(ListEngineVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEngineVersionsPaginated]
 * to access the nested member [EngineVersionsSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EngineVersionsSummary]
 */
@JvmName("listEngineVersionsResponseEngineVersionsSummary")
public fun Flow<ListEngineVersionsResponse>.engineVersions(): Flow<EngineVersionsSummary> =
    transform() { response ->
        response.engineVersions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEnvironmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEnvironmentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnvironmentsResponse]
 */
public fun M2Client.listEnvironmentsPaginated(initialRequest: ListEnvironmentsRequest = ListEnvironmentsRequest { }): Flow<ListEnvironmentsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEnvironmentsPaginated.listEnvironments(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEnvironmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnvironmentsResponse]
 */
public fun M2Client.listEnvironmentsPaginated(block: ListEnvironmentsRequest.Builder.() -> Unit): Flow<ListEnvironmentsResponse> =
    listEnvironmentsPaginated(ListEnvironmentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEnvironmentsPaginated]
 * to access the nested member [EnvironmentSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EnvironmentSummary]
 */
@JvmName("listEnvironmentsResponseEnvironmentSummary")
public fun Flow<ListEnvironmentsResponse>.environments(): Flow<EnvironmentSummary> =
    transform() { response ->
        response.environments?.forEach {
            emit(it)
        }
    }
