// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines an alternate key. This value is optional. A legacy data set might not have any alternate key defined but if those alternate keys definitions exist, provide them, as some applications will make use of them.
 */
public class AlternateKey private constructor(builder: Builder) {
    /**
     * Indicates whether the alternate key values are supposed to be unique for the given data set.
     */
    public val allowDuplicates: kotlin.Boolean = builder.allowDuplicates
    /**
     * A strictly positive integer value representing the length of the alternate key.
     */
    public val length: kotlin.Int = builder.length
    /**
     * The name of the alternate key.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A positive integer value representing the offset to mark the start of the alternate key part in the record byte array.
     */
    public val offset: kotlin.Int = builder.offset

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.m2.model.AlternateKey = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AlternateKey(")
        append("allowDuplicates=$allowDuplicates,")
        append("length=$length,")
        append("name=$name,")
        append("offset=$offset")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowDuplicates.hashCode()
        result = 31 * result + (length)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (offset)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AlternateKey

        if (allowDuplicates != other.allowDuplicates) return false
        if (length != other.length) return false
        if (name != other.name) return false
        if (offset != other.offset) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.m2.model.AlternateKey = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether the alternate key values are supposed to be unique for the given data set.
         */
        public var allowDuplicates: kotlin.Boolean = false
        /**
         * A strictly positive integer value representing the length of the alternate key.
         */
        public var length: kotlin.Int = 0
        /**
         * The name of the alternate key.
         */
        public var name: kotlin.String? = null
        /**
         * A positive integer value representing the offset to mark the start of the alternate key part in the record byte array.
         */
        public var offset: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.m2.model.AlternateKey) : this() {
            this.allowDuplicates = x.allowDuplicates
            this.length = x.length
            this.name = x.name
            this.offset = x.offset
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.m2.model.AlternateKey = AlternateKey(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
