// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.serde

import aws.sdk.kotlin.services.m2.model.EngineType
import aws.sdk.kotlin.services.m2.model.EnvironmentLifecycle
import aws.sdk.kotlin.services.m2.model.GetEnvironmentResponse
import aws.sdk.kotlin.services.m2.model.HighAvailabilityConfig
import aws.sdk.kotlin.services.m2.model.M2Exception
import aws.sdk.kotlin.services.m2.model.NetworkType
import aws.sdk.kotlin.services.m2.model.PendingMaintenance
import aws.sdk.kotlin.services.m2.model.StorageConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetEnvironmentOperationDeserializer: HttpDeserializer.NonStreaming<GetEnvironmentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetEnvironmentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetEnvironmentError(context, call, payload)
        }
        val builder = GetEnvironmentResponse.Builder()

        if (payload != null) {
            deserializeGetEnvironmentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetEnvironmentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw M2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> M2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetEnvironmentOperationBody(builder: GetEnvironmentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTUALCAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("actualCapacity"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ENGINETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("engineType"))
    val ENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("engineVersion"))
    val ENVIRONMENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("environmentArn"))
    val ENVIRONMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("environmentId"))
    val HIGHAVAILABILITYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("highAvailabilityConfig"))
    val INSTANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("instanceType"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsKeyId"))
    val LOADBALANCERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("loadBalancerArn"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val NETWORKTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("networkType"))
    val PENDINGMAINTENANCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("pendingMaintenance"))
    val PREFERREDMAINTENANCEWINDOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("preferredMaintenanceWindow"))
    val PUBLICLYACCESSIBLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("publiclyAccessible"))
    val SECURITYGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("securityGroupIds"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusReason"))
    val STORAGECONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("storageConfigurations"))
    val SUBNETIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("subnetIds"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val VPCID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vpcId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTUALCAPACITY_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENGINETYPE_DESCRIPTOR)
        field(ENGINEVERSION_DESCRIPTOR)
        field(ENVIRONMENTARN_DESCRIPTOR)
        field(ENVIRONMENTID_DESCRIPTOR)
        field(HIGHAVAILABILITYCONFIG_DESCRIPTOR)
        field(INSTANCETYPE_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(LOADBALANCERARN_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(NETWORKTYPE_DESCRIPTOR)
        field(PENDINGMAINTENANCE_DESCRIPTOR)
        field(PREFERREDMAINTENANCEWINDOW_DESCRIPTOR)
        field(PUBLICLYACCESSIBLE_DESCRIPTOR)
        field(SECURITYGROUPIDS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
        field(STORAGECONFIGURATIONS_DESCRIPTOR)
        field(SUBNETIDS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VPCID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTUALCAPACITY_DESCRIPTOR.index -> builder.actualCapacity = deserializeInt()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENGINETYPE_DESCRIPTOR.index -> builder.engineType = deserializeString().let { EngineType.fromValue(it) }
                ENGINEVERSION_DESCRIPTOR.index -> builder.engineVersion = deserializeString()
                ENVIRONMENTARN_DESCRIPTOR.index -> builder.environmentArn = deserializeString()
                ENVIRONMENTID_DESCRIPTOR.index -> builder.environmentId = deserializeString()
                HIGHAVAILABILITYCONFIG_DESCRIPTOR.index -> builder.highAvailabilityConfig = deserializeHighAvailabilityConfigDocument(deserializer)
                INSTANCETYPE_DESCRIPTOR.index -> builder.instanceType = deserializeString()
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                LOADBALANCERARN_DESCRIPTOR.index -> builder.loadBalancerArn = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                NETWORKTYPE_DESCRIPTOR.index -> builder.networkType = deserializeString().let { NetworkType.fromValue(it) }
                PENDINGMAINTENANCE_DESCRIPTOR.index -> builder.pendingMaintenance = deserializePendingMaintenanceDocument(deserializer)
                PREFERREDMAINTENANCEWINDOW_DESCRIPTOR.index -> builder.preferredMaintenanceWindow = deserializeString()
                PUBLICLYACCESSIBLE_DESCRIPTOR.index -> builder.publiclyAccessible = deserializeBoolean()
                SECURITYGROUPIDS_DESCRIPTOR.index -> builder.securityGroupIds =
                    deserializer.deserializeList(SECURITYGROUPIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { EnvironmentLifecycle.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                STORAGECONFIGURATIONS_DESCRIPTOR.index -> builder.storageConfigurations =
                    deserializer.deserializeList(STORAGECONFIGURATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<StorageConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeStorageConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUBNETIDS_DESCRIPTOR.index -> builder.subnetIds =
                    deserializer.deserializeList(SUBNETIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                VPCID_DESCRIPTOR.index -> builder.vpcId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
