// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.serde

import aws.sdk.kotlin.services.m2.model.DatasetDetailOrgAttributes
import aws.sdk.kotlin.services.m2.model.GetDataSetDetailsResponse
import aws.sdk.kotlin.services.m2.model.M2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetDataSetDetailsOperationDeserializer: HttpDeserializer.NonStreaming<GetDataSetDetailsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetDataSetDetailsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetDataSetDetailsError(context, call, payload)
        }
        val builder = GetDataSetDetailsResponse.Builder()

        if (payload != null) {
            deserializeGetDataSetDetailsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetDataSetDetailsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw M2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ExecutionTimeoutException" -> ExecutionTimeoutExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> M2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDataSetDetailsOperationBody(builder: GetDataSetDetailsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BLOCKSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("blocksize"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val DATASETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dataSetName"))
    val DATASETORG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dataSetOrg"))
    val FILESIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("fileSize"))
    val LASTREFERENCEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastReferencedTime"))
    val LASTUPDATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedTime"))
    val LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("location"))
    val RECORDLENGTH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("recordLength"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BLOCKSIZE_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DATASETNAME_DESCRIPTOR)
        field(DATASETORG_DESCRIPTOR)
        field(FILESIZE_DESCRIPTOR)
        field(LASTREFERENCEDTIME_DESCRIPTOR)
        field(LASTUPDATEDTIME_DESCRIPTOR)
        field(LOCATION_DESCRIPTOR)
        field(RECORDLENGTH_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BLOCKSIZE_DESCRIPTOR.index -> builder.blocksize = deserializeInt()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DATASETNAME_DESCRIPTOR.index -> builder.dataSetName = deserializeString()
                DATASETORG_DESCRIPTOR.index -> builder.dataSetOrg = deserializeDatasetDetailOrgAttributesDocument(deserializer)
                FILESIZE_DESCRIPTOR.index -> builder.fileSize = deserializeLong()
                LASTREFERENCEDTIME_DESCRIPTOR.index -> builder.lastReferencedTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LASTUPDATEDTIME_DESCRIPTOR.index -> builder.lastUpdatedTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LOCATION_DESCRIPTOR.index -> builder.location = deserializeString()
                RECORDLENGTH_DESCRIPTOR.index -> builder.recordLength = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
