// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateApplicationRequest private constructor(builder: Builder) {
    /**
     * A client token is a unique, case-sensitive string of up to 128 ASCII characters with ASCII values of 33-126 inclusive. It's generated by the client to ensure idempotent operations, allowing for safe retries without unintended side effects.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The application definition for this application. You can specify either inline JSON or an S3 bucket location.
     */
    public val definition: aws.sdk.kotlin.services.m2.model.Definition? = builder.definition
    /**
     * The description of the application.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The type of the target platform for this application.
     */
    public val engineType: aws.sdk.kotlin.services.m2.model.EngineType = requireNotNull(builder.engineType) { "A non-null value must be provided for engineType" }
    /**
     * The identifier of a customer managed key.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The unique identifier of the application.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The Amazon Resource Name (ARN) that identifies a role that the application uses to access Amazon Web Services resources that are not part of the application or are in a different Amazon Web Services account.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * A list of tags to apply to the application.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.m2.model.CreateApplicationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateApplicationRequest(")
        append("clientToken=$clientToken,")
        append("definition=$definition,")
        append("description=$description,")
        append("engineType=$engineType,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (definition?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engineType.hashCode())
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateApplicationRequest

        if (clientToken != other.clientToken) return false
        if (definition != other.definition) return false
        if (description != other.description) return false
        if (engineType != other.engineType) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.m2.model.CreateApplicationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A client token is a unique, case-sensitive string of up to 128 ASCII characters with ASCII values of 33-126 inclusive. It's generated by the client to ensure idempotent operations, allowing for safe retries without unintended side effects.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The application definition for this application. You can specify either inline JSON or an S3 bucket location.
         */
        public var definition: aws.sdk.kotlin.services.m2.model.Definition? = null
        /**
         * The description of the application.
         */
        public var description: kotlin.String? = null
        /**
         * The type of the target platform for this application.
         */
        public var engineType: aws.sdk.kotlin.services.m2.model.EngineType? = null
        /**
         * The identifier of a customer managed key.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The unique identifier of the application.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) that identifies a role that the application uses to access Amazon Web Services resources that are not part of the application or are in a different Amazon Web Services account.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A list of tags to apply to the application.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.m2.model.CreateApplicationRequest) : this() {
            this.clientToken = x.clientToken
            this.definition = x.definition
            this.description = x.description
            this.engineType = x.engineType
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.roleArn = x.roleArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.m2.model.CreateApplicationRequest = CreateApplicationRequest(this)

        internal fun correctErrors(): Builder {
            if (engineType == null) engineType = EngineType.SdkUnknown("no value provided")
            if (name == null) name = ""
            return this
        }
    }
}
