// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.serde

import aws.sdk.kotlin.services.m2.model.BatchJobExecutionStatus
import aws.sdk.kotlin.services.m2.model.BatchJobIdentifier
import aws.sdk.kotlin.services.m2.model.BatchJobType
import aws.sdk.kotlin.services.m2.model.GetBatchJobExecutionResponse
import aws.sdk.kotlin.services.m2.model.JobStepRestartMarker
import aws.sdk.kotlin.services.m2.model.M2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetBatchJobExecutionOperationDeserializer: HttpDeserializer.NonStreaming<GetBatchJobExecutionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetBatchJobExecutionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetBatchJobExecutionError(context, call, payload)
        }
        val builder = GetBatchJobExecutionResponse.Builder()

        if (payload != null) {
            deserializeGetBatchJobExecutionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetBatchJobExecutionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw M2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> M2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBatchJobExecutionOperationBody(builder: GetBatchJobExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("applicationId"))
    val BATCHJOBIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("batchJobIdentifier"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endTime"))
    val EXECUTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("executionId"))
    val JOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobId"))
    val JOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobName"))
    val JOBSTEPRESTARTMARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("jobStepRestartMarker"))
    val JOBTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobType"))
    val JOBUSER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobUser"))
    val RETURNCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("returnCode"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusReason"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONID_DESCRIPTOR)
        field(BATCHJOBIDENTIFIER_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(EXECUTIONID_DESCRIPTOR)
        field(JOBID_DESCRIPTOR)
        field(JOBNAME_DESCRIPTOR)
        field(JOBSTEPRESTARTMARKER_DESCRIPTOR)
        field(JOBTYPE_DESCRIPTOR)
        field(JOBUSER_DESCRIPTOR)
        field(RETURNCODE_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONID_DESCRIPTOR.index -> builder.applicationId = deserializeString()
                BATCHJOBIDENTIFIER_DESCRIPTOR.index -> builder.batchJobIdentifier = deserializeBatchJobIdentifierDocument(deserializer)
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                EXECUTIONID_DESCRIPTOR.index -> builder.executionId = deserializeString()
                JOBID_DESCRIPTOR.index -> builder.jobId = deserializeString()
                JOBNAME_DESCRIPTOR.index -> builder.jobName = deserializeString()
                JOBSTEPRESTARTMARKER_DESCRIPTOR.index -> builder.jobStepRestartMarker = deserializeJobStepRestartMarkerDocument(deserializer)
                JOBTYPE_DESCRIPTOR.index -> builder.jobType = deserializeString().let { BatchJobType.fromValue(it) }
                JOBUSER_DESCRIPTOR.index -> builder.jobUser = deserializeString()
                RETURNCODE_DESCRIPTOR.index -> builder.returnCode = deserializeString()
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { BatchJobExecutionStatus.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
