// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines a data set.
 */
public class DataSet private constructor(builder: Builder) {
    /**
     * The logical identifier for a specific data set (in mainframe format).
     */
    public val datasetName: kotlin.String = requireNotNull(builder.datasetName) { "A non-null value must be provided for datasetName" }
    /**
     * The type of dataset. The only supported value is VSAM.
     */
    public val datasetOrg: aws.sdk.kotlin.services.m2.model.DatasetOrgAttributes? = builder.datasetOrg
    /**
     * The length of a record.
     */
    public val recordLength: aws.sdk.kotlin.services.m2.model.RecordLength? = builder.recordLength
    /**
     * The relative location of the data set in the database or file system.
     */
    public val relativePath: kotlin.String? = builder.relativePath
    /**
     * The storage type of the data set: database or file system. For Micro Focus, database corresponds to datastore and file system corresponds to EFS/FSX. For Blu Age, there is no support of file system and database corresponds to Blusam.
     */
    public val storageType: kotlin.String? = builder.storageType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.m2.model.DataSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSet(")
        append("datasetName=$datasetName,")
        append("datasetOrg=$datasetOrg,")
        append("recordLength=$recordLength,")
        append("relativePath=$relativePath,")
        append("storageType=$storageType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = datasetName.hashCode()
        result = 31 * result + (datasetOrg?.hashCode() ?: 0)
        result = 31 * result + (recordLength?.hashCode() ?: 0)
        result = 31 * result + (relativePath?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSet

        if (datasetName != other.datasetName) return false
        if (datasetOrg != other.datasetOrg) return false
        if (recordLength != other.recordLength) return false
        if (relativePath != other.relativePath) return false
        if (storageType != other.storageType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.m2.model.DataSet = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The logical identifier for a specific data set (in mainframe format).
         */
        public var datasetName: kotlin.String? = null
        /**
         * The type of dataset. The only supported value is VSAM.
         */
        public var datasetOrg: aws.sdk.kotlin.services.m2.model.DatasetOrgAttributes? = null
        /**
         * The length of a record.
         */
        public var recordLength: aws.sdk.kotlin.services.m2.model.RecordLength? = null
        /**
         * The relative location of the data set in the database or file system.
         */
        public var relativePath: kotlin.String? = null
        /**
         * The storage type of the data set: database or file system. For Micro Focus, database corresponds to datastore and file system corresponds to EFS/FSX. For Blu Age, there is no support of file system and database corresponds to Blusam.
         */
        public var storageType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.m2.model.DataSet) : this() {
            this.datasetName = x.datasetName
            this.datasetOrg = x.datasetOrg
            this.recordLength = x.recordLength
            this.relativePath = x.relativePath
            this.storageType = x.storageType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.m2.model.DataSet = DataSet(this)

        /**
         * construct an [aws.sdk.kotlin.services.m2.model.RecordLength] inside the given [block]
         */
        public fun recordLength(block: aws.sdk.kotlin.services.m2.model.RecordLength.Builder.() -> kotlin.Unit) {
            this.recordLength = aws.sdk.kotlin.services.m2.model.RecordLength.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (datasetName == null) datasetName = ""
            return this
        }
    }
}
